/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.tablist;

import com.mojang.authlib.GameProfile;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.platforms.bukkit.tablist.PacketTabList18;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.jetbrains.annotations.Nullable;

public class PacketTabList1193
extends PacketTabList18 {
    private static final Map<TabList.Action, EnumSet<?>> actionToEnumSet = new EnumMap(TabList.Action.class);
    private static Enum actionAddPlayer;
    private static Enum actionUpdateDisplayName;
    private static Enum actionUpdateLatency;
    private static Constructor<?> newRemovePacket;
    private static Field PlayerInfoData_UUID;
    private static Field PlayerInfoData_GameMode;
    private static Field PlayerInfoData_Listed;
    private static Field PlayerInfoData_RemoteChatSession;

    public PacketTabList1193(@NonNull BukkitTabPlayer player) {
        super(player);
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
    }

    public static void loadNew() throws ReflectiveOperationException {
        Class<?> IChatBaseComponent = BukkitReflection.getClass("network.chat.Component", "network.chat.IChatBaseComponent", "IChatBaseComponent");
        Class<?> RemoteChatSession$Data = BukkitReflection.getClass("network.chat.RemoteChatSession$Data", "network.chat.RemoteChatSession$a");
        Class<Enum> EnumGamemodeClass = BukkitReflection.getClass("world.level.GameType", "world.level.EnumGamemode");
        ActionClass = BukkitReflection.getClass("network.protocol.game.ClientboundPlayerInfoUpdatePacket$Action", "network.protocol.game.ClientboundPlayerInfoUpdatePacket$a");
        PlayerInfoClass = BukkitReflection.getClass("network.protocol.game.ClientboundPlayerInfoUpdatePacket");
        Class<?> playerInfoDataClass = BukkitReflection.getClass("network.protocol.game.ClientboundPlayerInfoUpdatePacket$Entry", "network.protocol.game.ClientboundPlayerInfoUpdatePacket$b");
        newPlayerInfo = PlayerInfoClass.getConstructor(EnumSet.class, Collection.class);
        ACTION = ReflectionUtils.getOnlyField(PlayerInfoClass, EnumSet.class);
        PacketTabList1193.loadSharedContent(playerInfoDataClass, EnumGamemodeClass);
        newPlayerInfoData = playerInfoDataClass.getConstructor(UUID.class, GameProfile.class, Boolean.TYPE, Integer.TYPE, EnumGamemodeClass, IChatBaseComponent, RemoteChatSession$Data);
        PlayerInfoData_Listed = ReflectionUtils.getOnlyField(playerInfoDataClass, Boolean.TYPE);
        PlayerInfoData_GameMode = ReflectionUtils.getOnlyField(playerInfoDataClass, EnumGamemodeClass);
        PlayerInfoData_RemoteChatSession = ReflectionUtils.getOnlyField(playerInfoDataClass, RemoteChatSession$Data);
        PlayerInfoData_UUID = ReflectionUtils.getOnlyField(playerInfoDataClass, UUID.class);
        newRemovePacket = BukkitReflection.getClass("network.protocol.game.ClientboundPlayerInfoRemovePacket").getConstructor(List.class);
        actionAddPlayer = Enum.valueOf(ActionClass, TabList.Action.ADD_PLAYER.name());
        actionUpdateDisplayName = Enum.valueOf(ActionClass, TabList.Action.UPDATE_DISPLAY_NAME.name());
        actionUpdateLatency = Enum.valueOf(ActionClass, TabList.Action.UPDATE_LATENCY.name());
        actionToEnumSet.put(TabList.Action.ADD_PLAYER, EnumSet.allOf(ActionClass));
        actionToEnumSet.put(TabList.Action.UPDATE_GAME_MODE, EnumSet.of(Enum.valueOf(ActionClass, TabList.Action.UPDATE_GAME_MODE.name())));
        actionToEnumSet.put(TabList.Action.UPDATE_DISPLAY_NAME, EnumSet.of(actionUpdateDisplayName));
        actionToEnumSet.put(TabList.Action.UPDATE_LATENCY, EnumSet.of(actionUpdateLatency));
        actionToEnumSet.put(TabList.Action.UPDATE_LISTED, EnumSet.of(Enum.valueOf(ActionClass, TabList.Action.UPDATE_LISTED.name())));
    }

    @Override
    public void removeEntry(@NonNull UUID entry) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        packetSender.sendPacket(((BukkitTabPlayer)this.player).getPlayer(), newRemovePacket.newInstance(Collections.singletonList(entry)));
    }

    @Override
    public void updateListed(@NonNull UUID entry, boolean listed) {
        if (entry == null) {
            throw new NullPointerException("entry is marked non-null but is null");
        }
        packetSender.sendPacket(((BukkitTabPlayer)this.player).getPlayer(), this.createPacket(TabList.Action.UPDATE_LISTED, entry, "", null, listed, 0, 0, null));
    }

    @Override
    @NonNull
    public Object createPacket(@NonNull TabList.Action action, @NonNull UUID id, @NonNull String name, @Nullable TabList.Skin skin, boolean listed, int latency, int gameMode, @Nullable Object displayName) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        Object packet = newPlayerInfo.newInstance(actionToEnumSet.get((Object)action), Collections.emptyList());
        PLAYERS.set(packet, Collections.singletonList(newPlayerInfoData.newInstance(id, action == TabList.Action.ADD_PLAYER ? this.createProfile(id, name, skin) : null, listed, latency, gameModes[gameMode], displayName, null)));
        return packet;
    }

    @Override
    public void onPacketSend(@NonNull Object packet) {
        if (packet == null) {
            throw new NullPointerException("packet is marked non-null but is null");
        }
        if (!PlayerInfoClass.isInstance(packet)) {
            return;
        }
        EnumSet actions = (EnumSet)ACTION.get(packet);
        ArrayList updatedList = new ArrayList();
        boolean rewritePacket = false;
        for (Object nmsData : (List)PLAYERS.get(packet)) {
            int newLatency;
            Object expectedName;
            boolean rewriteEntry = false;
            UUID id = (UUID)PlayerInfoData_UUID.get(nmsData);
            GameProfile profile = (GameProfile)PlayerInfoData_Profile.get(nmsData);
            Object displayName = PlayerInfoData_DisplayName.get(nmsData);
            int latency = PlayerInfoData_Latency.getInt(nmsData);
            if (actions.contains(actionUpdateDisplayName) && (expectedName = this.getExpectedDisplayName(id)) != null && expectedName != displayName) {
                displayName = expectedName;
                rewritePacket = true;
                rewriteEntry = true;
            }
            if (actions.contains(actionUpdateLatency) && (newLatency = TAB.getInstance().getFeatureManager().onLatencyChange(this.player, id, latency)) != latency) {
                latency = newLatency;
                rewritePacket = true;
                rewriteEntry = true;
            }
            if (actions.contains(actionAddPlayer)) {
                TAB.getInstance().getFeatureManager().onEntryAdd(this.player, id, profile.getName());
            }
            updatedList.add(rewriteEntry ? newPlayerInfoData.newInstance(id, profile, PlayerInfoData_Listed.getBoolean(nmsData), latency, PlayerInfoData_GameMode.get(nmsData), displayName, PlayerInfoData_RemoteChatSession.get(nmsData)) : nmsData);
        }
        if (rewritePacket) {
            PLAYERS.set(packet, updatedList);
        }
    }
}

