/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.backend.features.unlimitedtags;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.backend.Location;
import me.neznamy.tab.shared.backend.features.unlimitedtags.ArmorStand;
import me.neznamy.tab.shared.backend.features.unlimitedtags.BackendNameTagX;
import me.neznamy.tab.shared.features.nametags.unlimited.ArmorStandManager;
import me.neznamy.tab.shared.features.nametags.unlimited.NameTagX;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class BackendArmorStandManager
implements ArmorStandManager {
    private final double SPACE_BETWEEN_LINES = 0.26;
    private final BackendNameTagX nameTagX;
    private final TabPlayer owner;
    private boolean sneaking;
    private final ArmorStand[] armorStandArray;
    private final List<BackendTabPlayer> nearbyPlayerList = new ArrayList<BackendTabPlayer>();
    private BackendTabPlayer[] nearbyPlayers = new BackendTabPlayer[0];

    public BackendArmorStandManager(@NotNull NameTagX nameTagX, @NotNull TabPlayer owner) {
        this.nameTagX = (BackendNameTagX)nameTagX;
        this.owner = owner;
        this.sneaking = this.nameTagX.isSneaking(owner);
        owner.setProperty(nameTagX, "nametag", owner.getProperty("tagprefix").getCurrentRawValue() + owner.getProperty("customtagname").getCurrentRawValue() + owner.getProperty("tagsuffix").getCurrentRawValue());
        double height = 0.0;
        ArrayList<ArmorStand> armorStands = new ArrayList<ArmorStand>();
        for (String string : nameTagX.getDynamicLines()) {
            armorStands.add(new ArmorStand((BackendNameTagX)nameTagX, this, owner, string, height, false));
            height += 0.26;
        }
        for (Map.Entry entry : nameTagX.getStaticLines().entrySet()) {
            armorStands.add(new ArmorStand((BackendNameTagX)nameTagX, this, owner, (String)entry.getKey(), Double.parseDouble(entry.getValue().toString()), true));
        }
        this.armorStandArray = armorStands.toArray(new ArmorStand[0]);
        this.fixArmorStandHeights();
    }

    public void teleport(@NotNull BackendTabPlayer viewer) {
        for (ArmorStand a : this.armorStandArray) {
            a.teleport(viewer);
        }
    }

    public void move(@NotNull BackendTabPlayer viewer, @NotNull Location diff) {
        for (ArmorStand a : this.armorStandArray) {
            a.move(viewer, diff);
        }
    }

    public void teleport() {
        for (ArmorStand a : this.armorStandArray) {
            a.teleport();
        }
    }

    public boolean isNearby(@NotNull BackendTabPlayer viewer) {
        return this.nearbyPlayerList.contains(viewer);
    }

    public void sneak(boolean sneaking) {
        this.sneaking = sneaking;
        if (this.nameTagX.isFlying(this.owner)) {
            this.updateMetadata();
            return;
        }
        for (BackendTabPlayer viewer : this.nearbyPlayers) {
            if (viewer.getVersion().getMinorVersion() == 14 && !this.nameTagX.isArmorStandsAlwaysVisible()) {
                if (sneaking) {
                    this.destroy(viewer);
                    continue;
                }
                this.spawn(viewer);
                continue;
            }
            this.respawn(viewer);
        }
    }

    public void respawn() {
        for (BackendTabPlayer viewer : this.nearbyPlayers) {
            this.respawn(viewer);
        }
    }

    public void respawn(@NotNull BackendTabPlayer viewer) {
        for (ArmorStand as : this.armorStandArray) {
            viewer.getEntityView().destroyEntities(as.getEntityId());
        }
        for (ArmorStand a : this.armorStandArray) {
            a.spawn(viewer);
        }
    }

    public void spawn(@NotNull BackendTabPlayer viewer) {
        this.nearbyPlayerList.add(viewer);
        this.nearbyPlayers = this.nearbyPlayerList.toArray(new BackendTabPlayer[0]);
        if (viewer.getVersion().getMinorVersion() < 8) {
            return;
        }
        for (ArmorStand a : this.armorStandArray) {
            a.spawn(viewer);
        }
    }

    public void fixArmorStandHeights() {
        double currentY = -0.26;
        for (ArmorStand as : this.armorStandArray) {
            if (as.isStaticOffset() || as.getProperty().get().isEmpty()) continue;
            as.setOffset(currentY += 0.26);
        }
    }

    public void unregisterPlayer(@NotNull BackendTabPlayer viewer) {
        if (this.nearbyPlayerList.remove(viewer)) {
            this.nearbyPlayers = this.nearbyPlayerList.toArray(new BackendTabPlayer[0]);
        }
    }

    public void updateVisibility(boolean force) {
        for (ArmorStand a : this.armorStandArray) {
            a.updateVisibility(force);
        }
    }

    public void destroy(@NotNull BackendTabPlayer viewer) {
        for (ArmorStand as : this.armorStandArray) {
            viewer.getEntityView().destroyEntities(as.getEntityId());
        }
        this.unregisterPlayer(viewer);
    }

    @Override
    public void destroy() {
        for (BackendTabPlayer viewer : this.nearbyPlayers) {
            for (ArmorStand as : this.armorStandArray) {
                viewer.getEntityView().destroyEntities(as.getEntityId());
            }
        }
        this.nearbyPlayerList.clear();
        this.nearbyPlayers = new BackendTabPlayer[0];
    }

    @Override
    public void refresh(boolean force) {
        boolean fix = false;
        for (ArmorStand as : this.armorStandArray) {
            if (!as.getProperty().update() && !force) continue;
            as.refresh();
            fix = true;
        }
        if (fix) {
            this.fixArmorStandHeights();
        }
    }

    public void updateMetadata() {
        for (BackendTabPlayer viewer : this.nearbyPlayers) {
            this.updateMetadata(viewer);
        }
    }

    public void updateMetadata(@NotNull BackendTabPlayer viewer) {
        for (ArmorStand a : this.armorStandArray) {
            viewer.getEntityView().updateEntityMetadata(a.entityId, a.createDataWatcher(a.getProperty().getFormat(viewer), viewer));
        }
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public BackendTabPlayer[] getNearbyPlayers() {
        return this.nearbyPlayers;
    }
}

