/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.RowSetProvider;
import lombok.NonNull;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.SimpleComponent;
import org.jetbrains.annotations.NotNull;

public class MySQL {
    private Connection con;
    @NotNull
    private final String host;
    private final int port;
    @NotNull
    private final String database;
    @NotNull
    private final String username;
    @NotNull
    private final String password;
    private final boolean useSSL;

    public void openConnection() throws SQLException {
        if (this.isConnected()) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("user", this.username);
        properties.setProperty("password", this.password);
        properties.setProperty("useSSL", String.valueOf(this.useSSL));
        properties.setProperty("characterEncoding", "UTF-8");
        this.con = DriverManager.getConnection(String.format("jdbc:mysql://%s:%d/%s", this.host, this.port, this.database), properties);
        TAB.getInstance().getPlatform().logInfo(new SimpleComponent((Object)((Object)EnumChatFormat.GREEN) + "Successfully connected to MySQL"));
    }

    public void closeConnection() throws SQLException {
        if (this.isConnected()) {
            this.con.close();
        }
    }

    private boolean isConnected() throws SQLException {
        return this.con != null && !this.con.isClosed();
    }

    public void execute(@NonNull String query, Object ... vars) throws SQLException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        try (PreparedStatement ps = this.prepareStatement(query, vars);){
            ps.execute();
        }
    }

    private PreparedStatement prepareStatement(@NonNull String query, Object ... vars) throws SQLException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (!this.isConnected()) {
            this.openConnection();
        }
        PreparedStatement ps = this.con.prepareStatement(query);
        int i = 0;
        if (query.contains("?")) {
            for (Object obj : vars) {
                ps.setObject(++i, obj);
            }
        }
        return ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedRowSet getCRS(@NonNull String query, Object ... vars) throws SQLException {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        PreparedStatement ps = this.prepareStatement(query, vars);
        ResultSet rs = ps.executeQuery();
        try {
            CachedRowSet crs = RowSetProvider.newFactory().createCachedRowSet();
            crs.populate(rs);
            CachedRowSet cachedRowSet = crs;
            return cachedRowSet;
        }
        finally {
            rs.close();
            ps.close();
        }
    }

    public MySQL(@NotNull String host, int port, @NotNull String database, @NotNull String username, @NotNull String password, boolean useSSL) {
        if (host == null) {
            throw new NullPointerException("host is marked non-null but is null");
        }
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (username == null) {
            throw new NullPointerException("username is marked non-null but is null");
        }
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        this.host = host;
        this.port = port;
        this.database = database;
        this.username = username;
        this.password = password;
        this.useSSL = useSSL;
    }
}

