/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout;

import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.layout.LayoutManagerImpl;
import me.neznamy.tab.shared.features.layout.PlayerSlot;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class LayoutLatencyRefresher
extends TabFeature
implements Refreshable {
    @NotNull
    private final LayoutManagerImpl manager;

    public LayoutLatencyRefresher(@NotNull LayoutManagerImpl manager) {
        this.manager = manager;
        this.addUsedPlaceholder("%ping%");
    }

    @Override
    public void refresh(@NotNull TabPlayer p, boolean force) {
        for (TabPlayer all : TAB.getInstance().getOnlinePlayers()) {
            PlayerSlot slot;
            if (all.getVersion().getMinorVersion() < 8 || all.layoutData.view == null || (slot = all.layoutData.view.getSlot(p)) == null) continue;
            all.getTabList().updateLatency(slot.getUniqueId(), p.getPing());
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating latency";
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return this.manager.getFeatureName();
    }
}

