/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.api.tablist.layout.Layout;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.features.layout.FixedSlot;
import me.neznamy.tab.shared.features.layout.GroupPattern;
import me.neznamy.tab.shared.features.layout.LayoutManagerImpl;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutPattern
extends TabFeature
implements Refreshable,
Layout {
    @NotNull
    private final LayoutManagerImpl manager;
    @NotNull
    private final String name;
    @Nullable
    private final Condition condition;
    private final Map<Integer, FixedSlot> fixedSlots = new HashMap<Integer, FixedSlot>();
    private final List<GroupPattern> groups = new ArrayList<GroupPattern>();

    public LayoutPattern(@NotNull LayoutManagerImpl manager, @NotNull String name, @NotNull Map<String, Object> map) {
        this.manager = manager;
        this.name = name;
        TAB.getInstance().getConfigHelper().startup().checkLayoutMap(name, map);
        this.condition = Condition.getCondition((String)map.get("condition"));
        if (this.condition != null) {
            manager.addUsedPlaceholder(TabConstants.Placeholder.condition(this.condition.getName()));
        }
        for (String fixedSlot : map.getOrDefault("fixed-slots", Collections.emptyList())) {
            this.addFixedSlot(fixedSlot);
        }
        Map groups = map.getOrDefault("groups", Collections.emptyMap());
        if (groups != null) {
            for (Map.Entry group : groups.entrySet()) {
                String groupName = (String)group.getKey();
                Map groupData = (Map)group.getValue();
                TAB.getInstance().getConfigHelper().startup().checkLayoutGroupMap(name, groupName, groupData);
                ArrayList<Integer> positions = new ArrayList<Integer>();
                for (String line : (List)groupData.get("slots")) {
                    String[] arr = line.split("-");
                    int from = Integer.parseInt(arr[0]);
                    int to = arr.length == 1 ? from : Integer.parseInt(arr[1]);
                    for (int i2 = from; i2 <= to; ++i2) {
                        positions.add(i2);
                    }
                }
                this.addGroup(groupName, Condition.getCondition((String)groupData.get("condition")), positions.stream().mapToInt(i -> i).toArray());
            }
        }
        TAB.getInstance().getConfigHelper().startup().checkLayoutGroups(name, this.groups);
    }

    public void addFixedSlot(@NotNull String lineDefinition) {
        FixedSlot slot = FixedSlot.fromLine(lineDefinition, this, this.manager);
        if (slot != null) {
            this.fixedSlots.put(slot.getSlot(), slot);
        }
    }

    public void addGroup(@NotNull String name, @Nullable Condition condition, int[] slots) {
        this.groups.add(new GroupPattern(name, condition, Arrays.stream(slots).filter(slot -> !this.fixedSlots.containsKey(slot)).toArray()));
        if (condition != null) {
            this.addUsedPlaceholder(TabConstants.Placeholder.condition(condition.getName()));
        }
    }

    public boolean isConditionMet(@NotNull TabPlayer p) {
        return this.condition == null || this.condition.isMet(p);
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        this.manager.tickAllLayouts();
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating player groups";
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return this.manager.getFeatureName();
    }

    @Override
    public void addFixedSlot(int slot, @NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.ensureActive();
        this.addFixedSlot(slot, text, this.manager.getDefaultSkin(slot), this.manager.getEmptySlotPing());
    }

    @Override
    public void addFixedSlot(int slot, @NonNull String text, @NonNull String skin) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (skin == null) {
            throw new NullPointerException("skin is marked non-null but is null");
        }
        this.ensureActive();
        this.addFixedSlot(slot, text, skin, this.manager.getEmptySlotPing());
    }

    @Override
    public void addFixedSlot(int slot, @NonNull String text, int ping) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.ensureActive();
        this.addFixedSlot(slot, text, this.manager.getDefaultSkin(slot), ping);
    }

    @Override
    public void addFixedSlot(int slot, @NonNull String text, @NonNull String skin, int ping) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        if (skin == null) {
            throw new NullPointerException("skin is marked non-null but is null");
        }
        this.ensureActive();
        this.fixedSlots.put(slot, new FixedSlot(this.manager, slot, this, this.manager.getUUID(slot), text, "Layout-" + text + "-SLOT-" + slot, skin, "Layout-" + text + "-SLOT-" + slot + "-skin", ping));
    }

    @Override
    public void addGroup(@Nullable String condition, int[] slots) {
        this.ensureActive();
        this.addGroup(UUID.randomUUID().toString(), Condition.getCondition(condition), slots);
    }

    @NotNull
    public LayoutManagerImpl getManager() {
        return this.manager;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Condition getCondition() {
        return this.condition;
    }

    public Map<Integer, FixedSlot> getFixedSlots() {
        return this.fixedSlots;
    }

    public List<GroupPattern> getGroups() {
        return this.groups;
    }
}

