/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.redis.feature;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.UUID;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.PlayerList;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.feature.RedisFeature;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class RedisPlayerList
extends RedisFeature {
    private final RedisSupport redisSupport;
    private final PlayerList playerList;

    public RedisPlayerList(@NotNull RedisSupport redisSupport, @NotNull PlayerList playerList) {
        this.redisSupport = redisSupport;
        this.playerList = playerList;
        redisSupport.registerMessage("tabformat", Update.class, () -> new Update());
    }

    @Override
    public void onJoin(@NotNull TabPlayer player) {
        if (player.getVersion().getMinorVersion() < 8) {
            return;
        }
        for (RedisPlayer redis : this.redisSupport.getRedisPlayers().values()) {
            player.getTabList().updateDisplayName(redis.getUniqueId(), redis.getTabFormat());
        }
    }

    @Override
    public void onJoin(@NotNull RedisPlayer player) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer.getVersion().getMinorVersion() < 8) continue;
            viewer.getTabList().updateDisplayName(player.getUniqueId(), player.getTabFormat());
        }
    }

    @Override
    public void onServerSwitch(@NotNull TabPlayer player) {
        this.onJoin(player);
    }

    @Override
    public void write(@NotNull ByteArrayDataOutput out, @NotNull TabPlayer player) {
        out.writeUTF(player.getProperty("tabprefix").get() + player.getProperty("customtabname").get() + player.getProperty("tabsuffix").get());
    }

    @Override
    public void read(@NotNull ByteArrayDataInput in, @NotNull RedisPlayer player) {
        player.setTabFormat(TabComponent.optimized(in.readUTF()));
    }

    @Override
    public void onVanishStatusChange(@NotNull RedisPlayer player) {
        if (player.isVanished()) {
            return;
        }
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            if (viewer.getVersion().getMinorVersion() < 8) continue;
            viewer.getTabList().updateDisplayName(player.getUniqueId(), player.getTabFormat());
        }
    }

    public PlayerList getPlayerList() {
        return this.playerList;
    }

    public class Update
    extends RedisMessage {
        private UUID playerId;
        private String format;

        @Override
        public void write(@NotNull ByteArrayDataOutput out) {
            this.writeUUID(out, this.playerId);
            out.writeUTF(this.format);
        }

        @Override
        public void read(@NotNull ByteArrayDataInput in) {
            this.playerId = this.readUUID(in);
            this.format = in.readUTF();
        }

        @Override
        public void process(@NotNull RedisSupport redisSupport) {
            RedisPlayer target = redisSupport.getRedisPlayers().get(this.playerId);
            if (target == null) {
                return;
            }
            target.setTabFormat(TabComponent.optimized(this.format));
            RedisPlayerList.this.onJoin(target);
        }

        public Update() {
        }

        public Update(UUID playerId, String format) {
            this.playerId = playerId;
            this.format = format;
        }
    }
}

