/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.redis.message;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.UUID;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import org.jetbrains.annotations.NotNull;

public class PlayerQuit
extends RedisMessage {
    private UUID playerId;

    @Override
    public void write(@NotNull ByteArrayDataOutput out) {
        this.writeUUID(out, this.playerId);
    }

    @Override
    public void read(@NotNull ByteArrayDataInput in) {
        this.playerId = this.readUUID(in);
    }

    @Override
    public void process(@NotNull RedisSupport redisSupport) {
        RedisPlayer target = redisSupport.getRedisPlayers().get(this.playerId);
        if (target == null) {
            return;
        }
        redisSupport.getFeatures().forEach(f -> f.onQuit(target));
        redisSupport.getRedisPlayers().remove(target.getUniqueId());
    }

    public PlayerQuit() {
    }

    public PlayerQuit(UUID playerId) {
        this.playerId = playerId;
    }
}

