/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.platform;

import java.util.UUID;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.platform.TabPlayer;
import me.neznamy.tab.shared.proxy.ProxyPlatform;
import org.jetbrains.annotations.NotNull;

public interface EventListener<T> {
    default public void join(@NotNull T player) {
        if (TAB.getInstance().isPluginDisabled()) {
            return;
        }
        TAB.getInstance().getCPUManager().runTask(() -> TAB.getInstance().getFeatureManager().onJoin(this.createPlayer(player)));
    }

    default public void quit(@NotNull UUID player) {
        if (TAB.getInstance().isPluginDisabled()) {
            return;
        }
        TAB.getInstance().getCPUManager().runTask(() -> TAB.getInstance().getFeatureManager().onQuit(TAB.getInstance().getPlayer(player)));
    }

    default public void worldChange(@NotNull UUID player, @NotNull String world) {
        if (TAB.getInstance().isPluginDisabled()) {
            return;
        }
        TAB.getInstance().getCPUManager().runTask(() -> TAB.getInstance().getFeatureManager().onWorldChange(player, world));
    }

    default public void pluginMessage(@NotNull UUID player, byte[] message) {
        TAB.getInstance().getCPUManager().runMeasuredTask("Plugin message handling", "Plugin Message processing", () -> ((ProxyPlatform)TAB.getInstance().getPlatform()).onPluginMessage(player, message));
    }

    default public void replacePlayer(UUID player, T newPlayer) {
        if (TAB.getInstance().isPluginDisabled()) {
            return;
        }
        TabPlayer p = TAB.getInstance().getPlayer(player);
        if (p == null) {
            return;
        }
        p.setPlayer(newPlayer);
    }

    default public boolean command(@NotNull UUID player, @NotNull String command) {
        if (TAB.getInstance().isPluginDisabled()) {
            return false;
        }
        return TAB.getInstance().getFeatureManager().onCommand(TAB.getInstance().getPlayer(player), command);
    }

    @NotNull
    public TabPlayer createPlayer(@NotNull T var1);
}

