/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.modules.scanner;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.api.IWorldLocation;
import io.sc3.plethora.api.WorldLocation;
import io.sc3.plethora.api.method.ArgumentExt;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.IContext;
import io.sc3.plethora.api.method.IUnbakedContext;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.module.SubtargetedModuleMethod;
import io.sc3.plethora.api.reference.BlockReference;
import io.sc3.plethora.core.ContextHelpers;
import io.sc3.plethora.gameplay.modules.RangeInfo;
import io.sc3.plethora.gameplay.registry.PlethoraModules;
import io.sc3.plethora.integration.vanilla.meta.block.BlockStateMeta;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ScannerMethods {
    public static final SubtargetedModuleMethod<IWorldLocation> SCAN = SubtargetedModuleMethod.of("scan", PlethoraModules.SCANNER_M, IWorldLocation.class, "function():table -- Scan all blocks in the vicinity", ScannerMethods::scan);
    public static final SubtargetedModuleMethod<IWorldLocation> GET_BLOCK_META = SubtargetedModuleMethod.of("getBlockMeta", PlethoraModules.SCANNER_M, IWorldLocation.class, "function(x:integer, y:integer, z:integer):table|nil -- -- Get metadata about a nearby block", ScannerMethods::getBlockMeta);

    private static FutureMethodResult scan(@Nonnull IUnbakedContext<IModuleContainer> unbaked, @Nonnull IArguments args) throws LuaException {
        ScannerMethodContext ctx = ScannerMethods.getContext(unbaked);
        class_1937 world = ctx.loc.getWorld();
        class_2338 pos = ctx.loc.getPos();
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        return ctx.context.getCostHandler().await((double)ctx.range.getBulkCost(), () -> FutureMethodResult.result(ScannerMethods.scan(world, x, y, z, ctx.range.getRange())));
    }

    private static List<Map<String, ?>> scan(class_1937 world, int x, int y, int z, int radius) {
        ArrayList result = new ArrayList();
        for (int oX = x - radius; oX <= x + radius; ++oX) {
            for (int oY = y - radius; oY <= y + radius; ++oY) {
                for (int oZ = z - radius; oZ <= z + radius; ++oZ) {
                    class_2338 subPos = class_2338.method_49637((double)oX, (double)oY, (double)oZ);
                    class_2680 block = world.method_8320(subPos);
                    HashMap<String, Object> data = new HashMap<String, Object>(6);
                    data.put("x", oX - x);
                    data.put("y", oY - y);
                    data.put("z", oZ - z);
                    class_2960 name = class_7923.field_41175.method_10221((Object)block.method_26204());
                    data.put("name", name.toString());
                    BlockStateMeta.fillBasicMeta(data, block);
                    result.add(data);
                }
            }
        }
        return result;
    }

    private static FutureMethodResult getBlockMeta(@Nonnull IUnbakedContext<IModuleContainer> unbaked, @Nonnull IArguments args) throws LuaException {
        ScannerMethodContext ctx = ScannerMethods.getContext(unbaked);
        int radius = ctx.range.getRange();
        int x = ArgumentExt.assertIntBetween(args, 0, -radius, radius, "X coordinate out of bounds (%s)");
        int y = ArgumentExt.assertIntBetween(args, 1, -radius, radius, "Y coordinate out of bounds (%s)");
        int z = ArgumentExt.assertIntBetween(args, 2, -radius, radius, "Z coordinate out of bounds (%s)");
        return FutureMethodResult.result(ctx.context.makeChild(new BlockReference(new WorldLocation(ctx.loc.getWorld(), ctx.loc.getPos().method_10069(x, y, z)))).getMeta());
    }

    private static ScannerMethodContext getContext(@Nonnull IUnbakedContext<IModuleContainer> unbaked) throws LuaException {
        IContext<IModuleContainer> ctx = unbaked.bake();
        IWorldLocation location = ContextHelpers.fromContext(ctx, IWorldLocation.class, "origin");
        RangeInfo range = ContextHelpers.fromContext(ctx, RangeInfo.class, "plethora:scanner");
        return new ScannerMethodContext(ctx, location, range);
    }

    private record ScannerMethodContext(IContext<IModuleContainer> context, IWorldLocation loc, RangeInfo range) {
    }
}

