/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.util;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public final class WorldPosition {
    private final class_5321<class_1937> worldKey;
    private WeakReference<class_1937> world;
    private final class_243 pos;

    public WorldPosition(@Nonnull class_1937 world, @Nonnull class_243 pos) {
        Objects.requireNonNull(world, "world cannot be null");
        Objects.requireNonNull(pos, "pos cannot be null");
        this.worldKey = world.method_27983();
        this.world = new WeakReference<class_1937>(world);
        this.pos = pos;
    }

    private WorldPosition(class_5321<class_1937> worldKey, @Nonnull class_243 pos) {
        this.worldKey = worldKey;
        this.world = new WeakReference<Object>(null);
        this.pos = pos;
    }

    public WorldPosition(@Nonnull class_1937 world, @Nonnull class_2338 pos) {
        Objects.requireNonNull(world, "world cannot be null");
        Objects.requireNonNull(pos, "pos cannot be null");
        this.worldKey = world.method_27983();
        this.world = new WeakReference<class_1937>(world);
        this.pos = new class_243((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
    }

    public WorldPosition(@Nonnull class_1937 world, double x, double y, double z) {
        this(world, new class_243(x, y, z));
    }

    @Nullable
    public class_1937 getWorld() {
        return (class_1937)this.world.get();
    }

    @Nullable
    public class_1937 getWorld(MinecraftServer server) {
        class_1937 world = (class_1937)this.world.get();
        class_3218 worldByKey = server.method_3847(this.worldKey);
        if (world == null && worldByKey != null) {
            world = worldByKey;
            this.world = new WeakReference<class_3218>((class_3218)world);
        }
        return world;
    }

    public class_5321<class_1937> getWorldKey() {
        return this.worldKey;
    }

    @Nonnull
    public class_243 getPos() {
        return this.pos;
    }

    public class_2487 serializeNbt() {
        class_2487 tag = new class_2487();
        tag.method_10582("dim", this.worldKey.toString());
        tag.method_10549("x", this.pos.field_1352);
        tag.method_10549("y", this.pos.field_1351);
        tag.method_10549("z", this.pos.field_1350);
        return tag;
    }

    public static WorldPosition deserializeNbt(class_2487 nbt) {
        return new WorldPosition((class_5321<class_1937>)class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(nbt.method_10558("worldKey"))), new class_243(nbt.method_10574("x"), nbt.method_10574("y"), nbt.method_10574("z")));
    }
}

