/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.api.method;

import io.sc3.plethora.api.meta.TypedMeta;
import io.sc3.plethora.api.method.IContext;
import io.sc3.plethora.api.method.IPartialContext;
import io.sc3.plethora.api.method.TypedLuaObject;
import io.sc3.plethora.core.ContextFactory;
import io.sc3.plethora.core.executor.BasicExecutor;
import io.sc3.plethora.integration.DetailsMetaWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1799;

public final class ContextHelpers {
    private ContextHelpers() {
    }

    @Nonnull
    public static <T> List<TypedMeta<T, ?>> getMetaList(@Nonnull IPartialContext<?> context, @Nullable Collection<T> list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList out = new ArrayList(list.size());
        for (T element : list) {
            out.add(element == null ? null : context.makePartialChild(element).getMeta());
        }
        return out;
    }

    @Nonnull
    public static <T> List<TypedMeta<T, ?>> getMetaList(@Nonnull IPartialContext<?> context, @Nullable T[] list) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList map = new ArrayList(list.length);
        for (T element : list) {
            map.add(element == null ? null : context.makePartialChild(element).getMeta());
        }
        return map;
    }

    @Nullable
    public static TypedLuaObject<DetailsMetaWrapper<class_1799>> wrapStack(@Nonnull IPartialContext<?> context, @Nullable class_1799 object) {
        if (object == null || object.method_7960()) {
            return null;
        }
        DetailsMetaWrapper<class_1799> wrapper = DetailsMetaWrapper.stack(object.method_7972());
        return context instanceof IContext ? ((IContext)context).makeChildId(wrapper).getObject() : ContextFactory.of(wrapper).withExecutor(BasicExecutor.INSTANCE).getObject();
    }

    public static Map<Integer, TypedLuaObject<DetailsMetaWrapper<class_1799>>> getInventoryItems(@Nonnull IPartialContext<?> context, class_1263 inventory2) {
        HashMap<Integer, TypedLuaObject<DetailsMetaWrapper<class_1799>>> out = new HashMap<Integer, TypedLuaObject<DetailsMetaWrapper<class_1799>>>();
        int size = inventory2.method_5439();
        for (int i2 = 0; i2 < size; ++i2) {
            TypedLuaObject<DetailsMetaWrapper<class_1799>> item2 = ContextHelpers.wrapStack(context, inventory2.method_5438(i2));
            if (item2 == null) continue;
            out.put(i2 + 1, item2);
        }
        return out;
    }
}

