/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.modules.glasses.canvas;

import io.sc3.plethora.Plethora;
import io.sc3.plethora.gameplay.modules.glasses.objects.BaseObject;
import io.sc3.plethora.gameplay.modules.glasses.objects.ObjectGroup;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J+\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0013\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0005J\u0015\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00198\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001c\u00a8\u0006!"}, d2={"Lio/sc3/plethora/gameplay/modules/glasses/canvas/CanvasClient;", "", "", "id", "<init>", "(I)V", "Lit/unimi/dsi/fastutil/ints/IntIterator;", "children", "Lnet/minecraft/class_332;", "ctx", "Lnet/minecraft/class_4597;", "consumers", "", "drawChildren", "(Lit/unimi/dsi/fastutil/ints/IntIterator;Lnet/minecraft/class_332;Lnet/minecraft/class_4597;)V", "Lit/unimi/dsi/fastutil/ints/IntSet;", "getChildren", "(I)Lit/unimi/dsi/fastutil/ints/IntSet;", "Lio/sc3/plethora/gameplay/modules/glasses/objects/BaseObject;", "getObject", "(I)Lio/sc3/plethora/gameplay/modules/glasses/objects/BaseObject;", "remove", "obj", "updateObject", "(Lio/sc3/plethora/gameplay/modules/glasses/objects/BaseObject;)V", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lit/unimi/dsi/fastutil/ints/IntSortedSet;", "childrenOf", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "I", "getId", "()I", "objects", "Plethora-Fabric"})
public final class CanvasClient {
    private final int id;
    @NotNull
    private final Int2ObjectMap<BaseObject> objects;
    @NotNull
    private final Int2ObjectMap<IntSortedSet> childrenOf;

    public CanvasClient(int id) {
        this.id = id;
        this.objects = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        this.childrenOf = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        this.childrenOf.put(0, (Object)new IntAVLTreeSet());
        this.childrenOf.put(1, (Object)new IntAVLTreeSet());
    }

    public final int getId() {
        return this.id;
    }

    public final void updateObject(@NotNull BaseObject obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        IntSet parent = (IntSet)this.childrenOf.get(obj.getParent());
        if (parent == null) {
            Plethora.log.error("Trying to add " + obj.getId() + " to group " + obj.getParent() + " (" + obj + ")");
            return;
        }
        if (this.objects.put(obj.getId(), (Object)obj) == null) {
            parent.add(obj.getId());
            if (obj instanceof ObjectGroup) {
                this.childrenOf.put(obj.getId(), (Object)new IntAVLTreeSet());
            }
        }
    }

    public final void remove(int id) {
        block1: {
            IntSet parent;
            BaseObject obj = (BaseObject)this.objects.remove(id);
            this.childrenOf.remove(id);
            if (obj == null) break block1;
            IntSet intSet = parent = (IntSet)this.childrenOf.get(obj.getParent());
            if (intSet != null) {
                intSet.remove(id);
            }
        }
    }

    @Nullable
    public final BaseObject getObject(int id) {
        return (BaseObject)this.objects.get(id);
    }

    @Nullable
    public final IntSet getChildren(int id) {
        IntSortedSet children = (IntSortedSet)this.childrenOf.get(id);
        return children.isEmpty() ? null : (IntSet)children;
    }

    @Environment(value=EnvType.CLIENT)
    public final void drawChildren(@NotNull IntIterator children, @Nullable class_332 ctx, @Nullable class_4597 consumers) {
        Intrinsics.checkNotNullParameter((Object)children, (String)"children");
        while (children.hasNext()) {
            BaseObject obj;
            int id = children.nextInt();
            BaseObject baseObject = obj = this.getObject(id);
            if (baseObject == null) continue;
            class_332 class_3322 = ctx;
            Intrinsics.checkNotNull((Object)class_3322);
            baseObject.draw(this, class_3322, consumers);
        }
    }
}

