/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server;

import cc.reconnected.server.RccServerConfig;
import cc.reconnected.server.api.events.RccEvents;
import cc.reconnected.server.commands.home.DeleteHomeCommand;
import cc.reconnected.server.commands.home.HomeCommand;
import cc.reconnected.server.commands.home.SetHomeCommand;
import cc.reconnected.server.commands.misc.AfkCommand;
import cc.reconnected.server.commands.misc.BackCommand;
import cc.reconnected.server.commands.misc.FlyCommand;
import cc.reconnected.server.commands.misc.GodCommand;
import cc.reconnected.server.commands.misc.NearCommand;
import cc.reconnected.server.commands.misc.RccCommand;
import cc.reconnected.server.commands.misc.TimeBarCommand;
import cc.reconnected.server.commands.spawn.SetSpawnCommand;
import cc.reconnected.server.commands.spawn.SpawnCommand;
import cc.reconnected.server.commands.teleport.TeleportAcceptCommand;
import cc.reconnected.server.commands.teleport.TeleportAskCommand;
import cc.reconnected.server.commands.teleport.TeleportAskHereCommand;
import cc.reconnected.server.commands.teleport.TeleportDenyCommand;
import cc.reconnected.server.commands.tell.ReplyCommand;
import cc.reconnected.server.commands.tell.TellCommand;
import cc.reconnected.server.commands.warp.DeleteWarpCommand;
import cc.reconnected.server.commands.warp.SetWarpCommand;
import cc.reconnected.server.commands.warp.WarpCommand;
import cc.reconnected.server.core.AfkTracker;
import cc.reconnected.server.core.BackTracker;
import cc.reconnected.server.core.BossBarManager;
import cc.reconnected.server.core.HttpApiServer;
import cc.reconnected.server.core.TabList;
import cc.reconnected.server.core.TeleportTracker;
import cc.reconnected.server.data.PlayerState;
import cc.reconnected.server.data.ServerState;
import cc.reconnected.server.data.StateManager;
import cc.reconnected.server.struct.ServerPosition;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Date;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kyori.adventure.platform.fabric.FabricServerAudiences;
import net.kyori.adventure.text.Component;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RccServer
implements ModInitializer {
    public static final String MOD_ID = "rcc-server";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rcc-server");
    public static final RccServerConfig CONFIG = RccServerConfig.createAndLoad();
    public static final StateManager state = new StateManager();
    private static RccServer INSTANCE;
    private LuckPerms luckPerms;
    private volatile FabricServerAudiences adventure;

    public static RccServer getInstance() {
        return INSTANCE;
    }

    public RccServer() {
        INSTANCE = this;
    }

    public LuckPerms luckPerms() {
        return this.luckPerms;
    }

    public FabricServerAudiences adventure() {
        FabricServerAudiences ret = this.adventure;
        if (ret == null) {
            throw new IllegalStateException("Tried to access Adventure without a running server!");
        }
        return ret;
    }

    public void onInitialize() {
        LOGGER.info("Starting rcc-server");
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            state.register(server.method_27050(class_5218.field_24188).resolve("data").resolve(MOD_ID));
            this.adventure = FabricServerAudiences.of((MinecraftServer)server);
        });
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            this.adventure = null;
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            RccCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            AfkCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            TellCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            ReplyCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            TeleportAskCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            TeleportAskHereCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            TeleportAcceptCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            TeleportDenyCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            BackCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            FlyCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            GodCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            SetSpawnCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            SpawnCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            HomeCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            SetHomeCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            DeleteHomeCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            WarpCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            SetWarpCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            DeleteWarpCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            TimeBarCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
            NearCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess, environment);
        });
        AfkTracker.register();
        TeleportTracker.register();
        BackTracker.register();
        TabList.register();
        HttpApiServer.register();
        BossBarManager.register();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.luckPerms = LuckPermsProvider.get();
            ((RccEvents.Ready)RccEvents.READY.invoker()).onReady(server, this.luckPerms);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            PlayerState playerState = state.getPlayerState(player.method_5667());
            if (playerState.firstJoinedDate == null) {
                LOGGER.info("Player {} joined for the first time!", (Object)player.method_7334().getName());
                playerState.firstJoinedDate = new Date();
                ((RccEvents.Welcome)RccEvents.WELCOME.invoker()).onWelcome(player, server);
                ServerState serverState = state.getServerState();
                ServerPosition spawnPosition = serverState.spawn;
                if (spawnPosition != null) {
                    spawnPosition.teleport(player, false);
                }
            }
            if (playerState.username != null && !playerState.username.equals(player.method_7334().getName())) {
                LOGGER.info("Player {} has changed their username from {}", (Object)player.method_7334().getName(), (Object)playerState.username);
                ((RccEvents.UsernameChange)RccEvents.USERNAME_CHANGE.invoker()).onUsernameChange(player, playerState.username);
            }
            playerState.username = player.method_7334().getName();
            state.savePlayerState(player.method_5667(), playerState);
        });
    }

    public void broadcastMessage(MinecraftServer server, Component message) {
        for (class_3222 player : server.method_3760().method_14571()) {
            player.sendMessage(message);
        }
    }
}

