/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.commands.misc;

import cc.reconnected.server.api.events.BossBarEvents;
import cc.reconnected.server.core.BossBarManager;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5242;
import net.minecraft.class_7157;

public class TimeBarCommand {
    private static final ConcurrentHashMap<UUID, BarCommand> runningBars = new ConcurrentHashMap();

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralArgumentBuilder rootCommand = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"timebar").requires(Permissions.require((String)"rcc.command.timebar", (int)3))).then(class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"seconds", (ArgumentType)IntegerArgumentType.integer((int)0)).then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            List<String> colors = Arrays.stream(class_1259.class_1260.values()).map(Enum::toString).toList();
            return class_2172.method_9265(colors, (SuggestionsBuilder)builder);
        }).then(class_2170.method_9244((String)"style", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            List<String> styles = Arrays.stream(class_1259.class_1261.values()).map(Enum::toString).toList();
            return class_2172.method_9265(styles, (SuggestionsBuilder)builder);
        }).then(class_2170.method_9244((String)"countdown", (ArgumentType)BoolArgumentType.bool()).then(class_2170.method_9244((String)"label", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9244((String)"command", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> dispatcher.getRoot().listSuggestions(context, builder)).executes(TimeBarCommand::execute))))))))).then(class_2170.method_9247((String)"cancel").then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(TimeBarCommand::executeCancel)));
        dispatcher.register(rootCommand);
        BossBarEvents.END.register((timeBar, server) -> {
            if (runningBars.containsKey(timeBar.getUuid())) {
                BarCommand barCommand = runningBars.get(timeBar.getUuid());
                try {
                    dispatcher.execute(barCommand.command(), (Object)barCommand.source);
                }
                catch (CommandSyntaxException e) {
                    barCommand.source.method_9226(() -> class_2561.method_43470((String)e.toString()).method_27692(class_124.field_1061), false);
                }
                runningBars.remove(timeBar.getUuid());
            }
        });
    }

    private static int execute(CommandContext<class_2168> context) {
        int seconds = IntegerArgumentType.getInteger(context, (String)"seconds");
        String colorName = StringArgumentType.getString(context, (String)"color");
        String styleName = StringArgumentType.getString(context, (String)"style");
        boolean countdown = BoolArgumentType.getBool(context, (String)"countdown");
        String label = StringArgumentType.getString(context, (String)"label");
        String command = StringArgumentType.getString(context, (String)"command");
        class_1259.class_1260 color = class_1259.class_1260.valueOf((String)colorName);
        class_1259.class_1261 style = class_1259.class_1261.valueOf((String)styleName);
        BossBarManager.TimeBar bar = BossBarManager.getInstance().startTimeBar(label, seconds, color, style, countdown);
        runningBars.put(bar.getUuid(), new BarCommand((class_2168)context.getSource(), command));
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"New time bar created with UUID ").method_10852((class_2561)class_2561.method_43470((String)bar.getUuid().toString()).method_10862(class_2583.field_24360.method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_30163((String)"Click to copy"))).method_10958(new class_2558(class_2558.class_2559.field_21462, bar.getUuid().toString())))), true);
        return 1;
    }

    private static int executeCancel(CommandContext<class_2168> context) {
        UUID uuid = class_5242.method_27645(context, (String)"uuid");
        if (!runningBars.containsKey(uuid)) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Time bar not found!").method_27692(class_124.field_1061), false);
            return 1;
        }
        runningBars.remove(uuid);
        BossBarManager.getInstance().cancelTimeBar(uuid);
        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Time bar canceled"), true);
        return 1;
    }

    private record BarCommand(class_2168 source, String command) {
    }
}

