/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.commands.tell;

import cc.reconnected.server.RccServer;
import cc.reconnected.server.parser.MarkdownParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import eu.pb4.placeholders.api.node.TextNode;
import java.util.HashMap;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedPermissionData;
import net.luckperms.api.platform.PlayerAdapter;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_7157;

public class TellCommand {
    public static final HashMap<String, String> lastSender = new HashMap();

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        LiteralCommandNode messageNode = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"msg").requires(Permissions.require((String)"rcc.command.tell", (boolean)true))).then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            class_3324 playerManager = ((class_2168)context.getSource()).method_9211().method_3760();
            return class_2172.method_9253((String[])playerManager.method_14580(), (SuggestionsBuilder)builder);
        }).then(class_2170.method_9244((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(TellCommand::execute))));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"tell").redirect((CommandNode)messageNode));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"w").redirect((CommandNode)messageNode));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"dm").redirect((CommandNode)messageNode));
    }

    private static int execute(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        String targetName = StringArgumentType.getString(context, (String)"player");
        String message = StringArgumentType.getString(context, (String)"message");
        TellCommand.sendDirectMessage(targetName, source, message);
        return 1;
    }

    public static void sendDirectMessage(String targetName, class_2168 source, String message) {
        class_2561 targetDisplayName;
        class_3222 targetPlayer = null;
        if (targetName.equalsIgnoreCase("server")) {
            targetDisplayName = class_2561.method_30163((String)"Server");
        } else {
            targetPlayer = source.method_9211().method_3760().method_14566(targetName);
            if (targetPlayer == null) {
                source.method_9226(() -> class_2561.method_43470((String)("Player \"" + targetName + "\" not found")).method_10862(class_2583.field_24360.method_10977(class_124.field_1061)), false);
                return;
            }
            targetDisplayName = targetPlayer.method_5476();
        }
        TextNode parsedMessage = MarkdownParser.defaultParser.parseNode(message);
        TextComponent you = Component.text((String)"You", (TextColor)NamedTextColor.GRAY, (TextDecoration[])new TextDecoration[]{TextDecoration.ITALIC});
        Component sourceText = MiniMessage.miniMessage().deserialize(RccServer.CONFIG.tellMessage(), new TagResolver[]{Placeholder.component((String)"source", (ComponentLike)you), Placeholder.component((String)"target", (ComponentLike)targetDisplayName), Placeholder.component((String)"message", (ComponentLike)parsedMessage.toText())});
        Component targetText = MiniMessage.miniMessage().deserialize(RccServer.CONFIG.tellMessage(), new TagResolver[]{Placeholder.component((String)"source", (ComponentLike)source.method_9223()), Placeholder.component((String)"target", (ComponentLike)you), Placeholder.component((String)"message", (ComponentLike)parsedMessage.toText())});
        Component text = MiniMessage.miniMessage().deserialize(RccServer.CONFIG.tellMessage(), new TagResolver[]{Placeholder.component((String)"source", (ComponentLike)source.method_9223()), Placeholder.component((String)"target", (ComponentLike)targetDisplayName), Placeholder.component((String)"message", (ComponentLike)parsedMessage.toText())});
        lastSender.put(targetName, source.method_9214());
        lastSender.put(source.method_9214(), targetName);
        if (!source.method_9214().equals(targetName)) {
            source.sendMessage(sourceText);
        }
        if (targetPlayer != null) {
            targetPlayer.sendMessage(targetText);
            if (source.method_43737()) {
                source.method_9211().sendMessage(text);
            }
        } else {
            source.method_9211().sendMessage(targetText);
        }
        LuckPerms lp = RccServer.getInstance().luckPerms();
        PlayerAdapter playerAdapter = lp.getPlayerAdapter(class_3222.class);
        Component spyText = MiniMessage.miniMessage().deserialize(RccServer.CONFIG.tellMessageSpy(), new TagResolver[]{Placeholder.component((String)"source", (ComponentLike)source.method_9223()), Placeholder.component((String)"target", (ComponentLike)targetDisplayName), Placeholder.component((String)"message", (ComponentLike)parsedMessage.toText())});
        source.method_9211().method_3760().method_14571().forEach(player -> {
            String playerName = player.method_7334().getName();
            if (playerName.equals(targetName) || playerName.equals(source.method_9214())) {
                return;
            }
            CachedPermissionData playerPerms = playerAdapter.getPermissionData(player);
            if (playerPerms.checkPermission("rcc.tell.spy").asBoolean()) {
                player.sendMessage(spyText);
            }
        });
    }
}

