/*
 * Decompiled with CFR 0.152.
 */
package ct.discordbridge;

import ct.discordbridge.DiscordConfig;
import ct.discordbridge.Utils;
import ct.discordbridge.discord.Client;
import discord4j.core.spec.EmbedCreateFields;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.rest.util.AllowedMentions;
import discord4j.rest.util.Color;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bridge
implements ModInitializer {
    public static final String MOD_ID = "ct-discord";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"ct-discord");
    private static Bridge INSTANCE;
    public static final DiscordConfig CONFIG;
    private Client client;
    private static final Queue<Component> chatQueue;

    public Bridge() {
        INSTANCE = this;
    }

    public static Bridge getInstance() {
        return INSTANCE;
    }

    public Client getClient() {
        return this.client;
    }

    public void onInitialize() {
        LOGGER.info("Initializing Discord Bridge");
        try {
            this.client = new Client();
        }
        catch (Exception e) {
            LOGGER.error("Error creating Discord client", (Throwable)e);
            return;
        }
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            while (!chatQueue.isEmpty()) {
                Component message = chatQueue.poll();
                LOGGER.info(PlainTextComponentSerializer.plainText().serialize(message));
                List list = server.method_3760().method_14571();
                for (class_3222 player : list) {
                    player.sendMessage(message);
                }
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> this.client.webhook().execute().withEmbeds(new EmbedCreateSpec[]{EmbedCreateSpec.create().withDescription(":hourglass: **Server is starting...**").withColor(Color.of((int)NamedTextColor.YELLOW.value()))}).subscribe());
        ServerLifecycleEvents.SERVER_STARTED.register(server -> this.client.webhook().execute().withEmbeds(new EmbedCreateSpec[]{EmbedCreateSpec.create().withDescription(":up: **Server started!**").withColor(Color.of((int)NamedTextColor.GREEN.value()))}).subscribe());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.client.webhook().execute().withEmbeds(new EmbedCreateSpec[]{EmbedCreateSpec.create().withDescription(":electric_plug: **Server is stopping!**").withColor(Color.of((int)NamedTextColor.RED.value()))}).subscribe());
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            String playerName = handler.field_14140.method_5476().getString();
            this.client.webhook().execute().withEmbeds(new EmbedCreateSpec[]{EmbedCreateSpec.create().withAuthor(EmbedCreateFields.Author.of((String)String.format("%s joined the server", playerName), null, (String)Utils.getAvatarThumbnailUrl(handler.field_14140))).withColor(Color.of((int)NamedTextColor.GREEN.value()))}).subscribe();
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            String playerName = handler.field_14140.method_5476().getString();
            this.client.webhook().execute().withEmbeds(new EmbedCreateSpec[]{EmbedCreateSpec.create().withAuthor(EmbedCreateFields.Author.of((String)String.format("%s left the server", playerName), null, (String)Utils.getAvatarThumbnailUrl(handler.field_14140))).withColor(Color.of((int)NamedTextColor.RED.value()))}).subscribe();
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (!(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            String message = damageSource.method_5506(entity).getString();
            String avatarUrl = Utils.getAvatarThumbnailUrl(player);
            this.client.webhook().execute().withEmbeds(new EmbedCreateSpec[]{EmbedCreateSpec.create().withAuthor(EmbedCreateFields.Author.of((String)String.format("%s", message), null, (String)avatarUrl)).withColor(Color.of((int)NamedTextColor.GRAY.value()))}).subscribe();
        });
        ServerMessageEvents.CHAT_MESSAGE.register((message, sender, params) -> {
            String playerName = sender.method_5476().getString();
            String avatarUrl = Utils.getAvatarUrl(sender);
            this.client.webhook().execute().withAvatarUrl(avatarUrl).withUsername(playerName).withContent(message.method_46291().getString()).withAllowedMentions(AllowedMentions.suppressEveryone()).subscribe();
        });
    }

    public static void enqueueMessage(Component component) {
        chatQueue.offer(component);
    }

    static {
        CONFIG = DiscordConfig.createAndLoad();
        chatQueue = new ConcurrentLinkedQueue<Component>();
    }
}

