/*
 * Decompiled with CFR 0.152.
 */
package ct.discordbridge.discord;

import ct.discordbridge.Bridge;
import ct.discordbridge.discord.Events;
import discord4j.common.util.Snowflake;
import discord4j.core.DiscordClient;
import discord4j.core.DiscordClientBuilder;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.lifecycle.ReadyEvent;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.Webhook;
import discord4j.core.object.entity.channel.TextChannel;
import discord4j.gateway.intent.Intent;
import discord4j.gateway.intent.IntentSet;
import reactor.core.publisher.Mono;

public class Client {
    private TextChannel chatChannel;
    private Webhook webhook;
    private GatewayDiscordClient client;
    private Events events;

    public Client() throws Exception {
        this.initialize();
    }

    public TextChannel chatChannel() {
        return this.chatChannel;
    }

    public Webhook webhook() {
        return this.webhook;
    }

    public GatewayDiscordClient client() {
        return this.client;
    }

    public Events events() {
        return this.events;
    }

    private void initialize() {
        Mono clientMono = ((DiscordClient)DiscordClientBuilder.create((String)Bridge.CONFIG.token()).build()).gateway().setEnabledIntents(IntentSet.of((Intent[])new Intent[]{Intent.MESSAGE_CONTENT, Intent.GUILD_MESSAGES, Intent.GUILD_MEMBERS})).login();
        clientMono.flatMap(client -> {
            client.on(ReadyEvent.class).subscribe(event -> {
                this.client = client;
                User self = event.getSelf();
                Bridge.LOGGER.info("Logged in as {}", (Object)self.getTag());
                this.chatChannel = (TextChannel)client.getChannelById(Snowflake.of((String)Bridge.CONFIG.channelId())).block();
                if (this.chatChannel == null) {
                    Bridge.LOGGER.error("Channel not found! Set an existing channel ID that I can see!");
                    return;
                }
                String webhookName = Bridge.CONFIG.name();
                this.webhook = (Webhook)this.chatChannel.getWebhooks().filter(wh -> ((String)wh.getName().get()).equals(webhookName)).singleOrEmpty().block();
                if (this.webhook == null) {
                    this.webhook = (Webhook)this.chatChannel.createWebhook(webhookName).block();
                }
                this.events = new Events(this);
            });
            return Mono.empty();
        }).block();
        clientMono.subscribe();
    }
}

