/*
 * Decompiled with CFR 0.152.
 */
package ct.discordbridge.discord;

import ct.discordbridge.Bridge;
import ct.discordbridge.ChatComponents;
import ct.discordbridge.Colors;
import ct.discordbridge.discord.Client;
import ct.discordbridge.events.DiscordMessage;
import discord4j.common.util.Snowflake;
import discord4j.core.event.domain.message.MessageCreateEvent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.PartialMember;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.UserData;
import discord4j.rest.util.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import reactor.core.publisher.Flux;

public class Events {
    private static final Pattern mentionPattern = Pattern.compile("(<@[!&]?\\d+>|<#\\d+>)");
    private static final Pattern integerPattern = Pattern.compile("\\d+");

    public Events(Client client) {
        client.client().on(MessageCreateEvent.class).subscribe(this::onMessageCreate);
    }

    public static List<String> splitMessage(String message) {
        ArrayList<String> parts = new ArrayList<String>();
        Matcher matcher = mentionPattern.matcher(message);
        int lastEnd = 0;
        while (matcher.find()) {
            if (matcher.start() > lastEnd) {
                parts.add(message.substring(lastEnd, matcher.start()));
            }
            parts.add(matcher.group(1));
            lastEnd = matcher.end();
        }
        if (lastEnd < message.length()) {
            parts.add(message.substring(lastEnd));
        }
        return parts;
    }

    public void onMessageCreate(MessageCreateEvent event) {
        Message message = event.getMessage();
        MessageChannel channel = (MessageChannel)message.getChannel().block();
        if (channel == null) {
            return;
        }
        if (!channel.getId().equals((Object)Snowflake.of((String)Bridge.CONFIG.channelId()))) {
            return;
        }
        if (event.getMember().isEmpty()) {
            return;
        }
        Member member = (Member)event.getMember().get();
        if (member.isBot()) {
            return;
        }
        ((DiscordMessage)DiscordMessage.MESSAGE_CREATE.invoker()).messageCreate(event);
        int memberColor = NamedTextColor.WHITE.value();
        Color nullableMemberColor = (Color)member.getColor().block();
        if (nullableMemberColor != null) {
            memberColor = nullableMemberColor.getRGB();
        }
        Component memberComponent = ChatComponents.makeUser(member.getDisplayName(), member.getMention() + ": ", memberColor, (Component)Component.empty());
        Component replyComponent = null;
        if (message.getType() == Message.Type.REPLY && message.getReferencedMessage().isPresent()) {
            Component referenceMemberComponent;
            Message referencedMessage = (Message)message.getReferencedMessage().get();
            Member referenceMember = (Member)referencedMessage.getAuthorAsMember().block();
            if (referenceMember != null) {
                int referenceMemberColor = NamedTextColor.WHITE.value();
                Color nullableReferenceMemberColor = (Color)member.getColor().block();
                if (nullableReferenceMemberColor != null) {
                    referenceMemberColor = nullableReferenceMemberColor.getRGB();
                }
                referenceMemberComponent = ChatComponents.makeUser(referenceMember.getDisplayName(), referenceMember.getMention() + ": ", referenceMemberColor, (Component)Component.empty());
            } else if (referencedMessage.getAuthor().isPresent()) {
                User referenceAuthor = (User)referencedMessage.getAuthor().get();
                referenceMemberComponent = ChatComponents.makeUser(referenceAuthor.getUsername(), referenceAuthor.getMention() + ": ", NamedTextColor.WHITE.value(), (Component)Component.empty());
            } else {
                MessageData referenceData = referencedMessage.getData();
                UserData referenceAuthor = referenceData.author();
                referenceMemberComponent = ChatComponents.makeUser(referenceAuthor.username(), referenceAuthor.username() + ": ", NamedTextColor.WHITE.value(), (Component)Component.empty());
            }
            replyComponent = ChatComponents.makeReplyHeader(referenceMemberComponent, (Component)Component.text((String)referencedMessage.getContent()));
        }
        String messageContent = message.getContent();
        TextComponent messageComponent = Component.empty();
        List<String> splitContent = Events.splitMessage(messageContent);
        List memberMentions = message.getMemberMentions();
        Flux roleMentions = message.getRoleMentions();
        for (String string : splitContent) {
            if (string.matches(mentionPattern.pattern())) {
                Matcher matcher = integerPattern.matcher(string);
                if (matcher.find()) {
                    Snowflake snowflakeId = Snowflake.of((String)matcher.group());
                    if (string.startsWith("<@&")) {
                        Role mentionedRole = (Role)roleMentions.filter(p -> p.getId().equals((Object)snowflakeId)).blockFirst();
                        if (mentionedRole != null) {
                            int color = mentionedRole.getColor().getRGB();
                            if (color == 0) {
                                color = 10070709;
                            }
                            messageComponent = messageComponent.append(ChatComponents.makeUser(mentionedRole.getName(), mentionedRole.getMention() + ": ", color, ChatComponents.mentionIcon));
                            continue;
                        }
                        messageComponent = messageComponent.append(ChatComponents.makeUser("unknown-role", String.format("<@&%s>: ", snowflakeId.asString()), NamedTextColor.WHITE.value(), ChatComponents.mentionIcon));
                        continue;
                    }
                    if (string.startsWith("<@") || string.startsWith("<@!")) {
                        Optional<PartialMember> mentionedOpt = memberMentions.stream().filter(p -> p.getId().equals((Object)snowflakeId)).findFirst();
                        if (mentionedOpt.isPresent()) {
                            PartialMember mentioned = mentionedOpt.get();
                            messageComponent = messageComponent.append(ChatComponents.makeUser(mentioned.getDisplayName(), mentioned.getMention() + ": ", Colors.MENTION.value(), ChatComponents.mentionIcon));
                            continue;
                        }
                        messageComponent = messageComponent.append(ChatComponents.makeUser("unknown-user", String.format("<@%s>: ", snowflakeId.asString()), Colors.MENTION.value(), ChatComponents.mentionIcon));
                        continue;
                    }
                    if (!string.startsWith("<#")) continue;
                    Channel mentionedChannel = (Channel)message.getClient().getChannelById(snowflakeId).block();
                    if (mentionedChannel != null && (mentionedChannel.getType() == Channel.Type.GUILD_TEXT || mentionedChannel.getType() == Channel.Type.GUILD_VOICE || mentionedChannel.getType() == Channel.Type.GUILD_NEWS)) {
                        GuildChannel guildChannel = (GuildChannel)mentionedChannel;
                        messageComponent = messageComponent.append(ChatComponents.makeUser(guildChannel.getName(), guildChannel.getMention() + ": ", Colors.MENTION.value(), ChatComponents.channelIcon));
                        continue;
                    }
                    messageComponent = messageComponent.append(ChatComponents.makeUser("unknown", String.format("<#%s>: ", snowflakeId.asString()), Colors.MENTION.value(), ChatComponents.channelIcon));
                    continue;
                }
                messageComponent = messageComponent.append((Component)Component.text((String)string));
                continue;
            }
            messageComponent = messageComponent.append((Component)Component.text((String)string));
        }
        List attachments = message.getAttachments();
        if (!messageContent.isEmpty()) {
            messageComponent = messageComponent.appendSpace();
        }
        for (Attachment attachment : attachments) {
            messageComponent = messageComponent.append(ChatComponents.makeAttachment(attachment.getFilename(), attachment.getUrl()));
        }
        Component component = ChatComponents.makeMessage(memberComponent, replyComponent, (Component)messageComponent);
        Bridge.enqueueMessage(component);
    }
}

