/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.api.reference;

import com.google.common.base.Objects;
import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.api.IWorldLocation;
import io.sc3.plethora.api.reference.ConstantReference;
import java.lang.ref.WeakReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class BlockReference
implements ConstantReference<BlockReference> {
    private final IWorldLocation location;
    private final WeakReference<class_2586> blockEntity;
    private final int beHash;
    private final class_2350 side;
    private class_2680 state;
    private boolean valid = true;

    public BlockReference(@Nonnull IWorldLocation location, @Nonnull class_2680 state, @Nullable class_2586 blockEntity, @Nullable class_2350 side) {
        this.location = location;
        this.blockEntity = blockEntity == null ? null : new WeakReference<class_2586>(blockEntity);
        this.beHash = blockEntity == null ? 0 : blockEntity.hashCode();
        this.side = side;
        this.state = state;
    }

    public BlockReference(@Nonnull IWorldLocation location, @Nonnull class_2680 state, @Nullable class_2586 blockEntity) {
        this(location, state, blockEntity, null);
    }

    public BlockReference(@Nonnull IWorldLocation location, @Nullable class_2350 side) {
        this(location, location.getWorld().method_8320(location.getPos()), location.getWorld().method_8321(location.getPos()), side);
    }

    public BlockReference(@Nonnull IWorldLocation location) {
        this(location, null);
    }

    @Override
    @Nonnull
    public BlockReference get() throws LuaException {
        class_1937 world = this.location.getWorld();
        class_2338 pos = this.location.getPos();
        class_2680 newState = world.method_8320(pos);
        class_2586 newBe = world.method_8321(pos);
        if (this.blockEntity == null) {
            if (this.state.method_26204() != newState.method_26204()) {
                this.valid = false;
                throw new LuaException("The block is no longer there");
            }
            if (newBe != null) {
                this.valid = false;
                throw new LuaException("The block has changed");
            }
        } else {
            class_2586 oldBe = (class_2586)this.blockEntity.get();
            if (oldBe == null) {
                this.valid = false;
                throw new LuaException("The block is no longer there");
            }
            if (!oldBe.equals(newBe)) {
                this.valid = false;
                throw new LuaException("The block has changed");
            }
        }
        this.state = world.method_8320(pos);
        this.valid = true;
        return this;
    }

    @Override
    @Nonnull
    public BlockReference safeGet() throws LuaException {
        class_2586 oldBe;
        if (!this.valid) {
            throw new LuaException("The block has changed");
        }
        if (this.blockEntity != null && ((oldBe = (class_2586)this.blockEntity.get()) == null || oldBe.method_11015())) {
            throw new LuaException("The block has changed");
        }
        return this;
    }

    @Nonnull
    public IWorldLocation getLocation() {
        return this.location;
    }

    @Nonnull
    public class_2680 getState() {
        return this.state;
    }

    @Nullable
    public class_2586 getBlockEntity() {
        return this.blockEntity == null ? null : (class_2586)this.blockEntity.get();
    }

    @Nullable
    public class_2350 getSide() {
        return this.side;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockReference that = (BlockReference)o;
        if (!this.location.equals(that.location) || this.beHash != that.beHash) {
            return false;
        }
        if (this.blockEntity != that.blockEntity) {
            class_2586 thatBe;
            if (this.blockEntity == null) {
                return false;
            }
            class_2586 thisBe = (class_2586)this.blockEntity.get();
            class_2586 class_25862 = thatBe = that.blockEntity == null ? null : (class_2586)that.blockEntity.get();
            if (!Objects.equal((Object)thisBe, (Object)thatBe)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return this.location.hashCode() + 31 * this.beHash;
    }
}

