/*
 * Decompiled with CFR 0.152.
 */
package ct.server.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import ct.server.CtServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;

public class ServiceServer {
    private final HttpServer server = HttpServer.create(new InetSocketAddress(CtServer.CONFIG.httpPort()), 0);

    public HttpServer httpServer() {
        return this.server;
    }

    public ServiceServer() throws IOException {
        this.server.createContext("/tps", new TPSHandler());
        this.server.createContext("/mspt", new MSPTHandler());
        this.server.createContext("/player", new PlayerCountHandler());
        this.server.setExecutor(null);
        Thread httpThread = new Thread(this.server::start);
        httpThread.start();
    }

    static class TPSHandler
    implements HttpHandler {
        TPSHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String tps = String.valueOf(CtServer.getTPS());
            t.sendResponseHeaders(200, tps.length());
            OutputStream body = t.getResponseBody();
            body.write(tps.getBytes());
            body.close();
        }
    }

    static class MSPTHandler
    implements HttpHandler {
        MSPTHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String tps = String.valueOf(CtServer.getMSPT());
            t.sendResponseHeaders(200, tps.length());
            OutputStream body = t.getResponseBody();
            body.write(tps.getBytes());
            body.close();
        }
    }

    static class PlayerCountHandler
    implements HttpHandler {
        PlayerCountHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String tps = String.valueOf(CtServer.getPlayerCount());
            t.sendResponseHeaders(200, tps.length());
            OutputStream body = t.getResponseBody();
            body.write(tps.getBytes());
            body.close();
        }
    }
}

