/*
 * Decompiled with CFR 0.152.
 */
package me.cortex.nvidium.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import me.cortex.nvidium.gl.RenderDevice;
import me.cortex.nvidium.gl.buffers.Buffer;
import me.cortex.nvidium.gl.buffers.PersistentClientMappedBuffer;
import me.cortex.nvidium.util.SegmentedManager;
import me.cortex.nvidium.util.TickableManager;

public class DownloadTaskStream {
    private final SegmentedManager allocator = new SegmentedManager();
    private final RenderDevice device;
    private PersistentClientMappedBuffer buffer;
    private int cidx;
    private final ObjectList<Download>[] allocations;

    public DownloadTaskStream(RenderDevice device, int frames, long size) {
        this.device = device;
        this.allocator.setLimit(size);
        this.buffer = device.createClientMappedBuffer(size);
        TickableManager.register(this);
        this.allocations = new ObjectList[frames];
        for (int i = 0; i < frames; ++i) {
            this.allocations[i] = new ObjectArrayList();
        }
    }

    public void download(Buffer source, long offset, int size, IDownloadFinishedCallback callback) {
        long addr = this.allocator.alloc(size);
        this.device.copyBuffer(source, this.buffer, offset, addr, size);
        this.allocations[this.cidx].add((Object)new Download(addr, callback));
    }

    void tick() {
        this.cidx = (this.cidx + 1) % this.allocations.length;
        for (Download download : this.allocations[this.cidx]) {
            download.callback.accept(download.addr + this.buffer.clientAddress());
            this.allocator.free(download.addr);
        }
        this.allocations[this.cidx].clear();
    }

    public void delete() {
        TickableManager.remove(this);
        this.buffer.delete();
    }

    private record Download(long addr, IDownloadFinishedCallback callback) {
    }

    public static interface IDownloadFinishedCallback {
        public void accept(long var1);
    }
}

