/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.discordbridge;

import cc.reconnected.discordbridge.BridgeEvents;
import cc.reconnected.discordbridge.RccDiscordConfig;
import cc.reconnected.discordbridge.commands.DiscordCommand;
import cc.reconnected.discordbridge.discord.Client;
import cc.reconnected.library.config.ConfigManager;
import club.minnced.discord.webhook.send.AllowedMentions;
import club.minnced.discord.webhook.send.WebhookEmbed;
import club.minnced.discord.webhook.send.WebhookEmbedBuilder;
import club.minnced.discord.webhook.send.WebhookMessage;
import club.minnced.discord.webhook.send.WebhookMessageBuilder;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RccDiscord
implements ModInitializer {
    public static final String MOD_ID = "rcc-discord";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rcc-discord");
    private static RccDiscord INSTANCE;
    public static RccDiscordConfig CONFIG;
    private Client client;
    private MinecraftServer mcServer;
    private static final Queue<Component> chatQueue;
    public static final HashMap<String, class_3222> linkCodes;
    public static ConcurrentHashMap<String, UUID> discordLinks;
    private static Path dataDirectory;

    public RccDiscord() {
        INSTANCE = this;
    }

    public static RccDiscord getInstance() {
        return INSTANCE;
    }

    public Client getClient() {
        return this.client;
    }

    public void onInitialize() {
        LOGGER.info("Initializing Discord Bridge");
        try {
            CONFIG = (RccDiscordConfig)ConfigManager.load(RccDiscordConfig.class);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config. Refusing to continue.", (Throwable)e);
            return;
        }
        try {
            this.client = new Client();
        }
        catch (Exception e) {
            LOGGER.error("Error creating Discord client", (Throwable)e);
            return;
        }
        CommandRegistrationCallback.EVENT.register(DiscordCommand::register);
        BridgeEvents.register(this);
        ServerTickEvents.START_SERVER_TICK.register(server -> {
            while (!chatQueue.isEmpty()) {
                Component message = chatQueue.poll();
                LOGGER.info(PlainTextComponentSerializer.plainText().serialize(message));
                List list = server.method_3760().method_14571();
                for (class_3222 player : list) {
                    player.sendMessage(message);
                }
            }
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            dataDirectory = server.method_27050(class_5218.field_24188).resolve("data").resolve(MOD_ID);
            this.mcServer = server;
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Path mapPath;
            if (!dataDirectory.toFile().isDirectory() && !dataDirectory.toFile().mkdir()) {
                LOGGER.error("Failed to create rcc-discord data directory");
            }
            if ((mapPath = dataDirectory.resolve("links.json")).toFile().exists()) {
                try (BufferedReader stream = new BufferedReader(new FileReader(mapPath.toFile(), StandardCharsets.UTF_8));){
                    Type type = new TypeToken<ConcurrentHashMap<String, UUID>>(){}.getType();
                    discordLinks = (ConcurrentHashMap)new Gson().fromJson((Reader)stream, type);
                }
                catch (IOException e) {
                    LOGGER.error("Exception reading licenses data", (Throwable)e);
                }
            } else {
                discordLinks = new ConcurrentHashMap();
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.client.client().shutdown());
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> this.client.client().shutdownNow());
    }

    public static void enqueueMessage(Component component) {
        chatQueue.offer(component);
    }

    public void sendServerStatus(String message, int color) {
        if (!this.client.isReady()) {
            return;
        }
        WebhookEmbed embed = new WebhookEmbedBuilder().setDescription(message).setColor(Integer.valueOf(color)).build();
        this.client.webhookClient().send(embed, new WebhookEmbed[0]);
    }

    public void sendPlayerStatus(String message, int color, String avatarUrl) {
        if (!this.client.isReady()) {
            return;
        }
        WebhookEmbed embed = new WebhookEmbedBuilder().setAuthor(new WebhookEmbed.EmbedAuthor(message, avatarUrl, null)).setColor(Integer.valueOf(color)).build();
        this.client.webhookClient().send(embed, new WebhookEmbed[0]);
    }

    public void sendPlayerMessage(String message, String name, String avatarUrl) {
        if (!this.client.isReady()) {
            return;
        }
        WebhookMessage webhookMessage = new WebhookMessageBuilder().setAvatarUrl(avatarUrl).setUsername(name).setContent(message).setAllowedMentions(new AllowedMentions().withParseUsers(true).withParseRoles(true).withParseEveryone(false)).build();
        this.client.webhookClient().send(webhookMessage);
    }

    public void setStatus(String string) {
        this.setStatus(OnlineStatus.ONLINE, Activity.playing((String)string));
    }

    public void setStatus(OnlineStatus status, Activity activity) {
        this.client.client().getPresence().setPresence(status, activity);
    }

    public void saveData() {
        String output = new Gson().toJson(discordLinks);
        try (FileWriter stream = new FileWriter(dataDirectory.resolve("links.json").toFile(), StandardCharsets.UTF_8);){
            stream.write(output);
        }
        catch (IOException e) {
            LOGGER.error("Exception Discord links map data", (Throwable)e);
        }
    }

    public String[] getPlayerNames() {
        return this.mcServer.method_3760().method_14580();
    }

    static {
        chatQueue = new ConcurrentLinkedQueue<Component>();
        linkCodes = new HashMap();
        discordLinks = new ConcurrentHashMap();
    }
}

