/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.core;

import cc.reconnected.server.RccServer;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;

public class HttpApiServer {
    private static HttpApiServer instance;
    private static float currentTps;
    private static float currentMspt;
    private static int currentPlayerCount;
    private final HttpServer server = HttpServer.create(new InetSocketAddress(RccServer.CONFIG.httpPort()), 0);

    public static HttpApiServer getInstance() {
        return instance;
    }

    public static void register() {
        if (!RccServer.CONFIG.enableHttpApi()) {
            return;
        }
        try {
            instance = new HttpApiServer();
        }
        catch (IOException e) {
            RccServer.LOGGER.error("Could not start HTTP API server", (Throwable)e);
            return;
        }
        new Thread(() -> instance.httpServer().start());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            RccServer.LOGGER.info("Stopping HTTP services");
            instance.httpServer().stop(0);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            currentMspt = server.method_3830();
            if (currentMspt != 0.0f) {
                currentTps = Math.min(20.0f, 1000.0f / currentMspt);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            currentPlayerCount = server.method_3788() + 1;
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            currentPlayerCount = server.method_3788() - 1;
        });
    }

    public HttpServer httpServer() {
        return this.server;
    }

    private HttpApiServer() throws IOException {
        this.server.createContext("/tps", new TPSHandler());
        this.server.createContext("/mspt", new MSPTHandler());
        this.server.createContext("/player", new PlayerCountHandler());
        this.server.setExecutor(null);
    }

    static {
        currentTps = 0.0f;
        currentMspt = 0.0f;
        currentPlayerCount = 0;
    }

    static class TPSHandler
    implements HttpHandler {
        TPSHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String tps = String.valueOf(currentTps);
            t.sendResponseHeaders(200, tps.length());
            OutputStream body = t.getResponseBody();
            body.write(tps.getBytes());
            body.close();
        }
    }

    static class MSPTHandler
    implements HttpHandler {
        MSPTHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String tps = String.valueOf(currentTps);
            t.sendResponseHeaders(200, tps.length());
            OutputStream body = t.getResponseBody();
            body.write(tps.getBytes());
            body.close();
        }
    }

    static class PlayerCountHandler
    implements HttpHandler {
        PlayerCountHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            String tps = String.valueOf(currentPlayerCount);
            t.sendResponseHeaders(200, tps.length());
            OutputStream body = t.getResponseBody();
            body.write(tps.getBytes());
            body.close();
        }
    }
}

