/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.server.data;

import cc.reconnected.server.RccServer;
import cc.reconnected.server.data.PlayerState;
import cc.reconnected.server.data.ServerState;
import cc.reconnected.server.struct.ServerPosition;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;

public class StateManager {
    private static final Charset charset = StandardCharsets.UTF_8;
    private ServerState serverState;
    private final ConcurrentHashMap<UUID, PlayerState> playerStates = new ConcurrentHashMap();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().setDateFormat("yyyy-MM-dd'T'HH:mm:ssXXX").create();
    private Path basePath;
    private Path playersPath;
    private Path serverDataPath;

    public void register(Path path) {
        block10: {
            this.basePath = path;
            this.playersPath = this.basePath.resolve("players");
            this.serverDataPath = this.basePath.resolve("data.json");
            if (!this.basePath.toFile().exists() && !this.basePath.toFile().mkdirs()) {
                RccServer.LOGGER.error("Could not create directory: {}", (Object)this.basePath.toAbsolutePath());
            }
            if (!this.playersPath.toFile().exists() && !this.playersPath.toFile().mkdirs()) {
                RccServer.LOGGER.error("Could not create directory: {}", (Object)this.playersPath.toAbsolutePath());
            }
            if (this.serverDataPath.toFile().exists()) {
                try (BufferedReader br = new BufferedReader(new FileReader(this.serverDataPath.toFile(), charset));){
                    this.serverState = (ServerState)this.gson.fromJson((Reader)br, ServerState.class);
                    break block10;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.serverState = new ServerState();
            this.serverState.dirty = true;
        }
        ServerLifecycleEvents.SERVER_STOPPING.register(serverState -> this.save());
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> this.loadPlayerState(handler.field_14140.method_5667()));
        ServerPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            PlayerState playerState = this.getPlayerState(handler.method_32311().method_5667());
            playerState.logoffPosition = new ServerPosition(handler.method_32311());
            this.savePlayerState(handler.method_32311().method_5667(), playerState);
            this.playerStates.remove(handler.field_14140.method_5667());
        });
    }

    public void saveServerState() {
        if (!this.serverState.dirty) {
            return;
        }
        if (this.serverState.saving) {
            return;
        }
        this.serverState.saving = true;
        String json = this.gson.toJson((Object)this.serverState, ServerState.class);
        try (FileWriter fw = new FileWriter(this.serverDataPath.toFile(), charset);){
            fw.write(json);
            this.serverState.dirty = false;
        }
        catch (IOException e) {
            RccServer.LOGGER.error("Could not save server state", (Throwable)e);
        }
        this.serverState.saving = false;
    }

    public void savePlayerState(UUID uuid, PlayerState playerState) {
        if (!playerState.dirty) {
            return;
        }
        if (playerState.saving) {
            return;
        }
        playerState.saving = true;
        Path path = this.playersPath.resolve(uuid.toString() + ".json");
        String json = this.gson.toJson((Object)playerState, PlayerState.class);
        try (FileWriter fw = new FileWriter(path.toFile(), charset);){
            fw.write(json);
            playerState.dirty = false;
        }
        catch (IOException e) {
            RccServer.LOGGER.error("Could not save player state", (Throwable)e);
        }
        playerState.saving = false;
    }

    public void save() {
        this.saveServerState();
        this.playerStates.forEach(this::savePlayerState);
    }

    private PlayerState loadPlayerState(UUID uuid) {
        PlayerState playerState;
        block8: {
            Path path = this.playersPath.resolve(uuid.toString() + ".json");
            if (path.toFile().exists()) {
                try (BufferedReader br = new BufferedReader(new FileReader(path.toFile(), charset));){
                    playerState = (PlayerState)this.gson.fromJson((Reader)br, PlayerState.class);
                    break block8;
                }
                catch (Exception e) {
                    RccServer.LOGGER.error("Could not load player state: " + String.valueOf(path.toAbsolutePath()), (Throwable)e);
                    return null;
                }
            }
            playerState = new PlayerState();
            playerState.dirty = true;
        }
        this.playerStates.put(uuid, playerState);
        playerState.uuid = uuid;
        return playerState;
    }

    public PlayerState getPlayerState(UUID uuid) {
        PlayerState playerState = this.playerStates.containsKey(uuid) ? this.playerStates.get(uuid) : this.loadPlayerState(uuid);
        if (playerState == null) {
            return null;
        }
        playerState.dirty = true;
        return playerState;
    }

    public ServerState getServerState() {
        this.serverState.dirty = true;
        return this.serverState;
    }
}

