/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.pronouns;

import cc.reconnected.server.database.PlayerData;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import me.neznamy.tab.api.TabAPI;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pronouns {
    static MinecraftServer server;
    static Logger LOGGER;

    public static void onServerStart(MinecraftServer server) {
        Pronouns.server = server;
        TabAPI.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%pronoun1%", 500, player -> {
            String pronouns = Pronouns.getPronouns(player.getUniqueId());
            if (pronouns.isBlank()) {
                return "";
            }
            return pronouns.split("(\\s|,|/)", 2)[0];
        });
        TabAPI.getInstance().getPlaceholderManager().registerPlayerPlaceholder("%pronoun2%", 500, player -> {
            if (player == null) {
                return "";
            }
            String pronouns = Pronouns.getPronouns(player.getUniqueId());
            if (pronouns.isBlank()) {
                return "";
            }
            return pronouns.split("(\\s|,|/)", 2)[1];
        });
    }

    public static Boolean validatePronoun(String pronoun) {
        return Pattern.matches("^(he|him|she|her|it|its|they|them|any|ask|avoid|other)$", pronoun.toLowerCase());
    }

    public static String setPronouns(class_2168 player, String pronoun) {
        if (!player.method_43737()) {
            return "This command can only be run by a player.";
        }
        if (Objects.equals(pronoun.toLowerCase(), "clear")) {
            PlayerData pData = PlayerData.getPlayer((UUID)Objects.requireNonNull(player.method_44023()).method_5667());
            pData.set("pronouns", "").join();
            return "Cleared Pronouns.";
        }
        if (!Pronouns.validatePronoun(pronoun).booleanValue()) {
            return "Invalid pronouns.";
        }
        PlayerData pData = PlayerData.getPlayer((UUID)Objects.requireNonNull(player.method_44023()).method_5667());
        pData.delete("pronouns").join();
        pData.set("pronouns", pronoun.toLowerCase() + ",").join();
        return "Changed Pronouns";
    }

    public static String setPronouns(class_2168 player, String pronoun1, String pronoun2) {
        if (!player.method_43737()) {
            return "This command can only be run by a player.";
        }
        if (!Pronouns.validatePronoun(pronoun1).booleanValue() || !Pronouns.validatePronoun(pronoun2).booleanValue()) {
            return "Invalid pronouns.";
        }
        PlayerData pData = PlayerData.getPlayer((UUID)Objects.requireNonNull(player.method_44023()).method_5667());
        try {
            pData.delete("pronouns").join();
            pData.set("pronouns", pronoun1.toLowerCase() + "/" + pronoun2.toLowerCase()).join();
        }
        catch (Exception e) {
            LOGGER.error("Error setting pronouns", (Throwable)e);
            return "Error setting pronouns";
        }
        return "Changed Pronouns";
    }

    public static String getPronouns(UUID player) {
        PlayerData pData = PlayerData.getPlayer((UUID)player);
        String pronouns = pData.get("pronouns");
        if (pronouns == null || pronouns.isBlank()) {
            return ",";
        }
        return pronouns.toLowerCase();
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"rcc-pronouns");
    }
}

