/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.core;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.IMethod;
import io.sc3.plethora.api.method.IUnbakedContext;
import io.sc3.plethora.core.RegisteredMethod;
import io.sc3.plethora.core.RegisteredValue;
import io.sc3.plethora.util.config.PlethoraConfig;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\"B%\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ#\u0010\u0012\u001a\u00020\u00112\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0019\u001a\u00020\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u001b8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001f\u001a\u0004\b \u0010!\u00a8\u0006#"}, d2={"Lio/sc3/plethora/core/RegisteredMethod;", "T", "Lio/sc3/plethora/core/RegisteredValue;", "", "regName", "mod", "Ljava/lang/Class;", "target", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;)V", "", "build", "()V", "Lio/sc3/plethora/api/method/IUnbakedContext;", "context", "Ldan200/computercraft/api/lua/IArguments;", "args", "Lio/sc3/plethora/api/method/FutureMethodResult;", "call", "(Lio/sc3/plethora/api/method/IUnbakedContext;Ldan200/computercraft/api/lua/IArguments;)Lio/sc3/plethora/api/method/FutureMethodResult;", "Lio/sc3/plethora/util/config/PlethoraConfig$CostSystem;", "getCfg", "()Lio/sc3/plethora/util/config/PlethoraConfig$CostSystem;", "cfg", "", "cost", "I", "Lio/sc3/plethora/api/method/IMethod;", "getMethod", "()Lio/sc3/plethora/api/method/IMethod;", "method", "Ljava/lang/Class;", "getTarget", "()Ljava/lang/Class;", "Impl", "Plethora-Fabric"})
public abstract class RegisteredMethod<T>
extends RegisteredValue {
    @NotNull
    private final Class<T> target;
    private int cost;

    public RegisteredMethod(@NotNull String regName, @NotNull String mod, @NotNull Class<T> target) {
        Intrinsics.checkNotNullParameter((Object)regName, (String)"regName");
        Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        super(regName, mod);
        this.target = target;
    }

    @NotNull
    public final Class<T> getTarget() {
        return this.target;
    }

    private final PlethoraConfig.CostSystem getCfg() {
        return Plethora.config.costSystem;
    }

    @NotNull
    public abstract IMethod<T> getMethod();

    public final void build() {
        String name = this.getMod() + ":" + this.getRegName();
        Integer n = this.getCfg().getBaseCosts().computeIfAbsent(name, arg_0 -> RegisteredMethod.build$lambda$0(build.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"computeIfAbsent(...)");
        this.cost = ((Number)n).intValue();
        if (this.cost < 0) {
            Plethora.log.warn("Cost for method " + name + " is negative! Setting to 0.");
            this.cost = 0;
        }
    }

    @NotNull
    public final FutureMethodResult call(@NotNull IUnbakedContext<T> context, @NotNull IArguments args) throws LuaException {
        FutureMethodResult futureMethodResult;
        Intrinsics.checkNotNullParameter(context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            futureMethodResult = this.cost <= 0 ? this.getMethod().apply(context, args) : context.getCostHandler().await((double)this.cost, () -> RegisteredMethod.call$lambda$1(this, context, args));
            Intrinsics.checkNotNull((Object)futureMethodResult);
        }
        catch (Exception e) {
            if (e instanceof LuaException) {
                throw e;
            }
            Plethora.log.error("Unexpected error calling " + this.getRegName(), (Throwable)e);
            throw new LuaException("Java Exception Thrown: " + e);
        }
        return futureMethodResult;
    }

    private static final Integer build$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final FutureMethodResult call$lambda$1(RegisteredMethod this$0, IUnbakedContext $context, IArguments $args) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$args, (String)"$args");
        return this$0.getMethod().apply($context, $args);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u00028\u00010\u0002B3\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bR \u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\b8\u0016X\u0096\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/sc3/plethora/core/RegisteredMethod$Impl;", "T", "Lio/sc3/plethora/core/RegisteredMethod;", "", "name", "mod", "Ljava/lang/Class;", "target", "Lio/sc3/plethora/api/method/IMethod;", "method", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Class;Lio/sc3/plethora/api/method/IMethod;)V", "Lio/sc3/plethora/api/method/IMethod;", "getMethod", "()Lio/sc3/plethora/api/method/IMethod;", "Plethora-Fabric"})
    public static final class Impl<T>
    extends RegisteredMethod<T> {
        @NotNull
        private final IMethod<T> method;

        public Impl(@NotNull String name, @NotNull String mod, @NotNull Class<T> target, @NotNull IMethod<T> method) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)mod, (String)"mod");
            Intrinsics.checkNotNullParameter(target, (String)"target");
            Intrinsics.checkNotNullParameter(method, (String)"method");
            super(name, mod, target);
            this.method = method;
        }

        @Override
        @NotNull
        public IMethod<T> getMethod() {
            return this.method;
        }
    }
}

