/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox;

import cc.reconnected.chatbox.RccChatboxConfig;
import cc.reconnected.chatbox.command.ChatboxCommand;
import cc.reconnected.chatbox.license.LicenseManager;
import cc.reconnected.chatbox.listeners.ChatboxEvents;
import cc.reconnected.chatbox.listeners.DiscordEvents;
import cc.reconnected.chatbox.listeners.EssentialsEvents;
import cc.reconnected.chatbox.packets.serverPackets.PingPacket;
import cc.reconnected.chatbox.state.StateSaverAndLoader;
import cc.reconnected.chatbox.ws.WsServer;
import cc.reconnected.library.config.ConfigManager;
import com.google.gson.Gson;
import java.nio.file.Path;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_5218;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RccChatbox
implements ModInitializer {
    public static final String MOD_ID = "rcc-chatbox";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"rcc-chatbox");
    public static RccChatboxConfig CONFIG;
    public static final Gson GSON;
    private static LicenseManager licenseManager;
    private static RccChatbox INSTANCE;
    private WsServer wss;
    private static Path dataDirectory;
    private StateSaverAndLoader serverState;

    public static RccChatbox getInstance() {
        return INSTANCE;
    }

    public RccChatbox() {
        INSTANCE = this;
    }

    public static LicenseManager licenseManager() {
        return licenseManager;
    }

    public void wss(WsServer wss) {
        this.wss = wss;
    }

    public WsServer wss() {
        return this.wss;
    }

    public static Path dataDirectory() {
        return dataDirectory;
    }

    public StateSaverAndLoader serverState() {
        return this.serverState;
    }

    public void onInitialize() {
        try {
            CONFIG = (RccChatboxConfig)ConfigManager.load(RccChatboxConfig.class);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config. Refusing to continue.", (Throwable)e);
            return;
        }
        CommandRegistrationCallback.EVENT.register(ChatboxCommand::register);
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            dataDirectory = server.method_27050(class_5218.field_24188).resolve("data").resolve(MOD_ID);
            licenseManager = new LicenseManager();
            if (!dataDirectory.toFile().isDirectory() && !dataDirectory.toFile().mkdir()) {
                LOGGER.error("Failed to create rcc-chatbox data directory");
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            this.serverState = StateSaverAndLoader.getServerState(server);
        });
        int delay = 1200;
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (server.method_3780() % delay == 0) {
                PingPacket pingPacket = new PingPacket();
                this.wss.broadcastEvent(pingPacket, null);
            }
        });
        ChatboxEvents.register();
        FabricLoader fabricLoader = FabricLoader.getInstance();
        if (fabricLoader.isModLoaded("rcc-essentials")) {
            EssentialsEvents.register();
        }
        if (fabricLoader.isModLoaded("rcc-discord")) {
            DiscordEvents.register();
        }
    }

    static {
        GSON = new Gson();
    }
}

