/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.command;

import cc.reconnected.chatbox.RccChatbox;
import cc.reconnected.chatbox.command.ChatboxCommand;
import cc.reconnected.chatbox.license.Capability;
import cc.reconnected.chatbox.license.License;
import cc.reconnected.chatbox.license.LicenseManager;
import cc.reconnected.chatbox.ws.CloseCodes;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.jetbrains.annotations.Nullable;

public class AdminSubCommand {
    @Nullable
    private static License getLicenseFromArgument(String id, class_3324 playerManager) {
        UUID uuid;
        try {
            uuid = UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            class_3222 player = playerManager.method_14566(id);
            if (player == null) {
                return null;
            }
            uuid = player.method_7334().getId();
        }
        License license = RccChatbox.licenseManager().getLicense(uuid);
        if (license == null) {
            license = RccChatbox.licenseManager().getLicenseFromUser(uuid);
        }
        return license;
    }

    public static LiteralArgumentBuilder<class_2168> register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"admin").requires(Permissions.require((String)"chatbox.admin", (int)3))).executes(context -> {
            String[] commands = new String[]{"<user/license>", "<user/license> revoke", "<user/license> capabilities", "<user/license> capabilities enable <capability>", "<user/license> capabilities disable <capability>"};
            class_5250 text = class_2561.method_43473().method_10852(ChatboxCommand.prefix).method_27693("Chatbox admin commands:").method_10852((class_2561)ChatboxCommand.buildHelpMessage("chatbox admin", commands));
            ((class_2168)context.getSource()).method_9226(() -> text, false);
            return 1;
        })).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"user/license", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            class_3324 playerManager = ((class_2168)context.getSource()).method_9211().method_3760();
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(playerManager.method_14571().stream().map(player -> player.method_7334().getName()).toList());
            list.addAll(RccChatbox.licenseManager().getLicenseList());
            return class_2172.method_9265(list, (SuggestionsBuilder)builder);
        }).executes(context -> {
            class_3324 playerManager;
            String id = StringArgumentType.getString((CommandContext)context, (String)"user/license");
            License license = AdminSubCommand.getLicenseFromArgument(id, playerManager = ((class_2168)context.getSource()).method_9211().method_3760());
            if (license == null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852(ChatboxCommand.prefix).method_10852((class_2561)class_2561.method_43470((String)"Player or license not found").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))), false);
                return 1;
            }
            String playerName = license.userId().toString();
            class_3222 player = playerManager.method_14602(license.userId());
            if (player == null) {
                player = playerManager.method_14602(license.userId());
            }
            if (player != null) {
                playerName = player.method_7334().getName();
            }
            class_5250 text = class_2561.method_43473().method_10852(ChatboxCommand.prefix).method_10852((class_2561)class_2561.method_43470((String)"This license belongs to ").method_10852((class_2561)class_2561.method_43470((String)playerName)));
            ((class_2168)context.getSource()).method_9226(() -> text, false);
            return 1;
        })).then(class_2170.method_9247((String)"revoke").executes(context -> {
            class_3324 playerManager;
            String id = StringArgumentType.getString((CommandContext)context, (String)"user/license");
            License license = AdminSubCommand.getLicenseFromArgument(id, playerManager = ((class_2168)context.getSource()).method_9211().method_3760());
            if (license == null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852(ChatboxCommand.prefix).method_10852((class_2561)class_2561.method_43470((String)"Player or license not found").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))), false);
                return 1;
            }
            String playerName = license.userId().toString();
            class_3222 player = playerManager.method_14602(license.userId());
            if (player == null) {
                player = playerManager.method_14602(license.userId());
            }
            if (player != null) {
                playerName = player.method_7334().getName();
            }
            RccChatbox.licenseManager().deleteLicense(license.uuid());
            RccChatbox.getInstance().wss().closeLicenseClients(license.uuid(), CloseCodes.CHANGED_LICENSE_KEY);
            String finalPlayerName = playerName;
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852(ChatboxCommand.prefix).method_10852((class_2561)class_2561.method_43470((String)("Revoked " + finalPlayerName + " license!")).method_10862(class_2583.field_24360.method_10977(class_124.field_1060))), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"capabilities").executes(context -> {
            class_3324 playerManager;
            String id = StringArgumentType.getString((CommandContext)context, (String)"user/license");
            License license = AdminSubCommand.getLicenseFromArgument(id, playerManager = ((class_2168)context.getSource()).method_9211().method_3760());
            if (license == null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852(ChatboxCommand.prefix).method_10852((class_2561)class_2561.method_43470((String)"Player or license not found").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))), false);
                return 1;
            }
            class_5250 text = class_2561.method_43473().method_10852(ChatboxCommand.prefix).method_27693("License capabilities: ");
            license.capabilities().forEach(c -> text.method_10852(class_2561.method_30163((String)c.name())).method_10852(class_2561.method_30163((String)";")));
            ((class_2168)context.getSource()).method_9226(() -> text, false);
            return 1;
        })).then(class_2170.method_9244((String)"capability", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9264(Arrays.stream(Capability.values()).map(Enum::name), (SuggestionsBuilder)builder)).then(class_2170.method_9244((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            class_5250 text;
            class_3324 playerManager;
            String capabilityName = StringArgumentType.getString((CommandContext)context, (String)"capability");
            boolean toggle = BoolArgumentType.getBool((CommandContext)context, (String)"toggle");
            String id = StringArgumentType.getString((CommandContext)context, (String)"user/license");
            License license = AdminSubCommand.getLicenseFromArgument(id, playerManager = ((class_2168)context.getSource()).method_9211().method_3760());
            if (license == null) {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43473().method_10852(ChatboxCommand.prefix).method_10852((class_2561)class_2561.method_43470((String)"Player or license not found").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))), false);
                return 1;
            }
            String playerName = license.userId().toString();
            class_3222 player = playerManager.method_14602(license.userId());
            if (player == null) {
                player = playerManager.method_14602(license.userId());
            }
            if (player != null) {
                playerName = player.method_7334().getName();
            }
            LicenseManager licenseManager = RccChatbox.licenseManager();
            Capability capability = Capability.valueOf(capabilityName);
            HashSet<Capability> capabilities = new HashSet<Capability>(license.capabilities());
            if (toggle) {
                capabilities.add(capability);
                text = class_2561.method_43470((String)("Granted '" + String.valueOf((Object)capability) + "' to " + playerName)).method_10862(class_2583.field_24360.method_10977(class_124.field_1060));
            } else {
                capabilities.remove((Object)capability);
                text = class_2561.method_43470((String)("Revoked '" + String.valueOf((Object)capability) + "' from " + playerName)).method_10862(class_2583.field_24360.method_10977(class_124.field_1061));
            }
            licenseManager.updateLicense(license.uuid(), capabilities);
            class_5250 finalText = class_2561.method_43473().method_10852(ChatboxCommand.prefix).method_10852((class_2561)text);
            ((class_2168)context.getSource()).method_9226(() -> finalText, true);
            return 1;
        })))));
    }
}

