/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.pronouns;

import cc.reconnected.library.data.PlayerMeta;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pronouns {
    static Logger LOGGER = LoggerFactory.getLogger((String)"rcc-pronouns");

    public static void onServerStart(MinecraftServer server) {
    }

    public static Boolean validatePronoun(String pronoun) {
        return Pattern.matches("^(he|him|she|her|it|its|they|them|any|ask|avoid|other)$", pronoun.toLowerCase());
    }

    public static String setPronouns(class_2168 player, String pronoun) {
        if (!player.method_43737()) {
            return "This command can only be run by a player.";
        }
        if (Objects.equals(pronoun.toLowerCase(), "clear")) {
            PlayerMeta pData = PlayerMeta.getPlayer((UUID)Objects.requireNonNull(player.method_44023()).method_5667());
            pData.set("pronouns", "").join();
            return "Cleared Pronouns.";
        }
        if (!Pronouns.validatePronoun(pronoun).booleanValue()) {
            return "Invalid pronouns.";
        }
        PlayerMeta pData = PlayerMeta.getPlayer((UUID)Objects.requireNonNull(player.method_44023()).method_5667());
        pData.delete("pronouns").join();
        pData.set("pronouns", pronoun.toLowerCase() + ",").join();
        return "Changed Pronouns";
    }

    public static String setPronouns(class_2168 player, String pronoun1, String pronoun2) {
        if (!player.method_43737()) {
            return "This command can only be run by a player.";
        }
        if (!Pronouns.validatePronoun(pronoun1).booleanValue() || !Pronouns.validatePronoun(pronoun2).booleanValue()) {
            return "Invalid pronouns.";
        }
        PlayerMeta pData = PlayerMeta.getPlayer((UUID)Objects.requireNonNull(player.method_44023()).method_5667());
        try {
            pData.delete("pronouns").join();
            pData.set("pronouns", pronoun1.toLowerCase() + "/" + pronoun2.toLowerCase()).join();
        }
        catch (Exception e) {
            LOGGER.error("Error setting pronouns", (Throwable)e);
            return "Error setting pronouns";
        }
        return "Changed Pronouns";
    }

    public static String getPronouns(UUID player) {
        PlayerMeta pData = PlayerMeta.getPlayer((UUID)player);
        String pronouns = pData.get("pronouns");
        if (pronouns == null || pronouns.isBlank()) {
            return ",";
        }
        return pronouns.toLowerCase();
    }
}

