/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.license;

import java.util.HashSet;
import java.util.Set;

public enum Capability {
    TELL(1),
    READ(2),
    COMMAND(4),
    SAY(8);

    public static final Set<Capability> DEFAULT;
    public final int value;

    private Capability(int value) {
        this.value = value;
    }

    public static Set<Capability> unpack(int packed) {
        HashSet<Capability> set = new HashSet<Capability>();
        for (Capability c : Capability.values()) {
            if ((packed & c.value) == 0) continue;
            set.add(c);
        }
        return set;
    }

    public static int pack(Set<Capability> capabilities) {
        int packed = 0;
        for (Capability capability : capabilities) {
            packed += capability.value;
        }
        return packed;
    }

    static {
        DEFAULT = Set.of(TELL, READ, COMMAND);
    }
}

