/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.license;

import cc.reconnected.chatbox.RccChatbox;
import cc.reconnected.chatbox.license.Capability;
import cc.reconnected.chatbox.license.License;
import cc.reconnected.chatbox.state.StateSaverAndLoader;
import cc.reconnected.library.data.PlayerMeta;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.Nullable;

public class LicenseManager {
    public static final UUID guestLicenseUuid = new UUID(0L, 0L);
    public static final License guestLicense = new License(guestLicenseUuid, guestLicenseUuid);
    public static final String nodePrefix = "chatbox";
    private final Path licensesPath;
    private ConcurrentHashMap<UUID, License> licenses;

    public List<String> getLicenseList() {
        return this.licenses.keySet().stream().map(UUID::toString).toList();
    }

    public LicenseManager() {
        guestLicense.capabilities().clear();
        guestLicense.capabilities().add(Capability.READ);
        this.licensesPath = RccChatbox.dataDirectory().resolve("licenses.json");
        if (this.licensesPath.toFile().exists()) {
            try (BufferedReader stream = new BufferedReader(new FileReader(this.licensesPath.toFile(), StandardCharsets.UTF_8));){
                Type type = new TypeToken<ConcurrentHashMap<UUID, License>>(){}.getType();
                this.licenses = (ConcurrentHashMap)RccChatbox.GSON.fromJson((Reader)stream, type);
            }
            catch (FileNotFoundException e) {
                RccChatbox.LOGGER.error("If you read this I messed up", (Throwable)e);
            }
            catch (IOException e) {
                RccChatbox.LOGGER.error("Exception reading licenses data", (Throwable)e);
            }
        } else {
            this.licenses = new ConcurrentHashMap();
        }
    }

    private void saveData() {
        String output = RccChatbox.GSON.toJson(this.licenses);
        try (FileWriter stream = new FileWriter(this.licensesPath.toFile(), StandardCharsets.UTF_8);){
            stream.write(output);
        }
        catch (IOException e) {
            RccChatbox.LOGGER.error("Exception saving licenses data", (Throwable)e);
        }
    }

    private License buildLicense(String uuid, String userId, int packedCapabilities) {
        License license = new License(UUID.fromString(uuid), UUID.fromString(userId));
        license.capabilities().addAll(Capability.unpack(packedCapabilities));
        return license;
    }

    @Nullable
    public License getLicense(UUID licenseId) {
        if (licenseId.equals(guestLicenseUuid)) {
            return guestLicense;
        }
        if (this.licenses.containsKey(licenseId)) {
            return this.licenses.get(licenseId);
        }
        StateSaverAndLoader serverState = RccChatbox.getInstance().serverState();
        if (!serverState.licenses.containsKey(licenseId)) {
            return null;
        }
        UUID ownerUuid = serverState.licenses.get(licenseId);
        PlayerMeta playerData = PlayerMeta.getPlayer((UUID)ownerUuid);
        String licenseUuid = playerData.get("chatbox.license_uuid");
        String capabilitiesStr = playerData.get("chatbox.capabilities");
        int packedCapabilities = 0;
        if (capabilitiesStr != null) {
            try {
                packedCapabilities = Integer.parseInt(capabilitiesStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        serverState.licenses.remove(licenseId);
        License license = this.buildLicense(licenseUuid, ownerUuid.toString(), packedCapabilities);
        this.licenses.put(license.uuid(), license);
        this.saveData();
        playerData.delete("chatbox.license_uuid").join();
        playerData.delete("chatbox.capabilities").join();
        return license;
    }

    @Nullable
    public License getLicenseFromUser(UUID userId) {
        if (userId.equals(guestLicenseUuid)) {
            return guestLicense;
        }
        License license = this.licenses.values().stream().filter(l -> l.userId().equals(userId)).findFirst().orElse(null);
        if (license != null) {
            return license;
        }
        PlayerMeta playerData = PlayerMeta.getPlayer((UUID)userId);
        String licenseUuid = playerData.get("chatbox.license_uuid");
        if (licenseUuid == null) {
            return null;
        }
        return this.getLicense(UUID.fromString(licenseUuid));
    }

    public License createLicense(UUID userId, Set<Capability> capabilities) {
        if (userId.equals(guestLicenseUuid)) {
            return guestLicense;
        }
        License license = this.getLicenseFromUser(userId);
        if (license != null) {
            return license;
        }
        UUID uuid = UUID.randomUUID();
        license = new License(uuid, userId);
        license.capabilities().addAll(capabilities);
        this.licenses.put(uuid, license);
        this.saveData();
        return license;
    }

    public boolean deleteLicense(UUID licenseId) {
        if (licenseId.equals(guestLicenseUuid)) {
            return false;
        }
        License license = this.getLicense(licenseId);
        if (license == null) {
            return false;
        }
        PlayerMeta playerData = PlayerMeta.getPlayer((UUID)license.userId());
        playerData.delete("chatbox.license_uuid").join();
        playerData.delete("chatbox.capabilities").join();
        RccChatbox.getInstance().serverState().licenses.remove(license.uuid());
        this.licenses.remove(license.uuid());
        this.saveData();
        return true;
    }

    public boolean updateLicense(UUID licenseId, Set<Capability> capabilities) {
        if (licenseId.equals(guestLicenseUuid)) {
            return false;
        }
        License license = this.getLicense(licenseId);
        if (license == null) {
            return false;
        }
        license.capabilities().clear();
        license.capabilities().addAll(capabilities);
        this.saveData();
        return true;
    }

    public static class KEYS {
        public static final String licenseUuid = "chatbox.license_uuid";
        public static final String capabilities = "chatbox.capabilities";
    }
}

