/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.listeners;

import cc.reconnected.chatbox.ClientPacketsHandler;
import cc.reconnected.chatbox.RccChatbox;
import cc.reconnected.chatbox.api.events.ClientConnectionEvents;
import cc.reconnected.chatbox.api.events.PlayerCommandEvent;
import cc.reconnected.chatbox.license.Capability;
import cc.reconnected.chatbox.models.User;
import cc.reconnected.chatbox.packets.serverPackets.HelloPacket;
import cc.reconnected.chatbox.packets.serverPackets.PlayersPacket;
import cc.reconnected.chatbox.packets.serverPackets.events.CommandEvent;
import cc.reconnected.chatbox.packets.serverPackets.events.DeathEvent;
import cc.reconnected.chatbox.packets.serverPackets.events.InGameChatEvent;
import cc.reconnected.chatbox.packets.serverPackets.events.JoinEvent;
import cc.reconnected.chatbox.packets.serverPackets.events.LeaveEvent;
import cc.reconnected.chatbox.packets.serverPackets.events.WorldChangeEvent;
import cc.reconnected.chatbox.state.ChatboxPlayerState;
import cc.reconnected.chatbox.state.StateSaverAndLoader;
import cc.reconnected.chatbox.utils.DateUtils;
import cc.reconnected.chatbox.ws.CloseCodes;
import cc.reconnected.chatbox.ws.WsServer;
import cc.reconnected.library.data.PlayerMeta;
import cc.reconnected.library.text.parser.MarkdownParser;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.message.v1.ServerMessageEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class ChatboxEvents {
    public static final Set<Character> publicPrefixes = Set.of(Character.valueOf('\\'));
    public static final Set<Character> ownerPrefixes = Set.of(Character.valueOf('|'), Character.valueOf('^'));
    public static final HashMap<UUID, Boolean> spyingPlayers = new HashMap();
    private static MinecraftServer mcServer;

    public static void register() {
        ClientPacketsHandler.register();
        ClientConnectionEvents.CONNECT.register((conn, license, isGuest) -> {
            PlayerMeta playerData = PlayerMeta.getPlayer((UUID)license.userId());
            HelloPacket helloPacket = new HelloPacket();
            helloPacket.capabilities = (String[])license.capabilities().stream().map(c -> c.toString().toLowerCase()).toArray(String[]::new);
            helloPacket.guest = isGuest;
            if (!isGuest) {
                helloPacket.licenseOwner = playerData.getEffectiveName();
                class_3222 mcPlayer = mcServer.method_3760().method_14602(license.userId());
                helloPacket.licenseOwnerUser = mcPlayer != null ? User.create(mcPlayer) : User.tryGet(license.userId(), true);
                license.user = helloPacket.licenseOwnerUser;
            }
            String packetJson = RccChatbox.GSON.toJson((Object)helloPacket);
            conn.send(packetJson);
        });
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            mcServer = server;
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            WsServer wss = new WsServer(new InetSocketAddress(RccChatbox.CONFIG.hostname, (int)RccChatbox.CONFIG.port));
            Thread wssThread = new Thread(() -> ((WsServer)wss).start());
            wssThread.start();
            RccChatbox.getInstance().wss(wss);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            if (RccChatbox.getInstance().wss() != null) {
                try {
                    WsServer wss = RccChatbox.getInstance().wss();
                    wss.closeAllClients(CloseCodes.SERVER_STOPPING);
                    wss.stop();
                }
                catch (InterruptedException e) {
                    RccChatbox.LOGGER.error("Failed to stop WebSocket server", (Throwable)e);
                }
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            JoinEvent joinPacket = new JoinEvent();
            joinPacket.user = User.create(handler.method_32311());
            joinPacket.time = DateUtils.getTime(new Date());
            ChatboxPlayerState playerState = StateSaverAndLoader.getPlayerState((class_1309)handler.method_32311());
            spyingPlayers.put(handler.method_32311().method_5667(), playerState.enableSpy);
            RccChatbox.getInstance().wss().broadcastEvent(joinPacket, Capability.READ);
            ArrayList<class_3222> list = new ArrayList<class_3222>(server.method_3760().method_14571());
            list.add(handler.method_32311());
            RccChatbox.getInstance().wss().broadcastEvent(ChatboxEvents.createPlayersPacket(list), Capability.READ);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            LeaveEvent leavePacket = new LeaveEvent();
            leavePacket.user = User.create(handler.method_32311());
            leavePacket.time = DateUtils.getTime(new Date());
            spyingPlayers.remove(handler.method_32311().method_5667());
            RccChatbox.getInstance().wss().broadcastEvent(leavePacket, Capability.READ);
            ArrayList<class_3222> list = new ArrayList<class_3222>(server.method_3760().method_14571());
            list.removeIf(p -> p.method_5667() == handler.method_32311().method_5667());
            RccChatbox.getInstance().wss().broadcastEvent(ChatboxEvents.createPlayersPacket(list), Capability.READ);
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (!(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            DeathEvent deathPacket = new DeathEvent();
            class_1297 source = damageSource.method_5526();
            class_2561 message = damageSource.method_5506(entity);
            deathPacket.text = message.getString();
            deathPacket.rawText = message.getString();
            deathPacket.renderedText = class_2561.class_2562.method_10868((class_2561)message);
            deathPacket.user = User.create(player);
            if (source instanceof class_3222) {
                deathPacket.source = User.create((class_3222)source);
            }
            deathPacket.time = DateUtils.getTime(new Date());
            RccChatbox.getInstance().wss().broadcastEvent(deathPacket, Capability.READ);
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            WorldChangeEvent worldChangePacket = new WorldChangeEvent();
            worldChangePacket.user = User.create(player);
            worldChangePacket.origin = origin.method_27983().method_29177().toString();
            worldChangePacket.destination = destination.method_27983().method_29177().toString();
            worldChangePacket.time = DateUtils.getTime(new Date());
            RccChatbox.getInstance().wss().broadcastEvent(worldChangePacket, Capability.READ);
        });
        ServerMessageEvents.CHAT_MESSAGE.register((message, sender, params) -> {
            InGameChatEvent packet = new InGameChatEvent();
            class_2561 parsedMessage = MarkdownParser.defaultParser.parseNode(message.method_46291().getString()).toText();
            packet.text = parsedMessage.getString();
            packet.rawText = message.method_46291().getString();
            packet.renderedText = class_2561.class_2562.method_10868((class_2561)parsedMessage);
            packet.time = DateUtils.getTime(new Date());
            packet.user = User.create(sender);
            RccChatbox.getInstance().wss().broadcastEvent(packet, Capability.READ);
        });
        PlayerCommandEvent.EVENT.register((player, command, args, ownerOnly) -> {
            CommandEvent packet = new CommandEvent();
            packet.command = command;
            packet.args = args;
            packet.ownerOnly = ownerOnly;
            packet.user = User.create(player);
            packet.time = DateUtils.getTime(new Date());
            if (ownerOnly) {
                RccChatbox.getInstance().wss().broadcastOwnerEvent(packet, Capability.COMMAND, player.method_5667());
            } else {
                RccChatbox.getInstance().wss().broadcastEvent(packet, Capability.COMMAND);
            }
        });
        ServerMessageEvents.ALLOW_CHAT_MESSAGE.register((message, sender, params) -> {
            String content = message.method_46291().getString();
            if (content.isEmpty()) {
                return true;
            }
            char prefix = content.charAt(0);
            if (!publicPrefixes.contains(Character.valueOf(prefix)) && !ownerPrefixes.contains(Character.valueOf(prefix))) {
                return true;
            }
            boolean isOwnerOnly = ownerPrefixes.contains(Character.valueOf(prefix));
            String cbLog = String.format("%s: %s", sender.method_5477().getString(), content);
            RccChatbox.LOGGER.info(cbLog);
            String[] tokens = content.split(" +");
            if (tokens.length == 0) {
                return false;
            }
            String command = tokens[0].substring(1);
            String[] args = Arrays.copyOfRange(tokens, 1, tokens.length);
            ((PlayerCommandEvent)PlayerCommandEvent.EVENT.invoker()).onCommand(sender, command, args, isOwnerOnly);
            if (!isOwnerOnly) {
                MinecraftServer server = sender.method_5682();
                if (server == null) {
                    return true;
                }
                class_3324 playerManager = server.method_3760();
                class_5250 text = class_2561.method_43470((String)(sender.method_5477().getString() + ": ")).method_10862(class_2583.field_24360.method_10977(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)content).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
                playerManager.method_14571().forEach(player -> {
                    if (spyingPlayers.containsKey(player.method_5667()) && spyingPlayers.get(player.method_5667()).booleanValue()) {
                        player.method_7353((class_2561)text, false);
                    }
                });
            }
            return false;
        });
    }

    public static PlayersPacket createPlayersPacket(List<class_3222> list) {
        PlayersPacket packet = new PlayersPacket();
        packet.time = DateUtils.getTime(new Date());
        packet.players = new User[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            User user;
            class_3222 player = list.get(i);
            packet.players[i] = user = User.create(player, true);
        }
        return packet;
    }

    public static PlayersPacket createPlayersPacket() {
        List list = mcServer.method_3760().method_14571();
        return ChatboxEvents.createPlayersPacket(list);
    }
}

