/*
 * Decompiled with CFR 0.152.
 */
package cc.reconnected.chatbox.ws;

import cc.reconnected.chatbox.RccChatbox;
import cc.reconnected.chatbox.api.events.ChatboxMessageEvents;
import cc.reconnected.chatbox.api.events.ClientConnectionEvents;
import cc.reconnected.chatbox.license.Capability;
import cc.reconnected.chatbox.license.License;
import cc.reconnected.chatbox.license.LicenseManager;
import cc.reconnected.chatbox.packets.clientPackets.ClientPacketBase;
import cc.reconnected.chatbox.packets.clientPackets.SayPacket;
import cc.reconnected.chatbox.packets.clientPackets.TellPacket;
import cc.reconnected.chatbox.packets.serverPackets.ErrorPacket;
import cc.reconnected.chatbox.parsers.Formats;
import cc.reconnected.chatbox.ws.ChatboxClient;
import cc.reconnected.chatbox.ws.ClientErrors;
import cc.reconnected.chatbox.ws.CloseCodes;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.util.InetAddressConverter;
import org.java_websocket.WebSocket;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.server.WebSocketServer;
import org.jetbrains.annotations.Nullable;

public class WsServer
extends WebSocketServer {
    public static final Pattern PATH_LICENSE = Pattern.compile("^/([0-9a-z-]+)$", 2);
    private final ConcurrentHashMap<WebSocket, ChatboxClient> clients = new ConcurrentHashMap();
    private final InetAddress guestAddress;
    public static final int messageMaxLength = 1024;
    public static final int nameMaxLength = 64;

    public ConcurrentHashMap<WebSocket, ChatboxClient> clients() {
        return this.clients;
    }

    public WsServer(InetSocketAddress address) {
        super(address);
        this.guestAddress = new InetAddressConverter().convert(RccChatbox.CONFIG.guestAllowedAddress);
    }

    public void onOpen(WebSocket conn, ClientHandshake handshake) {
        License license;
        UUID licenseUuid;
        String path;
        Matcher matcher;
        InetAddress clientAddress = conn.getRemoteSocketAddress().getAddress();
        if (handshake.hasFieldValue("X-Forwarded-For")) {
            clientAddress = new InetAddressConverter().convert(handshake.getFieldValue("X-Forwarded-For"));
        }
        if (!(matcher = PATH_LICENSE.matcher(path = conn.getResourceDescriptor())).find()) {
            conn.close(CloseCodes.INVALID_LICENSE_KEY.code, CloseCodes.INVALID_LICENSE_KEY.getErrorString());
            return;
        }
        String licenseString = matcher.group(1);
        if (licenseString == null) {
            conn.close(CloseCodes.INVALID_LICENSE_KEY.code, CloseCodes.INVALID_LICENSE_KEY.getErrorString());
            return;
        }
        if (licenseString.equals("guest")) {
            if (!clientAddress.equals(this.guestAddress)) {
                conn.close(CloseCodes.EXTERNAL_GUESTS_NOT_ALLOWED.code, CloseCodes.EXTERNAL_GUESTS_NOT_ALLOWED.getErrorString());
                return;
            }
            licenseUuid = LicenseManager.guestLicenseUuid;
        } else {
            try {
                licenseUuid = UUID.fromString(licenseString);
            }
            catch (IllegalArgumentException e) {
                conn.close(CloseCodes.INVALID_LICENSE_KEY.code, CloseCodes.INVALID_LICENSE_KEY.getErrorString());
                return;
            }
        }
        try {
            license = RccChatbox.licenseManager().getLicense(licenseUuid);
        }
        catch (Exception e) {
            conn.close(CloseCodes.FATAL_ERROR.code, CloseCodes.FATAL_ERROR.getErrorString());
            RccChatbox.LOGGER.error("Failed to load license", (Throwable)e);
            return;
        }
        if (license == null) {
            conn.close(CloseCodes.UNKNOWN_LICENSE_KEY.code, CloseCodes.UNKNOWN_LICENSE_KEY.getErrorString());
            return;
        }
        this.clients.put(conn, new ChatboxClient(license, conn, clientAddress));
        RccChatbox.LOGGER.info("[{}] New connection with license {} ({})", new Object[]{clientAddress, license.uuid(), license.userId()});
        ((ClientConnectionEvents.Connection)ClientConnectionEvents.CONNECT.invoker()).onConnect(conn, license, license.userId().equals(LicenseManager.guestLicenseUuid));
    }

    public void onClose(WebSocket conn, int code, String reason, boolean remote) {
        if (!this.clients.containsKey(conn)) {
            return;
        }
        ChatboxClient client = this.clients.remove(conn);
        ((ClientConnectionEvents.Disconnection)ClientConnectionEvents.DISCONNECT.invoker()).onDisconnect(conn, client.license, code, reason, remote);
    }

    public void onMessage(WebSocket conn, String message) {
        int id;
        ClientPacketBase packet;
        RccChatbox.LOGGER.debug(message);
        try {
            packet = (ClientPacketBase)RccChatbox.GSON.fromJson(message, ClientPacketBase.class);
        }
        catch (Exception e) {
            ClientErrors err = ClientErrors.UNKNOWN_ERROR;
            conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, -1)));
            return;
        }
        if (packet == null) {
            ClientErrors err = ClientErrors.UNKNOWN_ERROR;
            conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, -1)));
            return;
        }
        ChatboxClient client = this.clients.get(conn);
        int n = id = packet.id != null ? packet.id : -1;
        if (packet.type == null) {
            packet.type = "unknown";
        }
        switch (packet.type) {
            case "say": {
                SayPacket sayPacket = (SayPacket)RccChatbox.GSON.fromJson(message, SayPacket.class);
                sayPacket.id = id;
                if (!client.license.capabilities().contains((Object)Capability.SAY)) {
                    ClientErrors err = ClientErrors.MISSING_CAPABILITY;
                    conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, id)));
                    return;
                }
                if (sayPacket.text == null) {
                    ClientErrors err = ClientErrors.MISSING_TEXT;
                    conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, id)));
                    return;
                }
                if (sayPacket.mode == null) {
                    sayPacket.mode = "markdown";
                }
                if (!Formats.available.contains(sayPacket.mode)) {
                    ClientErrors err = ClientErrors.INVALID_MODE;
                    conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, id)));
                    return;
                }
                sayPacket.text = sayPacket.text.substring(0, Math.min(sayPacket.text.length(), 1024));
                if (sayPacket.name != null) {
                    sayPacket.name = sayPacket.name.trim().replace("\n", "");
                    sayPacket.name = sayPacket.name.substring(0, Math.min(sayPacket.name.length(), 64));
                }
                ((ChatboxMessageEvents.Say)ChatboxMessageEvents.SAY.invoker()).onSay(client, sayPacket);
                break;
            }
            case "tell": {
                TellPacket tellPacket = (TellPacket)RccChatbox.GSON.fromJson(message, TellPacket.class);
                tellPacket.id = id;
                if (!client.license.capabilities().contains((Object)Capability.TELL)) {
                    ClientErrors err = ClientErrors.MISSING_CAPABILITY;
                    conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, id)));
                    return;
                }
                if (tellPacket.user == null) {
                    ClientErrors err = ClientErrors.MISSING_USER;
                    conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, id)));
                    return;
                }
                if (tellPacket.text == null) {
                    ClientErrors err = ClientErrors.MISSING_TEXT;
                    conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, id)));
                    return;
                }
                if (tellPacket.mode == null) {
                    tellPacket.mode = "markdown";
                }
                if (!Formats.available.contains(tellPacket.mode)) {
                    ClientErrors err = ClientErrors.INVALID_MODE;
                    conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, id)));
                    return;
                }
                tellPacket.text = tellPacket.text.substring(0, Math.min(tellPacket.text.length(), 1024));
                if (tellPacket.name != null) {
                    tellPacket.name = tellPacket.name.trim().replace("\n", "");
                    tellPacket.name = tellPacket.name.substring(0, Math.min(tellPacket.name.length(), 64));
                }
                ((ChatboxMessageEvents.Tell)ChatboxMessageEvents.TELL.invoker()).onTell(client, tellPacket);
                break;
            }
            default: {
                ClientErrors err = ClientErrors.UNKNOWN_TYPE;
                conn.send(RccChatbox.GSON.toJson((Object)new ErrorPacket(err.getErrorMessage(), err.message, id)));
            }
        }
    }

    public void onError(WebSocket conn, Exception ex) {
        if (conn != null) {
            InetAddress address = conn.getRemoteSocketAddress().getAddress();
            ChatboxClient client = this.clients.get(conn);
            if (client != null) {
                address = client.address;
            }
            RccChatbox.LOGGER.error("WebSocket client failure {}", (Object)address);
            RccChatbox.LOGGER.error("Exception thrown:", (Throwable)ex);
        } else {
            RccChatbox.LOGGER.error("WebSocket failure", (Throwable)ex);
        }
    }

    public void onStart() {
        RccChatbox.LOGGER.info("WebSocket server listening on port {}", (Object)this.getPort());
    }

    public void broadcastEvent(Object packet, @Nullable Capability capability) {
        String msg = RccChatbox.GSON.toJson(packet);
        if (capability == null) {
            this.broadcast(msg);
        } else {
            List<WebSocket> recipients = this.clients.entrySet().stream().filter(e -> ((ChatboxClient)e.getValue()).license.capabilities().contains((Object)capability)).map(Map.Entry::getKey).toList();
            for (WebSocket conn : recipients) {
                conn.send(msg);
            }
        }
    }

    public void broadcastOwnerEvent(Object packet, @Nullable Capability capability, UUID ownerId) {
        String msg = RccChatbox.GSON.toJson(packet);
        List<Map.Entry> ownerClients = this.clients.entrySet().stream().filter(entry -> ((ChatboxClient)entry.getValue()).license.userId().equals(ownerId)).toList();
        List<WebSocket> recipients = capability == null ? ownerClients.stream().map(Map.Entry::getKey).toList() : ownerClients.stream().filter(e -> ((ChatboxClient)e.getValue()).license.capabilities().contains((Object)capability)).map(Map.Entry::getKey).toList();
        for (WebSocket conn : recipients) {
            conn.send(msg);
        }
    }

    public void closeAllClients(CloseCodes closeCode) {
        this.clients.forEach((conn, client) -> conn.close(closeCode.code, closeCode.message));
    }

    public void closeLicenseClients(UUID license, CloseCodes closeCode) {
        this.clients.entrySet().stream().filter(entry -> ((ChatboxClient)entry.getValue()).license.uuid().equals(license)).forEach(entry -> {
            WebSocket conn = (WebSocket)entry.getKey();
            conn.close(closeCode.code, closeCode.message);
        });
    }
}

