/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.prometheus.collectors;

import cc.tweaked.prometheus.MetricContext;
import dan200.computercraft.core.util.ThreadUtils;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.ArrayList;
import java.util.List;

public class ThreadGroupCollector
extends Collector
implements Collector.Describable {
    private static final String FULL_NAME = "computercraft_thread_count";
    private static final String HELP = "Number of currently live threads";
    private static final List<String> LABEL_NAMES = List.of("group");
    private final ThreadGroup mainGroup = ThreadUtils.group();
    private ThreadGroup[] groups;

    private ThreadGroupCollector() {
    }

    public static void register(MetricContext context) {
        context.registry().register((Collector)new ThreadGroupCollector());
    }

    public List<Collector.MetricFamilySamples> describe() {
        return List.of(new GaugeMetricFamily(FULL_NAME, HELP, LABEL_NAMES));
    }

    public List<Collector.MetricFamilySamples> collect() {
        int size = this.mainGroup.activeGroupCount();
        ThreadGroup[] groups = this.groups;
        if (groups == null || size > groups.length) {
            this.groups = new ThreadGroup[size];
            groups = this.groups;
        }
        ArrayList<Collector.MetricFamilySamples.Sample> samples = new ArrayList<Collector.MetricFamilySamples.Sample>(size);
        int count = this.mainGroup.enumerate(groups, true);
        for (int i = 0; i < count; ++i) {
            ThreadGroup group = groups[i];
            samples.add(new Collector.MetricFamilySamples.Sample(FULL_NAME, LABEL_NAMES, List.of(group.getName()), (double)group.activeCount()));
        }
        return List.of(new Collector.MetricFamilySamples(FULL_NAME, "count", Collector.Type.GAUGE, HELP, samples));
    }
}

