/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked.prometheus.mixin;

import cc.tweaked.prometheus.collectors.VanillaCollector;
import net.minecraft.class_156;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
class MinecraftServerMixin
implements VanillaCollector.MinecraftServerTimings {
    @Unique
    private VanillaCollector.TimingObserver observer;
    @Unique
    private float averageTickTime;
    @Unique
    private long tickStart;

    MinecraftServerMixin() {
    }

    @Inject(at={@At(value="HEAD")}, method={"startMetricsRecordingTick"})
    private void beforeTick(CallbackInfo ci) {
        this.tickStart = class_156.method_648();
    }

    @Inject(method={"waitUntilNextTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;managedBlock(Ljava/util/function/BooleanSupplier;)V")})
    private void afterTick(CallbackInfo ci) {
        long time = class_156.method_648() - this.tickStart;
        this.averageTickTime = this.averageTickTime * 0.8f + (float)time / 1000000.0f * 0.19999999f;
        if (this.observer != null) {
            this.observer.onServerTick(time, this.averageTickTime);
        }
    }

    @Override
    public void prometheus$setTimingObserver(VanillaCollector.TimingObserver observer) {
        this.observer = observer;
    }
}

