/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.bukkit.entity;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.function.Function;
import me.neznamy.tab.platforms.bukkit.BukkitTabPlayer;
import me.neznamy.tab.platforms.bukkit.BukkitUtils;
import me.neznamy.tab.platforms.bukkit.entity.DataWatcher;
import me.neznamy.tab.platforms.bukkit.nms.BukkitReflection;
import me.neznamy.tab.platforms.bukkit.nms.PacketSender;
import me.neznamy.tab.shared.backend.EntityData;
import me.neznamy.tab.shared.backend.Location;
import me.neznamy.tab.shared.backend.entityview.EntityView;
import me.neznamy.tab.shared.util.BiConsumerWithException;
import me.neznamy.tab.shared.util.BiFunctionWithException;
import me.neznamy.tab.shared.util.FunctionWithException;
import me.neznamy.tab.shared.util.QuadFunction;
import me.neznamy.tab.shared.util.QuintFunction;
import me.neznamy.tab.shared.util.ReflectionUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class PacketEntityView
implements EntityView {
    private static final int SPLIT_METADATA_VERSION = 15;
    private static PacketSender packetSender;
    private static Class<?> EntityDestroyClass;
    private static BiConsumerWithException<BukkitTabPlayer, int[]> destroyEntities;
    private static FunctionWithException<Object, int[]> getDestroyedEntities;
    private static BiFunctionWithException<Integer, EntityData, Object> newEntityMetadata;
    private static BiFunctionWithException<Integer, Location, Object> newEntityTeleport;
    private static Class<?> EntityTeleportClass;
    private static Field EntityTeleport_EntityId;
    private static QuintFunction<Integer, UUID, Object, Location, EntityData, Object> newSpawnEntity;
    private static Class<?> PacketPlayOutEntity;
    private static Field PacketPlayOutEntity_ENTITYID;
    private static Field PacketPlayOutEntity_X;
    private static Field PacketPlayOutEntity_Y;
    private static Field PacketPlayOutEntity_Z;
    private static Class<?> PacketPlayOutEntityLook;
    private static QuadFunction<Integer, Long, Long, Long, Object> newMovePacket;
    private static Class<?> PacketPlayOutNamedEntitySpawn;
    private static Field PacketPlayOutNamedEntitySpawn_ENTITYID;
    private static Constructor<?> newClientboundBundlePacket;
    private static Field ClientboundBundlePacket_packets;
    private static Function<Object, Boolean> isBundlePacket;
    private static BiConsumerWithException<BukkitTabPlayer, Iterable<?>> sendAsBundle;
    private static boolean available;
    private final BukkitTabPlayer player;

    public static void tryLoad() {
        try {
            DataWatcher.load();
            PacketEntityView.loadEntityMetadata();
            PacketEntityView.loadEntityDestroy();
            PacketEntityView.loadEntityTeleport();
            PacketEntityView.loadEntityMove();
            PacketEntityView.loadEntitySpawn();
            if (BukkitReflection.is1_19_4Plus()) {
                Class<?> ClientboundBundlePacket = Class.forName("net.minecraft.network.protocol.game.ClientboundBundlePacket");
                newClientboundBundlePacket = ClientboundBundlePacket.getConstructor(Iterable.class);
                ClientboundBundlePacket_packets = ReflectionUtils.getOnlyField(ClientboundBundlePacket.getSuperclass(), Iterable.class);
                isBundlePacket = ClientboundBundlePacket::isInstance;
                sendAsBundle = (player, packets) -> packetSender.sendPacket(player.getPlayer(), newClientboundBundlePacket.newInstance(packets));
            }
            packetSender = new PacketSender();
            available = true;
        }
        catch (Exception e) {
            ArrayList<String> missingFeatures = new ArrayList<String>();
            if (BukkitReflection.getMinorVersion() >= 8) {
                missingFeatures.add("Unlimited nametag mode not working and being replaced with regular nametags");
            }
            if (BukkitReflection.getMinorVersion() <= 8) {
                missingFeatures.add("BossBar feature not working");
            }
            BukkitUtils.compatibilityError(e, "sending entity packets", null, missingFeatures.toArray(new String[0]));
        }
    }

    private static void loadEntityMetadata() throws ReflectiveOperationException {
        Class<?> entityMetadataClass = BukkitReflection.getClass("network.protocol.game.ClientboundSetEntityDataPacket", "network.protocol.game.PacketPlayOutEntityMetadata", "PacketPlayOutEntityMetadata", "Packet40EntityMetadata");
        if (BukkitReflection.is1_19_3Plus()) {
            Constructor<?> constructor = entityMetadataClass.getConstructor(Integer.TYPE, List.class);
            newEntityMetadata = (entityId, data) -> constructor.newInstance(entityId, data.build());
        } else {
            Constructor<?> constructor = entityMetadataClass.getConstructor(Integer.TYPE, DataWatcher.DataWatcher, Boolean.TYPE);
            newEntityMetadata = (entityId, data) -> constructor.newInstance(entityId, data.build(), true);
        }
    }

    private static void loadEntityDestroy() throws ReflectiveOperationException {
        EntityDestroyClass = BukkitReflection.getClass("network.protocol.game.ClientboundRemoveEntitiesPacket", "network.protocol.game.PacketPlayOutEntityDestroy", "PacketPlayOutEntityDestroy", "Packet29DestroyEntity");
        Field entities = ReflectionUtils.getOnlyField(EntityDestroyClass);
        try {
            Constructor<?> constructor = EntityDestroyClass.getConstructor(int[].class);
            destroyEntities = (player, ids) -> packetSender.sendPacket(player.getPlayer(), constructor.newInstance(ids));
            getDestroyedEntities = BukkitReflection.getMinorVersion() >= 17 ? packet -> ((List)entities.get(packet)).stream().mapToInt(i -> i).toArray() : packet -> (int[])entities.get(packet);
        }
        catch (NoSuchMethodException e) {
            Constructor<?> constructor = EntityDestroyClass.getConstructor(Integer.TYPE);
            destroyEntities = (player, ids) -> {
                for (int entity : ids) {
                    packetSender.sendPacket(player.getPlayer(), constructor.newInstance(entity));
                }
            };
            getDestroyedEntities = packet -> new int[]{entities.getInt(packet)};
        }
    }

    private static void loadEntityTeleport() throws ReflectiveOperationException {
        Field EntityTeleport_Z;
        Field EntityTeleport_Y;
        Field EntityTeleport_X;
        Callable<Object> newPacket;
        EntityTeleportClass = BukkitReflection.getClass("network.protocol.game.ClientboundTeleportEntityPacket", "network.protocol.game.PacketPlayOutEntityTeleport", "PacketPlayOutEntityTeleport", "Packet34EntityTeleport");
        if (BukkitReflection.getMinorVersion() >= 17) {
            Class<?> world = BukkitReflection.getClass("world.level.Level", "world.level.World", "World");
            Class<?> entityArmorStand = BukkitReflection.getClass("world.entity.decoration.ArmorStand", "world.entity.decoration.EntityArmorStand", "EntityArmorStand");
            Constructor<?> newEntityArmorStand = entityArmorStand.getConstructor(world, Double.TYPE, Double.TYPE, Double.TYPE);
            Method World_getHandle = BukkitReflection.getBukkitClass("CraftWorld").getMethod("getHandle", new Class[0]);
            Object dummyEntity = newEntityArmorStand.newInstance(World_getHandle.invoke(Bukkit.getWorlds().get(0), new Object[0]), 0, 0, 0);
            Constructor<?> constructor = EntityTeleportClass.getConstructor(BukkitReflection.getClass("world.entity.Entity"));
            newPacket = () -> constructor.newInstance(dummyEntity);
        } else {
            Constructor<?> constructor = EntityTeleportClass.getConstructor(new Class[0]);
            newPacket = () -> constructor.newInstance(new Object[0]);
        }
        EntityTeleport_EntityId = ReflectionUtils.getFields(EntityTeleportClass, Integer.TYPE).get(0);
        if (BukkitReflection.getMinorVersion() >= 9) {
            EntityTeleport_X = ReflectionUtils.getFields(EntityTeleportClass, Double.TYPE).get(0);
            EntityTeleport_Y = ReflectionUtils.getFields(EntityTeleportClass, Double.TYPE).get(1);
            EntityTeleport_Z = ReflectionUtils.getFields(EntityTeleportClass, Double.TYPE).get(2);
        } else {
            EntityTeleport_X = ReflectionUtils.getFields(EntityTeleportClass, Integer.TYPE).get(1);
            EntityTeleport_Y = ReflectionUtils.getFields(EntityTeleportClass, Integer.TYPE).get(2);
            EntityTeleport_Z = ReflectionUtils.getFields(EntityTeleportClass, Integer.TYPE).get(3);
        }
        newEntityTeleport = (entityId, location) -> {
            Object packet = newPacket.call();
            EntityTeleport_EntityId.set(packet, entityId);
            EntityTeleport_X.set(packet, PacketEntityView.toPosition(location.getX()));
            EntityTeleport_Y.set(packet, PacketEntityView.toPosition(location.getY()));
            EntityTeleport_Z.set(packet, PacketEntityView.toPosition(location.getZ()));
            return packet;
        };
    }

    private static void loadEntityMove() throws ReflectiveOperationException {
        PacketPlayOutEntity = BukkitReflection.getClass("network.protocol.game.ClientboundMoveEntityPacket", "network.protocol.game.PacketPlayOutEntity", "PacketPlayOutEntity", "Packet30Entity");
        PacketPlayOutEntityLook = BukkitReflection.getClass("network.protocol.game.ClientboundMoveEntityPacket$Rot", "network.protocol.game.PacketPlayOutEntity$PacketPlayOutEntityLook", "PacketPlayOutEntity$PacketPlayOutEntityLook", "PacketPlayOutEntityLook", "Packet32EntityLook");
        Class<?> packetPlayOutRelEntityMove = BukkitReflection.getClass("network.protocol.game.ClientboundMoveEntityPacket$Pos", "network.protocol.game.PacketPlayOutEntity$PacketPlayOutRelEntityMove", "PacketPlayOutEntity$PacketPlayOutRelEntityMove", "PacketPlayOutRelEntityMove", "Packet31RelEntityMove");
        PacketPlayOutEntity_ENTITYID = ReflectionUtils.getFields(PacketPlayOutEntity, Integer.TYPE).get(0);
        if (BukkitReflection.getMinorVersion() >= 14) {
            List<Field> fields = ReflectionUtils.getFields(PacketPlayOutEntity, Short.TYPE);
            PacketPlayOutEntity_X = fields.get(0);
            PacketPlayOutEntity_Y = fields.get(1);
            PacketPlayOutEntity_Z = fields.get(2);
            Constructor<?> constructor = packetPlayOutRelEntityMove.getConstructor(Integer.TYPE, Short.TYPE, Short.TYPE, Short.TYPE, Boolean.TYPE);
            newMovePacket = (entityId, x, y, z) -> constructor.newInstance(entityId, x.shortValue(), y.shortValue(), z.shortValue(), false);
        } else if (BukkitReflection.getMinorVersion() >= 9) {
            List<Field> fields = ReflectionUtils.getFields(PacketPlayOutEntity, Integer.TYPE);
            PacketPlayOutEntity_X = fields.get(1);
            PacketPlayOutEntity_Y = fields.get(2);
            PacketPlayOutEntity_Z = fields.get(3);
            Constructor<?> constructor = packetPlayOutRelEntityMove.getConstructor(Integer.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
            newMovePacket = (entityId, x, y, z) -> constructor.newInstance(entityId, x, y, z, false);
        } else if (BukkitReflection.getMinorVersion() == 8) {
            List<Field> fields = ReflectionUtils.getFields(PacketPlayOutEntity, Byte.TYPE);
            PacketPlayOutEntity_X = fields.get(0);
            PacketPlayOutEntity_Y = fields.get(1);
            PacketPlayOutEntity_Z = fields.get(2);
            Constructor<?> constructor = packetPlayOutRelEntityMove.getConstructor(Integer.TYPE, Byte.TYPE, Byte.TYPE, Byte.TYPE, Boolean.TYPE);
            newMovePacket = (entityId, x, y, z) -> constructor.newInstance(entityId, x.byteValue(), y.byteValue(), z.byteValue(), false);
        }
    }

    private static void loadEntitySpawn() throws ReflectiveOperationException {
        Field SpawnEntity_Z;
        Field SpawnEntity_Y;
        Field SpawnEntity_X;
        Field SpawnEntity_UUID;
        int minorVersion = BukkitReflection.getMinorVersion();
        EnumMap<EntityType, Integer> entityIds = new EnumMap<EntityType, Integer>(EntityType.class);
        if (minorVersion >= 13) {
            entityIds.put(EntityType.ARMOR_STAND, 1);
        } else {
            entityIds.put(EntityType.WITHER, 64);
            if (minorVersion >= 8) {
                entityIds.put(EntityType.ARMOR_STAND, 30);
            }
        }
        Class<?> SpawnEntityClass = BukkitReflection.getClass("network.protocol.game.ClientboundAddEntityPacket", "network.protocol.game.PacketPlayOutSpawnEntity", "PacketPlayOutSpawnEntityLiving", "Packet24MobSpawn");
        Field SpawnEntity_EntityId = ReflectionUtils.getFields(SpawnEntityClass, Integer.TYPE).get(0);
        if (BukkitReflection.is1_20_2Plus()) {
            PacketPlayOutNamedEntitySpawn = SpawnEntityClass;
            PacketPlayOutNamedEntitySpawn_ENTITYID = SpawnEntity_EntityId;
        } else {
            PacketPlayOutNamedEntitySpawn = BukkitReflection.getClass("network.protocol.game.ClientboundAddPlayerPacket", "network.protocol.game.PacketPlayOutNamedEntitySpawn", "PacketPlayOutNamedEntitySpawn", "Packet20NamedEntitySpawn");
            PacketPlayOutNamedEntitySpawn_ENTITYID = ReflectionUtils.getFields(PacketPlayOutNamedEntitySpawn, Integer.TYPE).get(0);
        }
        if (minorVersion >= 17) {
            Class<?> Vec3D = BukkitReflection.getClass("world.phys.Vec3", "world.phys.Vec3D");
            Object Vec3D_Empty = ReflectionUtils.getOnlyField(Vec3D, Vec3D).get(null);
            Class<?> EntityTypes = BukkitReflection.getClass("world.entity.EntityType", "world.entity.EntityTypes");
            if (minorVersion >= 19) {
                Object EntityTypes_ARMOR_STAND = ReflectionUtils.getField(EntityTypes, "ARMOR_STAND", "d").get(null);
                Constructor<?> constructor = SpawnEntityClass.getConstructor(Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, EntityTypes, Integer.TYPE, Vec3D, Double.TYPE);
                newSpawnEntity = (id, uuid, type, l, data) -> constructor.newInstance(id, uuid, l.getX(), l.getY(), l.getZ(), 0, 0, EntityTypes_ARMOR_STAND, 0, Vec3D_Empty, 0.0);
            } else {
                Object EntityTypes_ARMOR_STAND = ReflectionUtils.getField(EntityTypes, "ARMOR_STAND", "c", "f_20529_").get(null);
                Constructor<?> constructor = SpawnEntityClass.getConstructor(Integer.TYPE, UUID.class, Double.TYPE, Double.TYPE, Double.TYPE, Float.TYPE, Float.TYPE, EntityTypes, Integer.TYPE, Vec3D);
                newSpawnEntity = (id, uuid, type, l, data) -> constructor.newInstance(id, uuid, l.getX(), l.getY(), l.getZ(), 0, 0, EntityTypes_ARMOR_STAND, 0, Vec3D_Empty);
            }
            return;
        }
        Constructor<?> constructor = SpawnEntityClass.getConstructor(new Class[0]);
        Field SpawnEntity_EntityType = ReflectionUtils.getFields(SpawnEntityClass, Integer.TYPE).get(1);
        if (minorVersion >= 9) {
            SpawnEntity_UUID = ReflectionUtils.getOnlyField(SpawnEntityClass, UUID.class);
            SpawnEntity_X = ReflectionUtils.getFields(SpawnEntityClass, Double.TYPE).get(0);
            SpawnEntity_Y = ReflectionUtils.getFields(SpawnEntityClass, Double.TYPE).get(1);
            SpawnEntity_Z = ReflectionUtils.getFields(SpawnEntityClass, Double.TYPE).get(2);
        } else {
            SpawnEntity_UUID = null;
            SpawnEntity_X = ReflectionUtils.getFields(SpawnEntityClass, Integer.TYPE).get(2);
            SpawnEntity_Y = ReflectionUtils.getFields(SpawnEntityClass, Integer.TYPE).get(3);
            SpawnEntity_Z = ReflectionUtils.getFields(SpawnEntityClass, Integer.TYPE).get(4);
        }
        Field SpawnEntity_DataWatcher = minorVersion < 15 ? ReflectionUtils.getOnlyField(SpawnEntityClass, DataWatcher.DataWatcher) : null;
        newSpawnEntity = (id, uuid, type, l, data) -> {
            Object nmsPacket = constructor.newInstance(new Object[0]);
            SpawnEntity_EntityId.set(nmsPacket, id);
            if (minorVersion < 15) {
                SpawnEntity_DataWatcher.set(nmsPacket, data.build());
            }
            if (minorVersion >= 9) {
                SpawnEntity_UUID.set(nmsPacket, uuid);
            }
            SpawnEntity_X.set(nmsPacket, PacketEntityView.toPosition(l.getX()));
            SpawnEntity_Y.set(nmsPacket, PacketEntityView.toPosition(l.getY()));
            SpawnEntity_Z.set(nmsPacket, PacketEntityView.toPosition(l.getZ()));
            SpawnEntity_EntityType.set(nmsPacket, entityIds.get((EntityType)type));
            return nmsPacket;
        };
    }

    private static Object toPosition(double paramDouble) {
        if (BukkitReflection.getMinorVersion() >= 9) {
            return paramDouble;
        }
        int i = (int)(paramDouble * 32.0);
        return paramDouble < (double)i ? i - 1 : i;
    }

    @Override
    public void spawnEntity(int entityId, @NotNull UUID id, @NotNull Object entityType, @NotNull Location l, @NotNull EntityData data) {
        if (BukkitReflection.getMinorVersion() >= 15) {
            sendAsBundle.accept(this.player, Arrays.asList(newSpawnEntity.apply(entityId, id, entityType, l, null), newEntityMetadata.apply(entityId, data)));
        } else {
            packetSender.sendPacket(this.player.getPlayer(), newSpawnEntity.apply(entityId, id, entityType, l, data));
        }
    }

    @Override
    public void updateEntityMetadata(int entityId, @NotNull EntityData data) {
        packetSender.sendPacket(this.player.getPlayer(), newEntityMetadata.apply(entityId, data));
    }

    @Override
    public void teleportEntity(int entityId, @NotNull Location location) {
        packetSender.sendPacket(this.player.getPlayer(), newEntityTeleport.apply(entityId, location));
    }

    @Override
    public void destroyEntities(int ... entities) {
        destroyEntities.accept(this.player, entities);
    }

    @Override
    public boolean isDestroyPacket(@NotNull Object packet) {
        return EntityDestroyClass.isInstance(packet);
    }

    @Override
    public boolean isTeleportPacket(@NotNull Object packet) {
        return EntityTeleportClass.isInstance(packet);
    }

    @Override
    public boolean isNamedEntitySpawnPacket(@NotNull Object packet) {
        return PacketPlayOutNamedEntitySpawn.isInstance(packet);
    }

    @Override
    public boolean isMovePacket(@NotNull Object packet) {
        return PacketPlayOutEntity.isInstance(packet);
    }

    @Override
    public boolean isLookPacket(@NotNull Object packet) {
        return PacketPlayOutEntityLook.isInstance(packet);
    }

    @Override
    public int getTeleportEntityId(@NotNull Object teleportPacket) {
        return EntityTeleport_EntityId.getInt(teleportPacket);
    }

    @Override
    public int getMoveEntityId(@NotNull Object movePacket) {
        return PacketPlayOutEntity_ENTITYID.getInt(movePacket);
    }

    @Override
    public int getSpawnedPlayer(@NotNull Object playerSpawnPacket) {
        return PacketPlayOutNamedEntitySpawn_ENTITYID.getInt(playerSpawnPacket);
    }

    @Override
    public int[] getDestroyedEntities(@NotNull Object destroyPacket) {
        return getDestroyedEntities.apply(destroyPacket);
    }

    @Override
    public boolean isBundlePacket(@NotNull Object packet) {
        return isBundlePacket.apply(packet);
    }

    @Override
    public Iterable<Object> getPackets(@NotNull Object bundlePacket) {
        return (Iterable)ClientboundBundlePacket_packets.get(bundlePacket);
    }

    @Override
    @NotNull
    public Location getMoveDiff(@NotNull Object movePacket) {
        return new Location(((Number)PacketPlayOutEntity_X.get(movePacket)).intValue(), ((Number)PacketPlayOutEntity_Y.get(movePacket)).intValue(), ((Number)PacketPlayOutEntity_Z.get(movePacket)).intValue());
    }

    @Override
    public void moveEntity(int entityId, @NotNull Location moveDiff) {
        packetSender.sendPacket(this.player.getPlayer(), newMovePacket.apply(entityId, (long)moveDiff.getX(), (long)moveDiff.getY(), (long)moveDiff.getZ()));
    }

    public PacketEntityView(BukkitTabPlayer player) {
        this.player = player;
    }

    public static boolean isAvailable() {
        return available;
    }

    static {
        isBundlePacket = packet -> false;
        sendAsBundle = (player, packets) -> {
            for (Object packet : packets) {
                packetSender.sendPacket(player.getPlayer(), packet);
            }
        };
    }
}

