/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.platforms.sponge8;

import java.util.Collections;
import java.util.List;
import me.neznamy.tab.platforms.sponge8.SpongePlatform;
import me.neznamy.tab.platforms.sponge8.SpongeScoreboard;
import me.neznamy.tab.platforms.sponge8.SpongeTabList;
import me.neznamy.tab.shared.backend.BackendTabPlayer;
import me.neznamy.tab.shared.backend.entityview.DummyEntityView;
import me.neznamy.tab.shared.backend.entityview.EntityView;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.platform.BossBar;
import me.neznamy.tab.shared.platform.TabList;
import me.neznamy.tab.shared.platform.impl.AdventureBossBar;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.data.Keys;
import org.spongepowered.api.effect.VanishState;
import org.spongepowered.api.effect.potion.PotionEffect;
import org.spongepowered.api.effect.potion.PotionEffectTypes;
import org.spongepowered.api.entity.living.player.gamemode.GameModes;
import org.spongepowered.api.entity.living.player.server.ServerPlayer;
import org.spongepowered.api.profile.property.ProfileProperty;

public class SpongeTabPlayer
extends BackendTabPlayer {
    @NotNull
    private final SpongeScoreboard scoreboard = new SpongeScoreboard(this);
    @NotNull
    private final SpongeTabList tabList = new SpongeTabList(this);
    @NotNull
    private final BossBar bossBar = new AdventureBossBar(this);
    @NotNull
    private final EntityView entityView = new DummyEntityView();

    public SpongeTabPlayer(@NotNull SpongePlatform platform, @NotNull ServerPlayer player) {
        super(platform, player, player.uniqueId(), player.name(), player.world().key().value(), platform.getServerVersion().getNetworkId());
    }

    @Override
    public boolean hasPermission(@NotNull String permission) {
        return this.getPlayer().hasPermission(permission);
    }

    @Override
    public int getPing() {
        return this.getPlayer().connection().latency();
    }

    @Override
    public void sendMessage(@NotNull TabComponent message) {
        this.getPlayer().sendMessage((Component)message.convert(this.getVersion()));
    }

    @Override
    public boolean hasInvisibilityPotion() {
        for (PotionEffect effect : this.getPlayer().get(Keys.POTION_EFFECTS).orElse(Collections.emptyList())) {
            if (effect.type() != PotionEffectTypes.INVISIBILITY.get()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDisguised() {
        return false;
    }

    @Override
    @Nullable
    public TabList.Skin getSkin() {
        List list = this.getPlayer().profile().properties();
        if (list.isEmpty()) {
            return null;
        }
        return new TabList.Skin(((ProfileProperty)list.get(0)).value(), ((ProfileProperty)list.get(0)).signature().orElse(null));
    }

    @NotNull
    public ServerPlayer getPlayer() {
        return (ServerPlayer)this.player;
    }

    @Override
    public SpongePlatform getPlatform() {
        return (SpongePlatform)this.platform;
    }

    @Override
    public boolean isVanished() {
        return ((VanishState)this.getPlayer().vanishState().get()).invisible();
    }

    @Override
    public int getGamemode() {
        if (this.getPlayer().gameMode().get() == GameModes.CREATIVE.get()) {
            return 1;
        }
        if (this.getPlayer().gameMode().get() == GameModes.ADVENTURE.get()) {
            return 2;
        }
        if (this.getPlayer().gameMode().get() == GameModes.SPECTATOR.get()) {
            return 3;
        }
        return 0;
    }

    @Override
    public double getHealth() {
        return (Double)this.getPlayer().health().get();
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return PlainTextComponentSerializer.plainText().serialize((Component)this.getPlayer().displayName().get());
    }

    @NotNull
    public SpongeScoreboard getScoreboard() {
        return this.scoreboard;
    }

    @NotNull
    public SpongeTabList getTabList() {
        return this.tabList;
    }

    @Override
    @NotNull
    public BossBar getBossBar() {
        return this.bossBar;
    }

    @Override
    @NotNull
    public EntityView getEntityView() {
        return this.entityView;
    }
}

