/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.command;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.command.CpuCommand;
import me.neznamy.tab.shared.command.DebugCommand;
import me.neznamy.tab.shared.command.GroupCommand;
import me.neznamy.tab.shared.command.GroupsCommand;
import me.neznamy.tab.shared.command.MySQLCommand;
import me.neznamy.tab.shared.command.NameTagCommand;
import me.neznamy.tab.shared.command.ParseCommand;
import me.neznamy.tab.shared.command.PlayerCommand;
import me.neznamy.tab.shared.command.PlayerUUIDCommand;
import me.neznamy.tab.shared.command.ReloadCommand;
import me.neznamy.tab.shared.command.SetCollisionCommand;
import me.neznamy.tab.shared.command.SubCommand;
import me.neznamy.tab.shared.command.bossbar.BossBarCommand;
import me.neznamy.tab.shared.command.scoreboard.ScoreboardCommand;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TabCommand
extends SubCommand {
    public TabCommand() {
        super(null, null);
        this.registerSubCommand(new BossBarCommand());
        this.registerSubCommand(new CpuCommand());
        this.registerSubCommand(new DebugCommand());
        this.registerSubCommand(new GroupCommand());
        this.registerSubCommand(new GroupsCommand());
        this.registerSubCommand(new MySQLCommand());
        this.registerSubCommand(new NameTagCommand());
        this.registerSubCommand(new ParseCommand());
        this.registerSubCommand(new PlayerCommand());
        this.registerSubCommand(new PlayerUUIDCommand());
        this.registerSubCommand(new ReloadCommand());
        this.registerSubCommand(new SetCollisionCommand());
        this.registerSubCommand(new ScoreboardCommand());
        ArrayList properties = Lists.newArrayList((Object[])new String[]{"tabprefix", "tabsuffix", "tagprefix", "tagsuffix", "customtabname", "abovename", "belowname", "customtagname"});
        properties.addAll(((DebugCommand)this.getSubcommands().get("debug")).getExtraLines());
        SubCommand.setAllProperties(properties);
    }

    @Override
    public void execute(@Nullable TabPlayer sender, @NotNull String[] args) {
        if (args.length > 0) {
            String arg0 = args[0];
            SubCommand command = this.getSubcommands().get(arg0.toLowerCase());
            if (command != null) {
                if (command.hasPermission(sender)) {
                    command.execute(sender, Arrays.copyOfRange(args, 1, args.length));
                } else {
                    this.sendMessage(sender, this.getMessages().getNoPermission());
                }
            } else {
                this.help(sender);
            }
        } else {
            this.help(sender);
        }
    }

    private void help(@Nullable TabPlayer sender) {
        if (this.hasPermission(sender, "tab.admin")) {
            this.sendMessage(sender, "&3TAB v4.1.7");
            for (String message : this.getMessages().getHelpMenu()) {
                if (TAB.getInstance().getPlatform().isProxy()) {
                    message = message.replace("/tab", "/btab");
                }
                this.sendMessage(sender, message);
            }
        }
    }

    @Override
    @NotNull
    public List<String> complete(@Nullable TabPlayer sender, @NotNull String[] arguments) {
        if (!this.hasPermission(sender, "tab.tabcomplete")) {
            return Collections.emptyList();
        }
        return super.complete(sender, arguments);
    }
}

