/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import me.neznamy.tab.libs.me.neznamy.yamlassist.YamlAssist;
import me.neznamy.tab.libs.org.yaml.snakeyaml.DumperOptions;
import me.neznamy.tab.libs.org.yaml.snakeyaml.Yaml;
import me.neznamy.tab.libs.org.yaml.snakeyaml.error.YAMLException;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.EnumChatFormat;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.config.file.ConfigurationFile;
import org.jetbrains.annotations.Nullable;

public class YamlConfigurationFile
extends ConfigurationFile {
    public YamlConfigurationFile(@Nullable InputStream source, @NonNull File destination) throws IOException {
        super(source, destination);
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(this.file);
            this.values = (Map)new Yaml().load(input);
            if (this.values == null) {
                this.values = new LinkedHashMap();
            }
            input.close();
        }
        catch (YAMLException e) {
            if (input != null) {
                input.close();
            }
            TAB tab = TAB.getInstance();
            tab.setBrokenFile(destination.getName());
            tab.getPlatform().logWarn(TabComponent.fromColoredText("File " + destination + " has broken syntax."));
            tab.getPlatform().logInfo(TabComponent.fromColoredText((Object)((Object)EnumChatFormat.GOLD) + "Error message from yaml parser: " + e.getMessage()));
            List<String> suggestions = YamlAssist.getSuggestions(this.file);
            if (!suggestions.isEmpty()) {
                tab.getPlatform().logInfo(TabComponent.fromColoredText((Object)((Object)EnumChatFormat.LIGHT_PURPLE) + "Suggestions to fix yaml syntax:"));
                for (String suggestion : suggestions) {
                    tab.getPlatform().logInfo(TabComponent.fromColoredText((Object)((Object)EnumChatFormat.LIGHT_PURPLE) + "- " + suggestion));
                }
            }
            throw e;
        }
    }

    @Override
    public void save() {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);
            DumperOptions options = new DumperOptions();
            options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
            new Yaml(options).dump(this.values, writer);
            ((Writer)writer).close();
            this.fixHeader();
        }
        catch (IOException e) {
            TAB.getInstance().getPlatform().logWarn(TabComponent.fromColoredText("Failed to save yaml file " + this.file.getPath() + " with content " + this.values.toString()));
        }
    }
}

