/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.config.helper;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.layout.GroupPattern;
import me.neznamy.tab.shared.features.layout.LayoutManagerImpl;
import me.neznamy.tab.shared.features.sorting.types.SortingType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StartupWarnPrinter {
    private int warnCount;

    public void fixRefreshIntervals(@NotNull Map<String, Integer> refreshIntervals) {
        int defaultRefresh = refreshIntervals.getOrDefault("default-refresh-interval", 500);
        LinkedHashMap<String, Integer> valuesToFix = new LinkedHashMap<String, Integer>();
        for (Map.Entry<String, Integer> entry : refreshIntervals.entrySet()) {
            if (entry.getValue() == null) {
                this.startupWarn("Refresh interval of " + entry.getKey() + " is set to null. Define a valid value or remove it if you don't want to override default value.");
                valuesToFix.put(entry.getKey(), 50);
                continue;
            }
            if (!(entry.getValue() instanceof Integer)) {
                this.startupWarn("Refresh interval configured for \"" + entry.getKey() + "\" is not a valid number.");
                valuesToFix.put(entry.getKey(), 500);
                continue;
            }
            int interval = entry.getValue();
            if (!entry.getKey().equals("default-refresh-interval") && interval == defaultRefresh) {
                TAB.getInstance().getConfigHelper().hint().redundantRefreshInterval(entry.getKey());
            }
            if (interval == -1) continue;
            if (interval <= 0) {
                this.startupWarn("Invalid refresh interval configured for " + entry.getKey() + " (" + interval + "). Value cannot be zero or negative (except -1).");
            } else {
                if (interval % 50 == 0) continue;
                this.startupWarn("Invalid refresh interval configured for " + entry.getKey() + " (" + interval + "). Value must be divisible by " + 50 + ".");
            }
            valuesToFix.put(entry.getKey(), 50);
        }
        refreshIntervals.putAll(valuesToFix);
    }

    public int fixAnimationInterval(@NotNull String name, int interval) {
        if (interval == 0) {
            this.startupWarn(String.format("Animation \"%s\" has refresh interval of 0 milliseconds! Did you forget to configure it? Using 1000.", name));
            return 1000;
        }
        if (interval < 0) {
            this.startupWarn(String.format("Animation \"%s\" has refresh interval of %s. Refresh cannot be negative! Using 1000.", name, interval));
            return 1000;
        }
        if (interval % 50 != 0) {
            int min = 50;
            int newInterval = Math.round((float)interval / (float)min) * min;
            if (newInterval == 0) {
                newInterval = min;
            }
            this.startupWarn(String.format("Animation \"%s\" has refresh interval of %s, which is not divisible by %s! Using %s.", name, interval, min, newInterval));
            return newInterval;
        }
        return interval;
    }

    public List<String> fixAnimationFrames(@NotNull String name, @Nullable List<String> list) {
        if (list == null) {
            this.startupWarn("Animation \"" + name + "\" does not have any texts defined!");
            return Collections.singletonList("<Animation does not have any texts>");
        }
        return list;
    }

    public void checkBelowNameText(@NotNull String text) {
        if (!text.contains("%")) {
            return;
        }
        if (text.contains("%animation") || text.contains("%condition")) {
            return;
        }
        this.startupWarn("Belowname text is set to " + text + ", however, the feature cannot display different text on different players due to a minecraft limitation. Placeholders will be parsed for viewing player.");
    }

    public void invalidLayoutSkinDefinition(@NotNull String definition) {
        this.startupWarn("Invalid skin definition: \"" + definition + "\". Supported patterns are:", "#1 - \"player:<name>\" for skin of player with specified name", "#2 - \"mineskin:<id>\" for UUID of chosen skin from mineskin.org", "#3 - \"texture:<texture>\" for raw texture string");
    }

    public void invalidFixedSlotDefinition(@NotNull String layout, @NotNull String line) {
        this.startupWarn("Layout " + layout + " has invalid fixed slot defined as \"" + line + "\". Supported values are \"SLOT|TEXT\" and \"SLOT|TEXT|SKIN\", where SLOT is a number from 1 to 80, TEXT is displayed text and SKIN is skin used for the slot");
    }

    public void invalidLayoutDirection(@NotNull String direction) {
        this.startupWarn("\"" + direction + "\" is not a valid type of layout direction. Valid options are: " + Arrays.deepToString((Object[])LayoutManagerImpl.Direction.values()) + ". Using COLUMNS");
    }

    public void invalidSortingTypeElement(@NotNull String element, @NotNull Set<String> validTypes) {
        this.startupWarn("\"" + element + "\" is not a valid sorting type element. Valid options are: " + validTypes + ".");
    }

    public void invalidSortingPlaceholder(@NotNull String placeholder, @NotNull SortingType type) {
        this.startupWarn("\"" + placeholder + "\" is not a valid placeholder for " + type.getClass().getSimpleName() + " sorting type");
    }

    public void conditionHasNoConditions(@NotNull String conditionName) {
        this.startupWarn("Condition \"" + conditionName + "\" is missing \"conditions\" section.");
    }

    public void conditionMissingType(@NotNull String conditionName) {
        this.startupWarn(String.format("Condition \"%s\" has multiple conditions defined, but is missing \"type\" attribute. Using AND.", conditionName));
    }

    public void invalidConditionPattern(@NotNull String conditionName, @NotNull String line) {
        this.startupWarn("Line \"" + line + "\" in condition " + conditionName + " is not a valid condition pattern.");
    }

    public void invisibleAndUnlimitedNameTagsAreMutuallyExclusive() {
        this.startupWarn("Unlimited name tag mode is enabled as well as invisible name tags. These 2 options are mutually exclusive.", "If you want name tags to be invisible, you don't need unlimited name tag mode at all.", "If you want enhanced name tags without limits, making them invisible would defeat the purpose.");
    }

    public void invalidDateFormat(@NotNull String format) {
        this.startupWarn("Format \"" + format + "\" is not a valid date/time format. Did you try to use color codes?");
    }

    public void bothGlobalPlayerListAndLayoutEnabled() {
        this.startupWarn("Both global playerlist and layout features are enabled, but layout makes global playerlist redundant.", "Layout automatically works with all connected players on the proxy and replaces real player entries with fake players, making global playerlist completely useless.", "Disable global playerlist for the same result, but with better performance.");
    }

    public void bothPerWorldPlayerListAndLayoutEnabled() {
        this.startupWarn("Both per world playerlist and layout features are enabled, but layout makes per world playerlist redundant.", "Layout automatically works with all connected players and replaces real player entries with fake players, making per world playerlist completely useless as real players are pushed out of the playerlist.", "Disable per world playerlist for the same result, but with better performance.");
    }

    public void checkLayoutMap(@NotNull String layoutName, @NotNull Map<String, Object> map) {
        List<String> expectedKeys = Arrays.asList("condition", "fixed-slots", "groups");
        for (String mapKey : map.keySet()) {
            if (expectedKeys.contains(mapKey)) continue;
            this.startupWarn("Unknown property \"" + mapKey + "\" in layout \"" + layoutName + "\". Valid properties: " + expectedKeys);
        }
    }

    public void checkLayoutGroupMap(@NotNull String layoutName, @NotNull String groupName, @NotNull Map<String, Object> map) {
        List<String> expectedKeys = Arrays.asList("condition", "slots");
        for (String mapKey : map.keySet()) {
            if (expectedKeys.contains(mapKey)) continue;
            this.startupWarn("Unknown property \"" + mapKey + "\" in layout \"" + layoutName + "\"'s group \"" + groupName + "\". Valid properties: " + expectedKeys);
        }
    }

    @NotNull
    public <T> T fromMapOrElse(@NotNull Map<String, Object> map, @NotNull String key, @NotNull T defaultValue, @NotNull String warnMessage) {
        if (map.containsKey(key)) {
            return (T)map.get(key);
        }
        this.startupWarn(warnMessage);
        return defaultValue;
    }

    public void checkBossBarProperties(Map<String, Object> bossbarSection, String name) {
        List<String> validProperties = Arrays.asList("style", "color", "progress", "text", "announcement-bar", "display-condition");
        for (String mapKey : bossbarSection.keySet()) {
            if (validProperties.contains(mapKey)) continue;
            this.startupWarn("Unknown property \"" + mapKey + "\" in bossbar \"" + name + "\". Valid properties: " + validProperties);
        }
        if (!bossbarSection.containsKey("text")) {
            this.startupWarn("Bossbar \"" + name + "\" is missing \"text\" property.");
            bossbarSection.put("text", "Text is not defined!");
        }
        if (bossbarSection.containsKey("color")) {
            String color = bossbarSection.get("color").toString();
            if (!color.contains("%")) {
                try {
                    BarColor.valueOf(color.toUpperCase(Locale.US));
                }
                catch (IllegalArgumentException e) {
                    this.startupWarn("Bossbar \"" + name + " has color set to \"" + color + "\", which is not one of the supported colors " + Arrays.toString((Object[])BarColor.values()) + " or a placeholder evaluating to one.");
                    bossbarSection.put("color", "PURPLE");
                }
            }
        } else {
            this.startupWarn("Bossbar \"" + name + "\" is missing \"color\" property.");
            bossbarSection.put("color", "PURPLE");
        }
        if (bossbarSection.containsKey("style")) {
            String style = bossbarSection.get("style").toString();
            if (!style.contains("%")) {
                try {
                    BarStyle.valueOf(style.toUpperCase(Locale.US));
                }
                catch (IllegalArgumentException e) {
                    this.startupWarn("Bossbar \"" + name + " has style set to \"" + style + "\", which is not one of the supported styles " + Arrays.toString((Object[])BarStyle.values()) + " or a placeholder evaluating to one.");
                    bossbarSection.put("style", "PROGRESS");
                }
            }
        } else {
            this.startupWarn("Bossbar \"" + name + "\" is missing \"style\" property.");
            bossbarSection.put("style", "PROGRESS");
        }
        if (bossbarSection.containsKey("progress")) {
            String progress = bossbarSection.get("progress").toString();
            if (!progress.contains("%")) {
                try {
                    Float.parseFloat(progress);
                }
                catch (IllegalArgumentException e) {
                    this.startupWarn("Bossbar \"" + name + " has progress set to \"" + progress + "\", which is not a valid number between 0 and 100 or a placeholder evaluating to one.");
                    bossbarSection.put("progress", "100");
                }
            }
        } else {
            this.startupWarn("Bossbar \"" + name + "\" is missing \"progress\" property.");
            bossbarSection.put("progress", "100");
        }
    }

    public void teamAntiOverrideDisabled() {
        this.startupWarn("anti-override for scoreboard-teams is disabled in config. This is usually a mistake. If you notice the feature randomly breaking, enable it back.");
    }

    public void tablistAntiOverrideDisabled() {
        this.startupWarn("anti-override for tablist-name-formatting is disabled in config. This is usually a mistake. If you notice the feature randomly breaking, enable it back.");
    }

    public void nonLastNoConditionScoreboard(@NotNull String noConditionScoreboard, @NotNull String nextScoreboard) {
        this.startupWarn("Scoreboard \"" + noConditionScoreboard + "\" has no display condition set, however, there is another scoreboard in the chain (" + nextScoreboard + "). Scoreboards are checked from top to bottom until a scoreboard with meeting condition or no condition is found. Because of this, the scoreboard (" + nextScoreboard + ") after the no-condition scoreboard (" + noConditionScoreboard + ") will never be displayed. Unless this is intentional to externally display the scoreboard (commands, API), this is a mistake.");
    }

    public void layoutBreaksYellowNumber() {
        this.startupWarn("Layout feature breaks playerlist-objective feature, because it replaces real player with fake slots with different usernames for more reliable functionality. Disable playerlist-objective feature, as it will only look bad and consume resources.");
    }

    public void invalidScoreboardSection(@NotNull String name) {
        this.startupWarn("Invalid scoreboard section \"" + name + "\" with no value.");
    }

    public void checkLayoutGroups(@NotNull String layoutName, @NotNull List<GroupPattern> groups) {
        HashMap<Integer, String> takenSlots = new HashMap<Integer, String>();
        for (GroupPattern pattern : groups) {
            for (int slot : pattern.getSlots()) {
                if (takenSlots.containsKey(slot)) {
                    this.startupWarn("Layout \"" + layoutName + "\"'s player group \"" + pattern.getName() + "\" defines slot " + slot + ", but this slot is already taken by group \"" + (String)takenSlots.get(slot) + "\", which will take priority.");
                    continue;
                }
                takenSlots.put(slot, pattern.getName());
            }
        }
        String noConditionGroup = null;
        for (GroupPattern pattern : groups) {
            if (noConditionGroup != null) {
                this.startupWarn("Layout \"" + layoutName + "\"'s player group \"" + pattern.getName() + "\" is unreachable, because it is defined after group \"" + noConditionGroup + "\", which has no condition requirement.");
                continue;
            }
            if (pattern.getCondition() != null) continue;
            noConditionGroup = pattern.getName();
        }
    }

    public void checkErrorLog() {
        File errorLog = TAB.getInstance().getErrorManager().getErrorLog();
        if (errorLog.length() > 1000000L) {
            this.startupWarn("File " + errorLog.getPath() + " has reached its size limit (1MB). No new errors will be logged. Take a look at the existing reported errors, as they may have caused the plugin to not work properly in the past and if not fixed, will most likely cause problems in the future as well.");
        }
    }

    public void incompleteSortingLine(@NotNull String configuredLine) {
        this.startupWarn("Sorting line \"" + configuredLine + "\" is incomplete.");
    }

    private void startupWarn(String ... messages) {
        ++this.warnCount;
        for (String message : messages) {
            TAB.getInstance().getPlatform().logWarn(TabComponent.fromColoredText(message));
        }
    }

    public void printWarnCount() {
        if (this.warnCount == 0) {
            return;
        }
        TAB.getInstance().getPlatform().logWarn(TabComponent.fromColoredText("Found a total of " + this.warnCount + " issues."));
        this.warnCount = 0;
    }
}

