/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features;

import java.util.ArrayList;
import java.util.List;
import me.neznamy.tab.api.tablist.HeaderFooterManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.types.DisableChecker;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.features.types.ServerSwitchListener;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.features.types.WorldSwitchListener;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeaderFooter
extends TabFeature
implements HeaderFooterManager,
JoinListener,
Loadable,
UnLoadable,
WorldSwitchListener,
ServerSwitchListener,
Refreshable {
    private final List<Object> worldGroups = new ArrayList(this.config().getConfigurationSection("header-footer.per-world").keySet());
    private final List<Object> serverGroups = new ArrayList(this.config().getConfigurationSection("header-footer.per-server").keySet());
    private final DisableChecker disableChecker;

    public HeaderFooter() {
        Condition disableCondition = Condition.getCondition(this.config().getString("header-footer.disable-condition"));
        this.disableChecker = new DisableChecker(this.getFeatureName(), disableCondition, this::onDisableConditionChange, p -> p.disabledHeaderFooter);
        TAB.getInstance().getFeatureManager().registerFeature("HeaderFooter-Condition", this.disableChecker);
        TAB.getInstance().getConfigHelper().hint().checkHeaderFooterForRedundancy(this.config().getConfigurationSection("header-footer"));
    }

    @Override
    public void load() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            if (p.disabledHeaderFooter.get()) continue;
            this.sendHeaderFooter(p, "", "");
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        if (this.disableChecker.isDisableConditionMet(connectedPlayer)) {
            connectedPlayer.disabledHeaderFooter.set(true);
        }
        this.refresh(connectedPlayer, true);
    }

    @Override
    public void onServerChange(@NotNull TabPlayer p, @NotNull String from, @NotNull String to) {
        this.refresh(p, true);
    }

    @Override
    public void onWorldChange(@NotNull TabPlayer p, @NotNull String from, @NotNull String to) {
        this.updateProperties(p);
    }

    private void updateProperties(TabPlayer p) {
        boolean refresh = p.setProperty(this, "header", this.getProperty(p, "header"));
        if (p.setProperty(this, "footer", this.getProperty(p, "footer"))) {
            refresh = true;
        }
        if (refresh) {
            this.sendHeaderFooter(p, p.getProperty("header").get(), p.getProperty("footer").get());
        }
    }

    @Override
    public void refresh(@NotNull TabPlayer p, boolean force) {
        if (force) {
            p.setProperty(this, "header", this.getProperty(p, "header"));
            p.setProperty(this, "footer", this.getProperty(p, "footer"));
        }
        this.sendHeaderFooter(p, p.getProperty("header").updateAndGet(), p.getProperty("footer").updateAndGet());
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating header/footer";
    }

    public void onDisableConditionChange(TabPlayer p, boolean disabledNow) {
        if (disabledNow) {
            p.getTabList().setPlayerListHeaderFooter(new SimpleComponent(""), new SimpleComponent(""));
        } else {
            this.sendHeaderFooter(p, p.getProperty("header").get(), p.getProperty("footer").get());
        }
    }

    private String getProperty(TabPlayer p, String property) {
        String append = this.getFromConfig(p, property + "append");
        if (!append.isEmpty()) {
            append = "\n" + append;
        }
        return this.getFromConfig(p, property) + append;
    }

    private String getFromConfig(TabPlayer p, String property) {
        String[] value = TAB.getInstance().getConfiguration().getUsers().getProperty(p.getName(), property, p.getServer(), p.getWorld());
        if (value.length > 0) {
            return value[0];
        }
        value = TAB.getInstance().getConfiguration().getUsers().getProperty(p.getUniqueId().toString(), property, p.getServer(), p.getWorld());
        if (value.length > 0) {
            return value[0];
        }
        value = TAB.getInstance().getConfiguration().getGroups().getProperty(p.getGroup(), property, p.getServer(), p.getWorld());
        if (value.length > 0) {
            return value[0];
        }
        List<String> lines = this.config().getStringList("header-footer.per-world." + TAB.getInstance().getConfiguration().getGroup(this.worldGroups, p.getWorld()) + "." + property);
        if (lines == null) {
            lines = this.config().getStringList("header-footer.per-server." + TAB.getInstance().getConfiguration().getServerGroup(this.serverGroups, p.getServer()) + "." + property);
        }
        if (lines == null) {
            lines = this.config().getStringList("header-footer." + property);
        }
        if (lines == null) {
            lines = new ArrayList<String>();
        }
        return String.join((CharSequence)"\n", lines);
    }

    private void sendHeaderFooter(TabPlayer player, String header, String footer) {
        if (player.disabledHeaderFooter.get()) {
            return;
        }
        player.getTabList().setPlayerListHeaderFooter(TabComponent.optimized(header), TabComponent.optimized(footer));
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "Header/Footer";
    }

    @Override
    public void setHeader(@NotNull me.neznamy.tab.api.TabPlayer p, @Nullable String header) {
        this.ensureActive();
        TabPlayer player = (TabPlayer)p;
        player.ensureLoaded();
        player.getProperty("header").setTemporaryValue(header);
        this.sendHeaderFooter(player, player.getProperty("header").updateAndGet(), player.getProperty("footer").updateAndGet());
    }

    @Override
    public void setFooter(@NotNull me.neznamy.tab.api.TabPlayer p, @Nullable String footer) {
        this.ensureActive();
        TabPlayer player = (TabPlayer)p;
        player.ensureLoaded();
        player.getProperty("footer").setTemporaryValue(footer);
        this.sendHeaderFooter(player, player.getProperty("header").updateAndGet(), player.getProperty("footer").updateAndGet());
    }

    @Override
    public void setHeaderAndFooter(@NotNull me.neznamy.tab.api.TabPlayer p, @Nullable String header, @Nullable String footer) {
        this.ensureActive();
        TabPlayer player = (TabPlayer)p;
        player.ensureLoaded();
        player.getProperty("header").setTemporaryValue(header);
        player.getProperty("footer").setTemporaryValue(footer);
        this.sendHeaderFooter(player, player.getProperty("header").updateAndGet(), player.getProperty("footer").updateAndGet());
    }
}

