/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.bossbar;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lombok.NonNull;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.api.bossbar.BossBar;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.features.bossbar.BossBarManagerImpl;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BossBarLine
implements BossBar {
    private final String name;
    private final Condition displayCondition;
    private final UUID uniqueId = UUID.randomUUID();
    private String style;
    private String color;
    private String title;
    private String progress;
    private final boolean announcementBar;
    private final Set<TabPlayer> players = new HashSet<TabPlayer>();
    private final TextRefresher textRefresher;
    private final ProgressRefresher progressRefresher;
    private final ColorRefresher colorRefresher;
    private final StyleRefresher styleRefresher;
    private final String propertyTitle = Property.randomName();
    private final String propertyProgress = Property.randomName();
    private final String propertyColor = Property.randomName();
    private final String propertyStyle = Property.randomName();

    public BossBarLine(@NonNull BossBarManagerImpl manager, @NonNull String name, @Nullable String displayCondition, @NonNull String color, @NonNull String style, @NonNull String title, @NonNull String progress, boolean announcementOnly) {
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (progress == null) {
            throw new NullPointerException("progress is marked non-null but is null");
        }
        this.name = name;
        this.displayCondition = Condition.getCondition(displayCondition);
        if (this.displayCondition != null) {
            manager.addUsedPlaceholder(TabConstants.Placeholder.condition(this.displayCondition.getName()));
        }
        this.color = color;
        this.style = style;
        this.title = title;
        this.progress = progress;
        this.announcementBar = announcementOnly;
        this.textRefresher = new TextRefresher();
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarTitle(name), this.textRefresher);
        this.progressRefresher = new ProgressRefresher();
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarProgress(name), this.progressRefresher);
        this.colorRefresher = new ColorRefresher();
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarColor(name), this.colorRefresher);
        this.styleRefresher = new StyleRefresher();
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.bossBarStyle(name), this.styleRefresher);
    }

    public boolean isConditionMet(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (this.displayCondition == null) {
            return true;
        }
        return this.displayCondition.isMet(p);
    }

    @NotNull
    public BarColor parseColor(@NonNull String color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        try {
            return BarColor.valueOf(color);
        }
        catch (IllegalArgumentException e) {
            return BarColor.PURPLE;
        }
    }

    @NotNull
    public BarStyle parseStyle(@NonNull String style) {
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        try {
            return BarStyle.valueOf(style);
        }
        catch (IllegalArgumentException e) {
            return BarStyle.PROGRESS;
        }
    }

    public float parseProgress(@NotNull TabPlayer player, @NotNull String progress) {
        try {
            float value = Float.parseFloat(progress);
            if (value < 0.0f) {
                value = 0.0f;
            }
            if (value > 100.0f) {
                value = 100.0f;
            }
            return value;
        }
        catch (NumberFormatException e) {
            TAB.getInstance().getConfigHelper().runtime().invalidNumberForBossBarProgress(this, progress, player.getProperty(this.propertyProgress).getCurrentRawValue(), player);
            return 100.0f;
        }
    }

    public void sendToPlayerRaw(@NotNull TabPlayer player) {
        player.getBossBar().create(this.uniqueId, player.getProperty(this.propertyTitle).updateAndGet(), this.parseProgress(player, player.getProperty(this.propertyProgress).updateAndGet()) / 100.0f, this.parseColor(player.getProperty(this.propertyColor).updateAndGet()), this.parseStyle(player.getProperty(this.propertyStyle).updateAndGet()));
    }

    public void removePlayerRaw(@NotNull TabPlayer player) {
        this.players.remove(player);
    }

    @Override
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (this.title.equals(title)) {
            return;
        }
        this.title = title;
        for (TabPlayer p : this.players) {
            p.setProperty(this.textRefresher, this.propertyTitle, title);
            p.getBossBar().update(this.uniqueId, p.getProperty(this.propertyTitle).get());
        }
    }

    @Override
    public void setProgress(@NonNull String progress) {
        if (progress == null) {
            throw new NullPointerException("progress is marked non-null but is null");
        }
        if (this.progress.equals(progress)) {
            return;
        }
        this.progress = progress;
        for (TabPlayer p : this.players) {
            p.setProperty(this.progressRefresher, this.propertyProgress, progress);
            p.getBossBar().update(this.uniqueId, this.parseProgress(p, p.getProperty(this.propertyProgress).get()) / 100.0f);
        }
    }

    @Override
    public void setProgress(float progress) {
        this.setProgress(String.valueOf(progress));
    }

    @Override
    public void setColor(@NonNull String color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (this.color.equals(color)) {
            return;
        }
        this.color = color;
        for (TabPlayer p : this.players) {
            p.setProperty(this.colorRefresher, this.propertyColor, color);
            p.getBossBar().update(this.uniqueId, this.parseColor(p.getProperty(this.propertyColor).get()));
        }
    }

    @Override
    public void setColor(@NonNull BarColor color) {
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        this.setColor(color.toString());
    }

    @Override
    public void setStyle(@NonNull String style) {
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        if (this.style.equals(style)) {
            return;
        }
        this.style = style;
        for (TabPlayer p : this.players) {
            p.setProperty(this.styleRefresher, this.propertyColor, style);
            p.getBossBar().update(this.uniqueId, this.parseStyle(p.getProperty(this.propertyStyle).get()));
        }
    }

    @Override
    public void setStyle(@NonNull BarStyle style) {
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        this.setStyle(style.toString());
    }

    @Override
    public void addPlayer(@NonNull me.neznamy.tab.api.TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        TabPlayer player = (TabPlayer)p;
        if (this.players.contains(player)) {
            return;
        }
        player.setProperty(this.textRefresher, this.propertyTitle, this.title);
        player.setProperty(this.progressRefresher, this.propertyProgress, this.progress);
        player.setProperty(this.colorRefresher, this.propertyColor, this.color);
        player.setProperty(this.styleRefresher, this.propertyStyle, this.style);
        this.sendToPlayerRaw(player);
        this.players.add(player);
    }

    @Override
    public void removePlayer(@NonNull me.neznamy.tab.api.TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        TabPlayer player = (TabPlayer)p;
        if (!this.players.contains(player)) {
            return;
        }
        this.players.remove(player);
        player.getBossBar().remove(this.uniqueId);
    }

    @Override
    @NotNull
    public List<me.neznamy.tab.api.TabPlayer> getPlayers() {
        return new ArrayList<me.neznamy.tab.api.TabPlayer>(this.players);
    }

    @Override
    public boolean containsPlayer(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        return this.players.contains((TabPlayer)player);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public UUID getUniqueId() {
        return this.uniqueId;
    }

    @Override
    public String getStyle() {
        return this.style;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getProgress() {
        return this.progress;
    }

    @Override
    public boolean isAnnouncementBar() {
        return this.announcementBar;
    }

    private class TextRefresher
    extends TabFeature
    implements Refreshable {
        private TextRefresher() {
        }

        @Override
        public void refresh(@NotNull TabPlayer refreshed, boolean force) {
            if (!BossBarLine.this.players.contains(refreshed)) {
                return;
            }
            refreshed.getBossBar().update(BossBarLine.this.uniqueId, refreshed.getProperty(BossBarLine.this.propertyTitle).updateAndGet());
        }

        @Override
        @NotNull
        public String getRefreshDisplayName() {
            return "Updating text";
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return "BossBar";
        }
    }

    private class ProgressRefresher
    extends TabFeature
    implements Refreshable {
        private ProgressRefresher() {
        }

        @Override
        public void refresh(@NotNull TabPlayer refreshed, boolean force) {
            if (!BossBarLine.this.players.contains(refreshed)) {
                return;
            }
            refreshed.getBossBar().update(BossBarLine.this.uniqueId, BossBarLine.this.parseProgress(refreshed, refreshed.getProperty(BossBarLine.this.propertyProgress).updateAndGet()) / 100.0f);
        }

        @Override
        @NotNull
        public String getRefreshDisplayName() {
            return "Updating progress";
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return "BossBar";
        }
    }

    private class ColorRefresher
    extends TabFeature
    implements Refreshable {
        private ColorRefresher() {
        }

        @Override
        public void refresh(@NotNull TabPlayer refreshed, boolean force) {
            if (!BossBarLine.this.players.contains(refreshed)) {
                return;
            }
            refreshed.getBossBar().update(BossBarLine.this.uniqueId, BossBarLine.this.parseColor(refreshed.getProperty(BossBarLine.this.propertyColor).updateAndGet()));
        }

        @Override
        @NotNull
        public String getRefreshDisplayName() {
            return "Updating color";
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return "BossBar";
        }
    }

    private class StyleRefresher
    extends TabFeature
    implements Refreshable {
        private StyleRefresher() {
        }

        @Override
        public void refresh(@NotNull TabPlayer refreshed, boolean force) {
            if (!BossBarLine.this.players.contains(refreshed)) {
                return;
            }
            refreshed.getBossBar().update(BossBarLine.this.uniqueId, BossBarLine.this.parseStyle(refreshed.getProperty(BossBarLine.this.propertyStyle).updateAndGet()));
        }

        @Override
        @NotNull
        public String getRefreshDisplayName() {
            return "Updating style";
        }

        @Override
        @NotNull
        public String getFeatureName() {
            return "BossBar";
        }
    }
}

