/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.bossbar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.neznamy.tab.api.bossbar.BarColor;
import me.neznamy.tab.api.bossbar.BarStyle;
import me.neznamy.tab.api.bossbar.BossBar;
import me.neznamy.tab.api.bossbar.BossBarManager;
import me.neznamy.tab.shared.ProtocolVersion;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.features.bossbar.BossBarLine;
import me.neznamy.tab.shared.features.types.CommandListener;
import me.neznamy.tab.shared.features.types.JoinListener;
import me.neznamy.tab.shared.features.types.Loadable;
import me.neznamy.tab.shared.features.types.LoginPacketListener;
import me.neznamy.tab.shared.features.types.QuitListener;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.features.types.UnLoadable;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class BossBarManagerImpl
extends TabFeature
implements BossBarManager,
JoinListener,
CommandListener,
Loadable,
UnLoadable,
Refreshable,
LoginPacketListener,
QuitListener {
    private final List<String> defaultBars = new ArrayList<String>();
    private final Map<String, BossBar> registeredBossBars = new HashMap<String, BossBar>();
    protected BossBar[] lineValues;
    private final String command = this.config().getString("bossbar.toggle-command", "/bossbar");
    private final boolean hiddenByDefault = this.config().getBoolean("bossbar.hidden-by-default", false);
    private final boolean rememberToggleChoice = this.config().getBoolean("bossbar.remember-toggle-choice", false);
    private final String toggleOnMessage = TAB.getInstance().getConfiguration().getMessages().getBossBarOn();
    private final String toggleOffMessage = TAB.getInstance().getConfiguration().getMessages().getBossBarOff();
    private final List<BossBar> announcedBossBars = new ArrayList<BossBar>();
    private final List<String> bossBarOffPlayers = this.rememberToggleChoice ? TAB.getInstance().getConfiguration().getPlayerDataFile().getStringList("bossbar-off", new ArrayList<String>()) : Collections.emptyList();
    private long announceEndTime;

    public BossBarManagerImpl() {
        for (Object bar : this.config().getConfigurationSection("bossbar.bars").keySet()) {
            BossBarLine line = this.loadFromConfig(bar.toString());
            this.registeredBossBars.put(bar.toString(), line);
            if (line.isAnnouncementBar()) continue;
            this.defaultBars.add(bar.toString());
        }
        this.lineValues = this.registeredBossBars.values().toArray(new BossBar[0]);
    }

    @NotNull
    private BossBarLine loadFromConfig(@NonNull String bar) {
        if (bar == null) {
            throw new NullPointerException("bar is marked non-null but is null");
        }
        Map<String, Object> bossBar = this.config().getConfigurationSection("bossbar.bars." + bar);
        TAB.getInstance().getConfigHelper().startup().checkBossBarProperties(bossBar, bar);
        return new BossBarLine(this, bar, (String)bossBar.get("display-condition"), String.valueOf(bossBar.get("color")), String.valueOf(bossBar.get("style")), String.valueOf(bossBar.get("text")), String.valueOf(bossBar.get("progress")), (Boolean)bossBar.getOrDefault("announcement-bar", false));
    }

    @Override
    public void load() {
        TAB.getInstance().getPlaceholderManager().registerServerPlaceholder("%countdown%", 100, () -> {
            long seconds = TimeUnit.MILLISECONDS.toSeconds(this.announceEndTime - System.currentTimeMillis());
            if (seconds < 0L) {
                return 0;
            }
            return seconds;
        });
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            this.onJoin(p);
        }
    }

    @Override
    public void refresh(@NotNull TabPlayer p, boolean force) {
        if (!this.hasBossBarVisible(p)) {
            return;
        }
        boolean conditionResultChange = false;
        for (BossBar line : this.lineValues) {
            if (((BossBarLine)line).isConditionMet(p) == line.containsPlayer(p)) continue;
            conditionResultChange = true;
        }
        if (conditionResultChange) {
            for (BossBar line : this.lineValues) {
                line.removePlayer(p);
            }
            this.showBossBars(p, this.defaultBars);
            this.showBossBars(p, this.announcedBossBars.stream().map(BossBar::getName).collect(Collectors.toList()));
        }
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating display conditions";
    }

    @Override
    public void unload() {
        for (TabPlayer p : TAB.getInstance().getOnlinePlayers()) {
            for (BossBar line : this.lineValues) {
                line.removePlayer(p);
            }
        }
    }

    @Override
    public void onJoin(@NotNull TabPlayer connectedPlayer) {
        this.setBossBarVisible(connectedPlayer, this.hiddenByDefault == this.bossBarOffPlayers.contains(connectedPlayer.getName()), false);
    }

    @Override
    public boolean onCommand(@NotNull TabPlayer sender, @NotNull String message) {
        if (message.equals(this.command)) {
            TAB.getInstance().getCommand().execute(sender, new String[]{"bossbar"});
            return true;
        }
        return false;
    }

    protected void detectBossBarsAndSend(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (!this.hasBossBarVisible(p)) {
            return;
        }
        this.showBossBars(p, this.defaultBars);
        this.showBossBars(p, this.announcedBossBars.stream().map(BossBar::getName).collect(Collectors.toList()));
    }

    private void showBossBars(@NonNull TabPlayer p, @NonNull List<String> bars) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (bars == null) {
            throw new NullPointerException("bars is marked non-null but is null");
        }
        for (String defaultBar : bars) {
            BossBarLine bar = (BossBarLine)this.registeredBossBars.get(defaultBar);
            if (!bar.isConditionMet(p) || bar.containsPlayer(p)) continue;
            bar.addPlayer(p);
        }
    }

    @Override
    public void onLoginPacket(TabPlayer player) {
        if (player.getVersion().getNetworkId() >= ProtocolVersion.V1_20_2.getNetworkId()) {
            player.getBossBar().unfreeze();
            for (BossBar bar : this.lineValues) {
                if (!bar.containsPlayer(player)) continue;
                ((BossBarLine)bar).sendToPlayerRaw(player);
            }
        }
    }

    @Override
    public void onQuit(@NotNull TabPlayer disconnectedPlayer) {
        for (BossBar line : this.lineValues) {
            ((BossBarLine)line).removePlayerRaw(disconnectedPlayer);
        }
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return "BossBar";
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NonNull String title, float progress, @NonNull BarColor color, @NonNull BarStyle style) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        this.ensureActive();
        return this.createBossBar(title, String.valueOf(progress), color.toString(), style.toString());
    }

    @Override
    @NotNull
    public BossBar createBossBar(@NonNull String title, @NonNull String progress, @NonNull String color, @NonNull String style) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (progress == null) {
            throw new NullPointerException("progress is marked non-null but is null");
        }
        if (color == null) {
            throw new NullPointerException("color is marked non-null but is null");
        }
        if (style == null) {
            throw new NullPointerException("style is marked non-null but is null");
        }
        this.ensureActive();
        UUID id = UUID.randomUUID();
        BossBarLine bar = new BossBarLine(this, id.toString(), null, color, style, title, progress, true);
        this.registeredBossBars.put(id.toString(), bar);
        this.lineValues = this.registeredBossBars.values().toArray(new BossBar[0]);
        return bar;
    }

    @Override
    public BossBar getBossBar(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.ensureActive();
        return this.registeredBossBars.get(name);
    }

    @Override
    public void toggleBossBar(@NonNull me.neznamy.tab.api.TabPlayer player, boolean sendToggleMessage) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        this.setBossBarVisible(player, !this.hasBossBarVisible(player), sendToggleMessage);
    }

    @Override
    public boolean hasBossBarVisible(@NonNull me.neznamy.tab.api.TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.ensureActive();
        return ((TabPlayer)player).bossbarData.visible;
    }

    @Override
    public void setBossBarVisible(@NonNull me.neznamy.tab.api.TabPlayer p, boolean visible, boolean sendToggleMessage) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        this.ensureActive();
        TabPlayer player = (TabPlayer)p;
        if (player.bossbarData.visible == visible) {
            return;
        }
        if (visible) {
            player.bossbarData.visible = true;
            this.detectBossBarsAndSend(player);
            if (sendToggleMessage) {
                player.sendMessage(this.toggleOnMessage, true);
            }
            if (this.rememberToggleChoice) {
                if (this.hiddenByDefault) {
                    if (!this.bossBarOffPlayers.contains(player.getName())) {
                        this.bossBarOffPlayers.add(player.getName());
                        this.savePlayers();
                    }
                } else if (this.bossBarOffPlayers.remove(player.getName())) {
                    this.savePlayers();
                }
            }
        } else {
            player.bossbarData.visible = false;
            for (BossBar l : this.lineValues) {
                l.removePlayer(player);
            }
            if (sendToggleMessage) {
                player.sendMessage(this.toggleOffMessage, true);
            }
            if (this.rememberToggleChoice) {
                if (this.hiddenByDefault) {
                    if (this.bossBarOffPlayers.remove(player.getName())) {
                        this.savePlayers();
                    }
                } else if (!this.bossBarOffPlayers.contains(player.getName())) {
                    this.bossBarOffPlayers.add(player.getName());
                    this.savePlayers();
                }
            }
        }
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setBossBarVisible(player, visible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePlayers() {
        List<String> list = this.bossBarOffPlayers;
        synchronized (list) {
            TAB.getInstance().getConfiguration().getPlayerDataFile().set("bossbar-off", new ArrayList<String>(this.bossBarOffPlayers));
        }
    }

    @Override
    public void sendBossBarTemporarily(@NonNull me.neznamy.tab.api.TabPlayer player, @NonNull String bossBar, int duration) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        if (bossBar == null) {
            throw new NullPointerException("bossBar is marked non-null but is null");
        }
        this.ensureActive();
        if (!this.hasBossBarVisible(player)) {
            return;
        }
        BossBar line = this.registeredBossBars.get(bossBar);
        if (line == null) {
            throw new IllegalArgumentException("No registered BossBar found with name " + bossBar);
        }
        TAB.getInstance().getCPUManager().runMeasuredTask(this.getFeatureName(), "Adding temporary BossBar", () -> line.addPlayer(player));
        TAB.getInstance().getCPUManager().runTaskLater((int)TimeUnit.SECONDS.toMillis(duration), this.getFeatureName(), "Removing temporary BossBar", () -> line.removePlayer(player));
    }

    @Override
    public void announceBossBar(@NonNull String bossBar, int duration) {
        if (bossBar == null) {
            throw new NullPointerException("bossBar is marked non-null but is null");
        }
        this.ensureActive();
        BossBar line = this.registeredBossBars.get(bossBar);
        if (line == null) {
            throw new IllegalArgumentException("No registered BossBar found with name " + bossBar);
        }
        List players = Arrays.stream(TAB.getInstance().getOnlinePlayers()).filter(this::hasBossBarVisible).collect(Collectors.toList());
        TAB.getInstance().getCPUManager().runMeasuredTask(this.getFeatureName(), "Adding announced BossBar", () -> {
            this.announcedBossBars.add(line);
            this.announceEndTime = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(duration);
            for (TabPlayer all : players) {
                if (!((BossBarLine)line).isConditionMet(all)) continue;
                line.addPlayer(all);
            }
        });
        TAB.getInstance().getCPUManager().runTaskLater((int)TimeUnit.SECONDS.toMillis(duration), this.getFeatureName(), "Removing announced BossBar", () -> {
            for (TabPlayer all : players) {
                line.removePlayer(all);
            }
            this.announcedBossBars.remove(line);
        });
    }

    @Override
    public Map<String, BossBar> getRegisteredBossBars() {
        return this.registeredBossBars;
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public List<BossBar> getAnnouncedBossBars() {
        return this.announcedBossBars;
    }

    public static class PlayerData {
        public boolean visible;
    }
}

