/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.redis.feature;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import java.util.UUID;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.chat.TabComponent;
import me.neznamy.tab.shared.features.YellowNumber;
import me.neznamy.tab.shared.features.redis.RedisPlayer;
import me.neznamy.tab.shared.features.redis.RedisSupport;
import me.neznamy.tab.shared.features.redis.feature.RedisFeature;
import me.neznamy.tab.shared.features.redis.message.RedisMessage;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class RedisYellowNumber
extends RedisFeature {
    private final RedisSupport redisSupport;
    private final YellowNumber yellowNumber;

    public RedisYellowNumber(@NotNull RedisSupport redisSupport, @NotNull YellowNumber yellowNumber) {
        this.redisSupport = redisSupport;
        this.yellowNumber = yellowNumber;
        redisSupport.registerMessage("yellow-number", Update.class, () -> new Update());
    }

    @Override
    public void onJoin(@NotNull TabPlayer player) {
        for (RedisPlayer redis : this.redisSupport.getRedisPlayers().values()) {
            player.getScoreboard().setScore("TAB-PlayerList", redis.getNickname(), redis.getPlayerlistNumber(), null, redis.getPlayerlistFancy());
        }
    }

    @Override
    public void onJoin(@NotNull RedisPlayer player) {
        for (TabPlayer viewer : TAB.getInstance().getOnlinePlayers()) {
            viewer.getScoreboard().setScore("TAB-PlayerList", player.getNickname(), player.getPlayerlistNumber(), null, player.getPlayerlistFancy());
        }
    }

    @Override
    public void write(@NotNull ByteArrayDataOutput out, @NotNull TabPlayer player) {
        out.writeInt(this.yellowNumber.getValueNumber(player));
        out.writeUTF(player.getProperty(this.yellowNumber.getPROPERTY_VALUE_FANCY()).get());
    }

    @Override
    public void read(@NotNull ByteArrayDataInput in, @NotNull RedisPlayer player) {
        player.setPlayerlistNumber(in.readInt());
        player.setPlayerlistFancy(TabComponent.optimized(in.readUTF()));
    }

    @Override
    public void onLoginPacket(@NotNull TabPlayer player) {
        this.onJoin(player);
    }

    public YellowNumber getYellowNumber() {
        return this.yellowNumber;
    }

    public class Update
    extends RedisMessage {
        private UUID playerId;
        private int value;
        private String fancyValue;

        @Override
        public void write(@NotNull ByteArrayDataOutput out) {
            this.writeUUID(out, this.playerId);
            out.writeInt(this.value);
            out.writeUTF(this.fancyValue);
        }

        @Override
        public void read(@NotNull ByteArrayDataInput in) {
            this.playerId = this.readUUID(in);
            this.value = in.readInt();
            this.fancyValue = in.readUTF();
        }

        @Override
        public void process(@NotNull RedisSupport redisSupport) {
            RedisPlayer target = redisSupport.getRedisPlayers().get(this.playerId);
            if (target == null) {
                return;
            }
            target.setPlayerlistNumber(this.value);
            target.setPlayerlistFancy(TabComponent.optimized(this.fancyValue));
            RedisYellowNumber.this.onJoin(target);
        }

        public Update() {
        }

        public Update(UUID playerId, int value, String fancyValue) {
            this.playerId = playerId;
            this.value = value;
            this.fancyValue = fancyValue;
        }
    }
}

