/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.features.scoreboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import lombok.NonNull;
import me.neznamy.tab.api.scoreboard.Line;
import me.neznamy.tab.api.scoreboard.Scoreboard;
import me.neznamy.tab.shared.Property;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.chat.SimpleComponent;
import me.neznamy.tab.shared.features.scoreboard.ScoreboardManagerImpl;
import me.neznamy.tab.shared.features.scoreboard.lines.LongLine;
import me.neznamy.tab.shared.features.scoreboard.lines.ScoreboardLine;
import me.neznamy.tab.shared.features.scoreboard.lines.StableDynamicLine;
import me.neznamy.tab.shared.features.types.Refreshable;
import me.neznamy.tab.shared.features.types.TabFeature;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScoreboardImpl
extends TabFeature
implements Scoreboard,
Refreshable {
    private final String titleProperty = Property.randomName();
    private final ScoreboardManagerImpl manager;
    private final String name;
    private String title;
    private Condition displayCondition;
    private final List<Line> lines = new ArrayList<Line>();
    private final Set<TabPlayer> players = Collections.newSetFromMap(new WeakHashMap());

    public ScoreboardImpl(@NonNull ScoreboardManagerImpl manager, @NonNull String name, @NonNull String title, @NonNull List<String> lines, @Nullable String displayCondition) {
        this(manager, name, title, lines, false);
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        this.displayCondition = Condition.getCondition(displayCondition);
        if (this.displayCondition != null) {
            manager.addUsedPlaceholder(TabConstants.Placeholder.condition(this.displayCondition.getName()));
        }
    }

    public ScoreboardImpl(@NonNull ScoreboardManagerImpl manager, @NonNull String name, @NonNull String title, @NonNull List<String> lines, boolean dynamicLinesOnly) {
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (lines == null) {
            throw new NullPointerException("lines is marked non-null but is null");
        }
        this.manager = manager;
        this.name = name;
        this.title = title;
        for (int i = 0; i < lines.size(); ++i) {
            ScoreboardLine score = dynamicLinesOnly ? new StableDynamicLine(this, i + 1, lines.get(i)) : this.registerLine(i + 1, lines.get(i));
            this.lines.add(score);
            TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.scoreboardLine(name, i), score);
        }
    }

    @NotNull
    private ScoreboardLine registerLine(int lineNumber, @Nullable String text) {
        if (text == null) {
            return new LongLine(this, lineNumber, "");
        }
        if (text.startsWith("Long|")) {
            return new LongLine(this, lineNumber, text.substring(5));
        }
        if (text.contains("%")) {
            return new StableDynamicLine(this, lineNumber, text);
        }
        return new LongLine(this, lineNumber, text);
    }

    public boolean isConditionMet(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        return this.displayCondition == null || this.displayCondition.isMet(p);
    }

    public void addPlayer(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (this.players.contains(p)) {
            return;
        }
        p.setProperty(this, this.titleProperty, this.title);
        p.getScoreboard().registerObjective("TAB-Scoreboard", p.getProperty(this.titleProperty).updateAndGet(), 0, new SimpleComponent(""));
        p.getScoreboard().setDisplaySlot(1, "TAB-Scoreboard");
        for (Line s : this.lines) {
            ((ScoreboardLine)s).register(p);
        }
        this.players.add(p);
        p.scoreboardData.activeScoreboard = this;
        this.recalculateScores(p);
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setScoreboardName(p, this.name);
    }

    public void removePlayer(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (!this.players.remove(p)) {
            return;
        }
        p.getScoreboard().unregisterObjective("TAB-Scoreboard");
        for (Line line : this.lines) {
            if (!((ScoreboardLine)line).isShownTo(p)) continue;
            p.getScoreboard().unregisterTeam(((ScoreboardLine)line).getTeamName());
        }
        p.scoreboardData.activeScoreboard = null;
        TAB.getInstance().getPlaceholderManager().getTabExpansion().setScoreboardName(p, "");
    }

    @Override
    public void refresh(@NotNull TabPlayer refreshed, boolean force) {
        if (!this.players.contains(refreshed)) {
            return;
        }
        refreshed.getScoreboard().updateObjective("TAB-Scoreboard", refreshed.getProperty(this.titleProperty).updateAndGet(), 0, new SimpleComponent(""));
    }

    @Override
    @NotNull
    public String getRefreshDisplayName() {
        return "Updating Scoreboard title";
    }

    public void recalculateScores(@NonNull TabPlayer p) {
        if (p == null) {
            throw new NullPointerException("p is marked non-null but is null");
        }
        if (!this.manager.isUsingNumbers()) {
            return;
        }
        ArrayList<Line> linesReversed = new ArrayList<Line>(this.lines);
        Collections.reverse(linesReversed);
        int score = this.manager.getStaticNumber();
        for (Line line : linesReversed) {
            Property pr = p.getProperty(((ScoreboardLine)line).getTextProperty());
            if (!pr.getCurrentRawValue().isEmpty() && (pr.getCurrentRawValue().isEmpty() || pr.get().isEmpty())) continue;
            p.getScoreboard().setScore("TAB-Scoreboard", ((ScoreboardLine)line).getPlayerName(p), score++, null, ((ScoreboardLine)line).getScoreRefresher().getNumberFormat(p));
        }
    }

    public void removePlayerFromSet(@NonNull TabPlayer player) {
        if (player == null) {
            throw new NullPointerException("player is marked non-null but is null");
        }
        this.players.remove(player);
    }

    @Override
    @NotNull
    public String getFeatureName() {
        return this.manager.getFeatureName();
    }

    @Override
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.ensureActive();
        this.title = title;
        for (TabPlayer p : this.players) {
            p.setProperty(this, this.titleProperty, title);
            this.refresh(p, false);
        }
    }

    @Override
    public void addLine(@NonNull String text) {
        if (text == null) {
            throw new NullPointerException("text is marked non-null but is null");
        }
        this.ensureActive();
        StableDynamicLine line = new StableDynamicLine(this, this.lines.size() + 1, text);
        TAB.getInstance().getFeatureManager().registerFeature(TabConstants.Feature.scoreboardLine(this.name, this.lines.size()), line);
        this.lines.add(line);
        for (TabPlayer p : this.players) {
            line.register(p);
            this.recalculateScores(p);
        }
    }

    @Override
    public void removeLine(int index) {
        this.ensureActive();
        if (index < 0 || index >= this.lines.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of range (0 - " + (this.lines.size() - 1) + ")");
        }
        ScoreboardLine line = (ScoreboardLine)this.lines.get(index);
        this.lines.remove(line);
        for (TabPlayer p : this.players) {
            line.unregister(p);
            this.recalculateScores(p);
        }
        TAB.getInstance().getFeatureManager().unregisterFeature(TabConstants.Feature.scoreboardLine(this.name, index));
    }

    @Override
    public void unregister() {
        this.ensureActive();
        for (TabPlayer all : this.players.toArray(new TabPlayer[0])) {
            this.removePlayer(all);
        }
        this.players.clear();
    }

    public String getTitleProperty() {
        return this.titleProperty;
    }

    public ScoreboardManagerImpl getManager() {
        return this.manager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public Condition getDisplayCondition() {
        return this.displayCondition;
    }

    @Override
    public List<Line> getLines() {
        return this.lines;
    }

    public Set<TabPlayer> getPlayers() {
        return this.players;
    }
}

