/*
 * Decompiled with CFR 0.152.
 */
package me.neznamy.tab.shared.placeholders;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.NonNull;
import me.neznamy.tab.api.placeholder.PlaceholderManager;
import me.neznamy.tab.shared.TAB;
import me.neznamy.tab.shared.TabConstants;
import me.neznamy.tab.shared.features.PlaceholderManagerImpl;
import me.neznamy.tab.shared.hook.LuckPermsHook;
import me.neznamy.tab.shared.placeholders.Animation;
import me.neznamy.tab.shared.placeholders.conditions.Condition;
import me.neznamy.tab.shared.platform.TabPlayer;
import org.jetbrains.annotations.NotNull;

public class UniversalPlaceholderRegistry {
    private final DecimalFormat decimal2;

    public UniversalPlaceholderRegistry() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        this.decimal2 = new DecimalFormat("#.##", symbols);
    }

    public void registerPlaceholders(@NotNull PlaceholderManager manager) {
        this.registerConstants(manager);
        this.registerServerPlaceholders(manager);
        this.registerPlayerPlaceholders(manager);
    }

    private void registerConstants(@NotNull PlaceholderManager manager) {
        manager.registerPlayerPlaceholder("%bedrock%", -1, p -> ((TabPlayer)p).isBedrockPlayer());
        manager.registerPlayerPlaceholder("%player%", -1, me.neznamy.tab.api.TabPlayer::getName);
        manager.registerPlayerPlaceholder("%world%", -1, p -> ((TabPlayer)p).getWorld());
        manager.registerPlayerPlaceholder("%server%", -1, p -> ((TabPlayer)p).getServer());
        manager.registerPlayerPlaceholder("%player-version%", -1, p -> ((TabPlayer)p).getVersion().getFriendlyName());
        manager.registerPlayerPlaceholder("%player-version-id%", -1, p -> ((TabPlayer)p).getVersion().getNetworkId());
        manager.registerServerPlaceholder("%%", -1, () -> "%");
        manager.registerServerPlaceholder("%memory-max%", -1, () -> (int)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        manager.registerServerPlaceholder("%memory-max-gb%", -1, () -> this.decimal2.format((float)Runtime.getRuntime().maxMemory() / 1024.0f / 1024.0f / 1024.0f));
        if (!LuckPermsHook.getInstance().isInstalled()) {
            manager.registerServerPlaceholder("%luckperms-prefix%", -1, () -> "");
            manager.registerServerPlaceholder("%luckperms-suffix%", -1, () -> "");
        }
    }

    private void registerServerPlaceholders(@NotNull PlaceholderManager manager) {
        double timeOffset = TAB.getInstance().getConfiguration().getConfig().getDouble("placeholders.time-offset", 0.0);
        SimpleDateFormat timeFormat = this.createDateFormat(TAB.getInstance().getConfiguration().getConfig().getString("placeholders.time-format", "[HH:mm:ss / h:mm a]"), "[HH:mm:ss / h:mm a]");
        SimpleDateFormat dateFormat = this.createDateFormat(TAB.getInstance().getConfiguration().getConfig().getString("placeholders.date-format", "dd.MM.yyyy"), "dd.MM.yyyy");
        manager.registerServerPlaceholder("%time%", 500, () -> timeFormat.format(new Date(System.currentTimeMillis() + (long)((int)(timeOffset * 3600000.0)))));
        manager.registerServerPlaceholder("%date%", 60000, () -> dateFormat.format(new Date(System.currentTimeMillis() + (long)((int)(timeOffset * 3600000.0)))));
        manager.registerServerPlaceholder("%memory-used%", 200, () -> (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L));
        manager.registerServerPlaceholder("%memory-used-gb%", 200, () -> this.decimal2.format((float)(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024.0f / 1024.0f / 1024.0f));
        manager.registerServerPlaceholder("%online%", 1000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (player.isVanished()) continue;
                ++count;
            }
            return count;
        });
        manager.registerServerPlaceholder("%staffonline%", 2000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (!player.hasPermission("tab.staff") || player.isVanished()) continue;
                ++count;
            }
            return count;
        });
        manager.registerServerPlaceholder("%nonstaffonline%", 2000, () -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (player.hasPermission("tab.staff") || player.isVanished()) continue;
                ++count;
            }
            return count;
        });
    }

    private void registerPlayerPlaceholders(@NotNull PlaceholderManager manager) {
        manager.registerPlayerPlaceholder("%group%", -1, me.neznamy.tab.api.TabPlayer::getGroup);
        manager.registerPlayerPlaceholder("%ping%", 500, p -> ((TabPlayer)p).getPing());
        manager.registerPlayerPlaceholder("%vanished%", 1000, p -> ((TabPlayer)p).isVanished());
        manager.registerPlayerPlaceholder("%worldonline%", 1000, p -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (!((TabPlayer)p).getWorld().equals(player.getWorld()) || player.isVanished()) continue;
                ++count;
            }
            return count;
        });
        manager.registerPlayerPlaceholder("%serveronline%", 1000, p -> {
            int count = 0;
            for (TabPlayer player : TAB.getInstance().getOnlinePlayers()) {
                if (!((TabPlayer)p).getServer().equals(player.getServer()) || player.isVanished()) continue;
                ++count;
            }
            return count;
        });
        manager.registerPlayerPlaceholder("%gamemode%", 100, p -> ((TabPlayer)p).getGamemode());
        if (LuckPermsHook.getInstance().isInstalled()) {
            int refresh = TAB.getInstance().getConfiguration().getPermissionRefreshInterval();
            manager.registerPlayerPlaceholder("%luckperms-prefix%", refresh, p -> LuckPermsHook.getInstance().getPrefix((TabPlayer)p));
            manager.registerPlayerPlaceholder("%luckperms-suffix%", refresh, p -> LuckPermsHook.getInstance().getSuffix((TabPlayer)p));
        }
        for (String s : TAB.getInstance().getConfiguration().getAnimationFile().getValues().keySet()) {
            Animation a = new Animation((PlaceholderManagerImpl)manager, s.toString(), TAB.getInstance().getConfiguration().getAnimationFile().getStringList(s + ".texts"), TAB.getInstance().getConfiguration().getAnimationFile().getInt(s + ".change-interval", 0));
            manager.registerPlayerPlaceholder(TabConstants.Placeholder.animation(a.getName()), a.getRefresh(), p -> a.getMessage());
        }
        Condition.clearConditions();
        Map conditions = TAB.getInstance().getConfiguration().getConfig().getConfigurationSection("conditions");
        for (Map.Entry condition : conditions.entrySet()) {
            String name = (String)condition.getKey();
            List list = (List)((Map)condition.getValue()).get("conditions");
            Object type = ((Map)condition.getValue()).get("type");
            String yes = ((Object)((Map)condition.getValue()).getOrDefault(true, true)).toString();
            String no = ((Object)((Map)condition.getValue()).getOrDefault(false, false)).toString();
            if (list == null) {
                TAB.getInstance().getConfigHelper().startup().conditionHasNoConditions(name);
                continue;
            }
            if (list.size() >= 2 && type == null) {
                TAB.getInstance().getConfigHelper().startup().conditionMissingType(name);
            }
            Condition c = new Condition(!"OR".equals(type), name, list, yes, no);
            manager.registerPlayerPlaceholder(TabConstants.Placeholder.condition(c.getName()), c.getRefresh(), p -> c.getText((TabPlayer)p));
        }
        Condition.finishSetups();
    }

    private SimpleDateFormat createDateFormat(@NonNull String value, @NonNull String defaultValue) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue is marked non-null but is null");
        }
        try {
            return new SimpleDateFormat(value, Locale.ENGLISH);
        }
        catch (IllegalArgumentException e) {
            TAB.getInstance().getConfigHelper().startup().invalidDateFormat(value);
            return new SimpleDateFormat(defaultValue);
        }
    }

    public DecimalFormat getDecimal2() {
        return this.decimal2;
    }
}

