/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.modules.laser;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.turtle.ITurtleAccess;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.IPlayerOwnable;
import io.sc3.plethora.api.IWorldLocation;
import io.sc3.plethora.api.method.ArgumentExt;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.IContext;
import io.sc3.plethora.api.method.IUnbakedContext;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.module.SubtargetedModuleMethod;
import io.sc3.plethora.gameplay.modules.laser.LaserEntity;
import io.sc3.plethora.gameplay.registry.PlethoraModules;
import io.sc3.plethora.util.Helpers;
import io.sc3.plethora.util.PlayerHelpers;
import io.sc3.plethora.util.config.PlethoraConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bR%\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lio/sc3/plethora/gameplay/modules/laser/LaserMethods;", "", "<init>", "()V", "Lio/sc3/plethora/api/method/IUnbakedContext;", "Lio/sc3/plethora/api/module/IModuleContainer;", "unbaked", "Ldan200/computercraft/api/lua/IArguments;", "args", "Lio/sc3/plethora/api/method/FutureMethodResult;", "fire", "(Lio/sc3/plethora/api/method/IUnbakedContext;Ldan200/computercraft/api/lua/IArguments;)Lio/sc3/plethora/api/method/FutureMethodResult;", "Lio/sc3/plethora/api/module/SubtargetedModuleMethod;", "Lio/sc3/plethora/api/IWorldLocation;", "kotlin.jvm.PlatformType", "FIRE", "Lio/sc3/plethora/api/module/SubtargetedModuleMethod;", "getFIRE", "()Lio/sc3/plethora/api/module/SubtargetedModuleMethod;", "Lio/sc3/plethora/util/config/PlethoraConfig$Laser;", "getCfg", "()Lio/sc3/plethora/util/config/PlethoraConfig$Laser;", "cfg", "GitHub2"})
public final class LaserMethods {
    @NotNull
    public static final LaserMethods INSTANCE = new LaserMethods();
    @NotNull
    private static final SubtargetedModuleMethod<IWorldLocation> FIRE;

    private LaserMethods() {
    }

    private final PlethoraConfig.Laser getCfg() {
        return Plethora.config.laser;
    }

    @NotNull
    public final SubtargetedModuleMethod<IWorldLocation> getFIRE() {
        return FIRE;
    }

    private final FutureMethodResult fire(IUnbakedContext<IModuleContainer> unbaked, IArguments args) {
        double yaw = Helpers.normaliseAngle(args.getFiniteDouble(0));
        double pitch = Helpers.normaliseAngle(args.getFiniteDouble(1));
        float potency = (float)ArgumentExt.assertDoubleBetween(args, 2, this.getCfg().minimumPotency, this.getCfg().maximumPotency, "Potency out of range (%s).");
        boolean old = args.optBoolean(3, false);
        double motionX = -Math.sin(yaw / (double)180.0f * (double)((float)Math.PI)) * Math.cos(pitch / (double)180.0f * (double)((float)Math.PI));
        double motionZ = Math.cos(yaw / (double)180.0f * (double)((float)Math.PI)) * Math.cos(pitch / (double)180.0f * (double)((float)Math.PI));
        double motionY = -Math.sin(pitch / (double)180.0f * (double)((float)Math.PI));
        FutureMethodResult futureMethodResult = unbaked.getCostHandler().await((double)potency * this.getCfg().cost, FutureMethodResult.nextTick(() -> LaserMethods.fire$lambda$0(unbaked, motionX, motionY, motionZ, potency)));
        Intrinsics.checkNotNullExpressionValue((Object)futureMethodResult, (String)"await(...)");
        return futureMethodResult;
    }

    private static final FutureMethodResult fire$lambda$0(IUnbakedContext $unbaked, double $motionX, double $motionY, double $motionZ, float $potency) {
        Intrinsics.checkNotNullParameter((Object)$unbaked, (String)"$unbaked");
        IContext iContext = $unbaked.bake();
        Intrinsics.checkNotNullExpressionValue(iContext, (String)"bake(...)");
        IContext ctx = iContext;
        IWorldLocation location = ctx.getContext("origin", IWorldLocation.class);
        class_243 class_2432 = location.getLoc();
        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"getLoc(...)");
        class_243 pos = class_2432;
        class_1937 class_19372 = location.getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"getWorld(...)");
        LaserEntity laser = new LaserEntity(class_19372, pos);
        IPlayerOwnable ownable = ctx.getContext("origin", IPlayerOwnable.class);
        class_1297 entity = ctx.getContext("origin", class_1297.class);
        IPlayerOwnable iPlayerOwnable = ownable;
        if (iPlayerOwnable == null || (iPlayerOwnable = iPlayerOwnable.getOwningProfile()) == null) {
            iPlayerOwnable = PlayerHelpers.getProfile(entity);
        }
        IPlayerOwnable profile = iPlayerOwnable;
        laser.setShooter(entity, (GameProfile)profile);
        if (ctx.hasContext(class_2586.class) || ctx.hasContext(ITurtleAccess.class)) {
            laser.method_33574(pos.method_1019(new class_243(0.5, 0.5, 0.5)));
            laser.method_33574(pos.method_1019(new class_243(class_3532.method_15350((double)($motionX * 1.25), (double)-0.75, (double)0.75), class_3532.method_15350((double)($motionY * 1.25), (double)-0.75, (double)0.75), class_3532.method_15350((double)($motionZ * 1.25), (double)-0.75, (double)0.75))));
        } else if (ctx.hasContext(class_1297.class)) {
            class_1297 entity2 = ctx.getContext(class_1297.class);
            class_243 vector = entity2.method_19538();
            double offset = (double)entity2.method_17681() + 0.2;
            double length = Math.sqrt($motionX * $motionX + $motionY * $motionY + $motionZ * $motionZ);
            laser.method_33574(vector.method_1031($motionX / length * offset, (double)entity2.method_5751() + $motionY / length * offset, $motionZ / length * offset));
        } else {
            laser.method_33574(pos);
        }
        laser.setPotency($potency);
        laser.shoot($motionX, $motionY, $motionZ, 1.5f, 0.0f);
        location.getWorld().method_8649((class_1297)laser);
        return FutureMethodResult.empty();
    }

    static {
        SubtargetedModuleMethod<IWorldLocation> subtargetedModuleMethod = SubtargetedModuleMethod.of("fire", PlethoraModules.LASER_M, IWorldLocation.class, "function(yaw:number, pitch:number, potency:number) -- Fire a laser in a set direction", INSTANCE::fire);
        Intrinsics.checkNotNullExpressionValue(subtargetedModuleMethod, (String)"of(...)");
        FIRE = subtargetedModuleMethod;
    }
}

