/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.modules.sensor;

import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.IWorldLocation;
import io.sc3.plethora.api.method.FutureMethodResult;
import io.sc3.plethora.api.method.IContext;
import io.sc3.plethora.api.method.IPartialContext;
import io.sc3.plethora.api.method.IUnbakedContext;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.module.SubtargetedModuleMethod;
import io.sc3.plethora.api.reference.Reference;
import io.sc3.plethora.core.ContextHelpers;
import io.sc3.plethora.gameplay.modules.RangeInfo;
import io.sc3.plethora.gameplay.modules.sensor.SensorHelpers;
import io.sc3.plethora.gameplay.registry.PlethoraModules;
import io.sc3.plethora.integration.vanilla.meta.entity.EntityMeta;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\u00020\u00072\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\r\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u000f\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u000eJ%\u0010\u0010\u001a\u00020\f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u000eR%\u0010\u0014\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R%\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0015\u001a\u0004\b\u0019\u0010\u0017R%\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u00118\u0006\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lio/sc3/plethora/gameplay/modules/sensor/SensorMethods;", "", "<init>", "()V", "Lio/sc3/plethora/api/method/IUnbakedContext;", "Lio/sc3/plethora/api/module/IModuleContainer;", "unbaked", "Lio/sc3/plethora/gameplay/modules/sensor/SensorMethods$SensorMethodContext;", "getContext", "(Lio/sc3/plethora/api/method/IUnbakedContext;)Lio/sc3/plethora/gameplay/modules/sensor/SensorMethods$SensorMethodContext;", "Ldan200/computercraft/api/lua/IArguments;", "args", "Lio/sc3/plethora/api/method/FutureMethodResult;", "getMetaById", "(Lio/sc3/plethora/api/method/IUnbakedContext;Ldan200/computercraft/api/lua/IArguments;)Lio/sc3/plethora/api/method/FutureMethodResult;", "getMetaByName", "sense", "Lio/sc3/plethora/api/module/SubtargetedModuleMethod;", "Lio/sc3/plethora/api/IWorldLocation;", "kotlin.jvm.PlatformType", "GET_META_BY_ID", "Lio/sc3/plethora/api/module/SubtargetedModuleMethod;", "getGET_META_BY_ID", "()Lio/sc3/plethora/api/module/SubtargetedModuleMethod;", "GET_META_BY_NAME", "getGET_META_BY_NAME", "SENSE", "getSENSE", "SensorMethodContext", "GitHub2"})
public final class SensorMethods {
    @NotNull
    public static final SensorMethods INSTANCE = new SensorMethods();
    @NotNull
    private static final SubtargetedModuleMethod<IWorldLocation> SENSE;
    @NotNull
    private static final SubtargetedModuleMethod<IWorldLocation> GET_META_BY_ID;
    @NotNull
    private static final SubtargetedModuleMethod<IWorldLocation> GET_META_BY_NAME;

    private SensorMethods() {
    }

    @NotNull
    public final SubtargetedModuleMethod<IWorldLocation> getSENSE() {
        return SENSE;
    }

    private final FutureMethodResult sense(IUnbakedContext<IModuleContainer> unbaked, IArguments args) {
        SensorMethodContext ctx = this.getContext(unbaked);
        class_1937 class_19372 = ctx.loc().getWorld();
        Intrinsics.checkNotNullExpressionValue((Object)class_19372, (String)"getWorld(...)");
        class_1937 world = class_19372;
        class_2338 class_23382 = ctx.loc().getPos();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"getPos(...)");
        class_2338 pos = class_23382;
        FutureMethodResult futureMethodResult = ctx.context().getCostHandler().await((double)ctx.range().getBulkCost(), () -> SensorMethods.sense$lambda$1(world, pos, ctx));
        Intrinsics.checkNotNullExpressionValue((Object)futureMethodResult, (String)"await(...)");
        return futureMethodResult;
    }

    @NotNull
    public final SubtargetedModuleMethod<IWorldLocation> getGET_META_BY_ID() {
        return GET_META_BY_ID;
    }

    private final FutureMethodResult getMetaById(IUnbakedContext<IModuleContainer> unbaked, IArguments args) {
        UUID uUID;
        SensorMethodContext ctx = this.getContext(unbaked);
        int radius = ctx.range().getRange();
        try {
            uUID = UUID.fromString(args.getString(0));
        }
        catch (IllegalArgumentException e) {
            throw new LuaException("Invalid UUID");
        }
        UUID uuid = uUID;
        IWorldLocation iWorldLocation = ctx.loc();
        double d = radius;
        Intrinsics.checkNotNull((Object)uuid);
        class_1297 class_12972 = SensorHelpers.INSTANCE.findEntityByUuid(iWorldLocation, d, uuid);
        if (class_12972 == null) {
            FutureMethodResult futureMethodResult = FutureMethodResult.empty();
            Intrinsics.checkNotNullExpressionValue((Object)futureMethodResult, (String)"empty(...)");
            return futureMethodResult;
        }
        class_1297 entity = class_12972;
        FutureMethodResult futureMethodResult = FutureMethodResult.result(ctx.context().makeChild(entity, Reference.bounded(entity, ctx.loc(), radius)).getMeta());
        Intrinsics.checkNotNullExpressionValue((Object)futureMethodResult, (String)"result(...)");
        return futureMethodResult;
    }

    @NotNull
    public final SubtargetedModuleMethod<IWorldLocation> getGET_META_BY_NAME() {
        return GET_META_BY_NAME;
    }

    private final FutureMethodResult getMetaByName(IUnbakedContext<IModuleContainer> unbaked, IArguments args) {
        try {
            SensorMethodContext ctx = this.getContext(unbaked);
            int radius = ctx.range().getRange();
            IWorldLocation iWorldLocation = ctx.loc();
            double d = radius;
            String string = args.getString(0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            class_1297 class_12972 = SensorHelpers.INSTANCE.findEntityByName(iWorldLocation, d, string);
            if (class_12972 == null) {
                FutureMethodResult futureMethodResult = FutureMethodResult.empty();
                Intrinsics.checkNotNullExpressionValue((Object)futureMethodResult, (String)"empty(...)");
                return futureMethodResult;
            }
            class_1297 entity = class_12972;
            FutureMethodResult futureMethodResult = FutureMethodResult.result(ctx.context().makeChild(entity, Reference.bounded(entity, ctx.loc(), radius)).getMeta());
            Intrinsics.checkNotNullExpressionValue((Object)futureMethodResult, (String)"result(...)");
            return futureMethodResult;
        }
        catch (Exception e) {
            Plethora.log.error("Error in getMetaByName", (Throwable)e);
            throw new LuaException("Unknown error in getMetaByName");
        }
    }

    private final SensorMethodContext getContext(IUnbakedContext<IModuleContainer> unbaked) {
        IContext<IModuleContainer> iContext = unbaked.bake();
        Intrinsics.checkNotNullExpressionValue(iContext, (String)"bake(...)");
        IContext<IModuleContainer> ctx = iContext;
        String[] stringArray = new String[]{"origin"};
        IWorldLocation loc = ContextHelpers.fromContext((IPartialContext)ctx, IWorldLocation.class, stringArray);
        class_2960[] class_2960Array = new class_2960[]{PlethoraModules.SENSOR_M};
        RangeInfo range = ContextHelpers.fromContext((IPartialContext)ctx, RangeInfo.class, class_2960Array);
        IWorldLocation iWorldLocation = loc;
        Intrinsics.checkNotNull((Object)iWorldLocation);
        RangeInfo rangeInfo = range;
        Intrinsics.checkNotNull((Object)rangeInfo);
        return new SensorMethodContext(ctx, iWorldLocation, rangeInfo);
    }

    private static final Map sense$lambda$1$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Map)$tmp0.invoke(p0);
    }

    private static final FutureMethodResult sense$lambda$1(class_1937 $world, class_2338 $pos, SensorMethodContext $ctx) {
        Intrinsics.checkNotNullParameter((Object)$world, (String)"$world");
        Intrinsics.checkNotNullParameter((Object)$pos, (String)"$pos");
        Intrinsics.checkNotNullParameter((Object)$ctx, (String)"$ctx");
        List entities2 = $world.method_8390(class_1297.class, SensorHelpers.INSTANCE.getBox($pos, $ctx.range().getRange()), SensorHelpers.INSTANCE.getDefaultPredicate());
        return FutureMethodResult.result(entities2.stream().map(arg_0 -> SensorMethods.sense$lambda$1$lambda$0((Function1)new Function1<class_1297, Map<String, Object>>($ctx){
            final /* synthetic */ SensorMethodContext $ctx;
            {
                this.$ctx = $ctx;
                super(1);
            }

            public final Map<String, Object> invoke(class_1297 e) {
                Intrinsics.checkNotNull((Object)e);
                return EntityMeta.getBasicProperties(e, this.$ctx.loc());
            }
        }, arg_0)).toList());
    }

    static {
        SubtargetedModuleMethod<IWorldLocation> subtargetedModuleMethod = SubtargetedModuleMethod.of("sense", PlethoraModules.SENSOR_M, IWorldLocation.class, "function():table -- Scan for entities in the vicinity", INSTANCE::sense);
        Intrinsics.checkNotNullExpressionValue(subtargetedModuleMethod, (String)"of(...)");
        SENSE = subtargetedModuleMethod;
        SubtargetedModuleMethod<IWorldLocation> subtargetedModuleMethod2 = SubtargetedModuleMethod.of("getMetaByID", PlethoraModules.SENSOR_M, IWorldLocation.class, "function(id:string):table|nil -- Find a nearby entity by UUID", INSTANCE::getMetaById);
        Intrinsics.checkNotNullExpressionValue(subtargetedModuleMethod2, (String)"of(...)");
        GET_META_BY_ID = subtargetedModuleMethod2;
        SubtargetedModuleMethod<IWorldLocation> subtargetedModuleMethod3 = SubtargetedModuleMethod.of("getMetaByName", PlethoraModules.SENSOR_M, IWorldLocation.class, "function(name:string):table|nil -- Find a nearby entity by name", INSTANCE::getMetaByName);
        Intrinsics.checkNotNullExpressionValue(subtargetedModuleMethod3, (String)"of(...)");
        GET_META_BY_NAME = subtargetedModuleMethod3;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0005H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0007H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J4\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0010\u0010\u001c\u001a\u00020\u001bH\u00d6\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u001d\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001e\u001a\u0004\b\u0004\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001f\u001a\u0004\b\u0006\u0010\u000eR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010 \u001a\u0004\b\b\u0010\u0010\u00a8\u0006!"}, d2={"Lio/sc3/plethora/gameplay/modules/sensor/SensorMethods$SensorMethodContext;", "Ljava/lang/Record;", "Lio/sc3/plethora/api/method/IContext;", "Lio/sc3/plethora/api/module/IModuleContainer;", "context", "Lio/sc3/plethora/api/IWorldLocation;", "loc", "Lio/sc3/plethora/gameplay/modules/RangeInfo;", "range", "<init>", "(Lio/sc3/plethora/api/method/IContext;Lio/sc3/plethora/api/IWorldLocation;Lio/sc3/plethora/gameplay/modules/RangeInfo;)V", "component1", "()Lio/sc3/plethora/api/method/IContext;", "component2", "()Lio/sc3/plethora/api/IWorldLocation;", "component3", "()Lio/sc3/plethora/gameplay/modules/RangeInfo;", "copy", "(Lio/sc3/plethora/api/method/IContext;Lio/sc3/plethora/api/IWorldLocation;Lio/sc3/plethora/gameplay/modules/RangeInfo;)Lio/sc3/plethora/gameplay/modules/sensor/SensorMethods$SensorMethodContext;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lio/sc3/plethora/api/method/IContext;", "Lio/sc3/plethora/api/IWorldLocation;", "Lio/sc3/plethora/gameplay/modules/RangeInfo;", "GitHub2"})
    private static final class SensorMethodContext
    extends Record {
        @NotNull
        private final IContext<IModuleContainer> context;
        @NotNull
        private final IWorldLocation loc;
        @NotNull
        private final RangeInfo range;

        public SensorMethodContext(@NotNull IContext<IModuleContainer> context, @NotNull IWorldLocation loc, @NotNull RangeInfo range) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            this.context = context;
            this.loc = loc;
            this.range = range;
        }

        @NotNull
        public final IContext<IModuleContainer> context() {
            return this.context;
        }

        @NotNull
        public final IWorldLocation loc() {
            return this.loc;
        }

        @NotNull
        public final RangeInfo range() {
            return this.range;
        }

        @NotNull
        public final IContext<IModuleContainer> component1() {
            return this.context;
        }

        @NotNull
        public final IWorldLocation component2() {
            return this.loc;
        }

        @NotNull
        public final RangeInfo component3() {
            return this.range;
        }

        @NotNull
        public final SensorMethodContext copy(@NotNull IContext<IModuleContainer> context, @NotNull IWorldLocation loc, @NotNull RangeInfo range) {
            Intrinsics.checkNotNullParameter(context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            return new SensorMethodContext(context, loc, range);
        }

        public static /* synthetic */ SensorMethodContext copy$default(SensorMethodContext sensorMethodContext, IContext iContext, IWorldLocation iWorldLocation, RangeInfo rangeInfo, int n, Object object) {
            if ((n & 1) != 0) {
                iContext = sensorMethodContext.context;
            }
            if ((n & 2) != 0) {
                iWorldLocation = sensorMethodContext.loc;
            }
            if ((n & 4) != 0) {
                rangeInfo = sensorMethodContext.range;
            }
            return sensorMethodContext.copy(iContext, iWorldLocation, rangeInfo);
        }

        @Override
        @NotNull
        public String toString() {
            return "SensorMethodContext(context=" + this.context + ", loc=" + this.loc + ", range=" + this.range + ")";
        }

        @Override
        public int hashCode() {
            int result = this.context.hashCode();
            result = result * 31 + this.loc.hashCode();
            result = result * 31 + this.range.hashCode();
            return result;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SensorMethodContext)) {
                return false;
            }
            SensorMethodContext sensorMethodContext = (SensorMethodContext)other;
            if (!Intrinsics.areEqual(this.context, sensorMethodContext.context)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.loc, (Object)sensorMethodContext.loc)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.range, (Object)sensorMethodContext.range);
        }
    }
}

