/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.gameplay.neural;

import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IDynamicPeripheral;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.impl.PocketUpgrades;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketsApi;
import io.sc3.plethora.Plethora;
import io.sc3.plethora.api.EntityWorldLocation;
import io.sc3.plethora.api.IWorldLocation;
import io.sc3.plethora.api.method.CostHelpers;
import io.sc3.plethora.api.method.IContextBuilder;
import io.sc3.plethora.api.method.IContextFactory;
import io.sc3.plethora.api.method.ICostHandler;
import io.sc3.plethora.api.module.BasicModuleContainer;
import io.sc3.plethora.api.module.IModuleAccess;
import io.sc3.plethora.api.module.IModuleContainer;
import io.sc3.plethora.api.module.IModuleHandler;
import io.sc3.plethora.api.reference.ConstantReference;
import io.sc3.plethora.api.reference.IReference;
import io.sc3.plethora.api.reference.Reference;
import io.sc3.plethora.core.AttachableWrapperPeripheral;
import io.sc3.plethora.core.Context;
import io.sc3.plethora.core.ContextFactory;
import io.sc3.plethora.core.MethodRegistry;
import io.sc3.plethora.core.RegisteredMethod;
import io.sc3.plethora.core.UnbakedContext;
import io.sc3.plethora.gameplay.modules.ModuleItem;
import io.sc3.plethora.gameplay.modules.ModulePeripheral;
import io.sc3.plethora.gameplay.neural.NeuralComputer;
import io.sc3.plethora.gameplay.neural.NeuralPocketAccess;
import io.sc3.plethora.gameplay.registry.Registration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class NeuralHelpers {
    public static final int MODULE_SIZE = 5;
    public static final int PERIPHERAL_SIZE = 5;
    public static final int INV_SIZE = 10;
    public static final int BACK = 2;

    public static Optional<class_3545<SlotReference, class_1799>> getSlot(class_1309 entity) {
        return TrinketsApi.getTrinketComponent((class_1309)entity).flatMap(c -> c.getEquipped((class_1792)Registration.ModItems.NEURAL_INTERFACE).stream().findFirst());
    }

    public static Optional<class_1799> getStack(class_1309 entity) {
        Optional<class_3545<SlotReference, class_1799>> slotPair = NeuralHelpers.getSlot(entity);
        return slotPair.map(class_3545::method_15441).filter(stack -> !stack.method_7960());
    }

    public static boolean isItemValid(int slot, @Nonnull class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (slot < 5) {
            class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
            UpgradeData upgrade = PocketUpgrades.instance().get(stack);
            return upgrade != null && Plethora.config.neuralInterface.peripheralItemIds.contains(id.toString());
        }
        return stack.method_7909() instanceof ModuleItem;
    }

    public static IPeripheral buildPeripheral(@Nonnull NeuralPocketAccess access, @Nonnull class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        UpgradeData upgrade = PocketUpgrades.instance().get(stack);
        if (upgrade == null) {
            return null;
        }
        return ((IPocketUpgrade)upgrade.upgrade()).createPeripheral((IPocketAccess)access);
    }

    public static IDynamicPeripheral buildModules(final NeuralComputer computer, final class_2371<class_1799> inventory2, class_1297 owner) {
        final class_2371 stacks = class_2371.method_10213((int)5, (Object)class_1799.field_8037);
        HashSet<class_2960> modules = new HashSet<class_2960>();
        HashSet<class_3545> moduleHandlers = new HashSet<class_3545>();
        final int moduleHash = computer.getModuleHash();
        for (int i2 = 0; i2 < 5; ++i2) {
            class_1799 stack = (class_1799)inventory2.get(5 + i2);
            if (stack.method_7960()) continue;
            stack = stack.method_7972();
            stacks.set(i2, (Object)stack);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof IModuleHandler)) continue;
            IModuleHandler moduleHandler = (IModuleHandler)class_17922;
            class_2960 module = moduleHandler.getModule();
            modules.add(module);
            moduleHandlers.add(new class_3545((Object)moduleHandler, (Object)stack));
        }
        if (modules.isEmpty()) {
            return null;
        }
        final BasicModuleContainer container = new BasicModuleContainer(modules);
        HashMap<class_2960, NeuralAccess> accessMap = new HashMap<class_2960, NeuralAccess>();
        ICostHandler cost = CostHelpers.getCostHandler(owner);
        ConstantReference<IModuleContainer> containerRef2 = new ConstantReference<IModuleContainer>(){

            @Override
            @Nonnull
            public IModuleContainer get() throws LuaException {
                for (int i2 = 0; i2 < 5; ++i2) {
                    class_1799 oldStack = (class_1799)stacks.get(i2);
                    class_1799 newStack = (class_1799)inventory2.get(5 + i2);
                    if (oldStack.method_7960() || class_1799.method_7984((class_1799)oldStack, (class_1799)newStack)) continue;
                    IModuleHandler moduleHandler = (IModuleHandler)oldStack.method_7909();
                    throw new LuaException("The " + String.valueOf(moduleHandler.getModule()) + " module has been removed");
                }
                return container;
            }

            @Override
            @Nonnull
            public IModuleContainer safeGet() throws LuaException {
                if (moduleHash != computer.getModuleHash()) {
                    throw new LuaException("A module has changed");
                }
                return container;
            }
        };
        IContextFactory builder = ((ContextFactory)((ContextFactory)((ContextFactory)ContextFactory.of(container, containerRef2).withCostHandler(cost)).withModules((IModuleContainer)container, containerRef2)).addContext("origin", new EntityWorldLocation(owner))).addContext("origin", owner, (IReference)Reference.entity(owner));
        for (class_3545 handler : moduleHandlers) {
            class_2960 module = ((IModuleHandler)handler.method_15442()).getModule();
            NeuralAccess access = (NeuralAccess)accessMap.get(module);
            if (access == null) {
                access = new NeuralAccess(owner, computer, (IModuleHandler)handler.method_15442(), container);
                accessMap.put(module, access);
            }
            ((IModuleHandler)handler.method_15442()).getAdditionalContext((class_1799)handler.method_15441(), access, (IContextBuilder)((Object)builder));
        }
        class_3545<List<RegisteredMethod<?>>, List<UnbakedContext<?>>> paired = MethodRegistry.instance.getMethodsPaired((Context<?>)((ContextFactory)builder).getBaked());
        if (((List)paired.method_15442()).isEmpty()) {
            return null;
        }
        ModulePeripheral peripheral = new ModulePeripheral("neuralInterface", owner, paired, computer.getExecutor(), ((ContextFactory)builder).getAttachments(), moduleHash);
        for (NeuralAccess access : accessMap.values()) {
            access.wrapper = peripheral;
        }
        return peripheral;
    }

    private static final class NeuralAccess
    implements IModuleAccess {
        private AttachableWrapperPeripheral wrapper;
        private final class_1297 owner;
        private final NeuralComputer computer;
        private final class_2960 module;
        private final IModuleContainer container;
        private final IWorldLocation location;

        private NeuralAccess(class_1297 owner, NeuralComputer computer, IModuleHandler module, IModuleContainer container) {
            this.owner = owner;
            this.computer = computer;
            this.module = module.getModule();
            this.container = container;
            this.location = new EntityWorldLocation(owner);
        }

        @Override
        @Nonnull
        public Object getOwner() {
            return this.owner;
        }

        @Override
        @Nonnull
        public IWorldLocation getLocation() {
            return this.location;
        }

        @Override
        @Nonnull
        public IModuleContainer getContainer() {
            return this.container;
        }

        @Override
        @Nonnull
        public class_2487 getData() {
            return Objects.requireNonNull(this.computer.getModuleData(this.module));
        }

        @Override
        @Nonnull
        public MinecraftServer getServer() {
            return Objects.requireNonNull(this.owner.method_5682());
        }

        @Override
        public void markDataDirty() {
            this.computer.markModuleDataDirty();
        }

        @Override
        public void queueEvent(@Nonnull String event, Object ... args) {
            if (this.wrapper != null) {
                this.wrapper.queueEvent(event, args);
            }
        }
    }
}

