/*
 * Decompiled with CFR 0.152.
 */
package io.sc3.plethora.integration;

import com.mojang.authlib.GameProfile;
import dan200.computercraft.api.lua.LuaException;
import io.sc3.plethora.api.IPlayerOwnable;
import io.sc3.plethora.api.reference.ConstantReference;
import io.sc3.plethora.util.EntityHelpers;
import java.util.Objects;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001!B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001b\b\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0004\u0010\nJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u000f\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001a\u001a\u00020\u0000H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0011R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\t\u001a\u0004\u0018\u00010\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\u001e\u001a\u0004\b\u001f\u0010 \u00a8\u0006\""}, d2={"Lio/sc3/plethora/integration/EntityIdentifier;", "Lio/sc3/plethora/api/reference/ConstantReference;", "Lnet/minecraft/class_1297;", "entity", "<init>", "(Lnet/minecraft/class_1297;)V", "Ljava/util/UUID;", "id", "", "name", "(Ljava/util/UUID;Ljava/lang/String;)V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "get", "()Lio/sc3/plethora/integration/EntityIdentifier;", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_1309;", "getEntity", "(Lnet/minecraft/server/MinecraftServer;)Lnet/minecraft/class_1309;", "", "hashCode", "()I", "safeGet", "Ljava/util/UUID;", "getId", "()Ljava/util/UUID;", "Ljava/lang/String;", "getName", "()Ljava/lang/String;", "Player", "GitHub2"})
public class EntityIdentifier
implements ConstantReference<EntityIdentifier> {
    @NotNull
    private final UUID id;
    @Nullable
    private final String name;

    private EntityIdentifier(UUID id, String name) {
        this.id = id;
        this.name = name;
    }

    @NotNull
    public final UUID getId() {
        return this.id;
    }

    @Nullable
    public final String getName() {
        return this.name;
    }

    public EntityIdentifier(@NotNull class_1297 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        UUID uUID = entity.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        this(uUID, null);
    }

    @Override
    @NotNull
    public EntityIdentifier get() {
        return this;
    }

    @Override
    @NotNull
    public EntityIdentifier safeGet() {
        return this;
    }

    @NotNull
    public final class_1309 getEntity(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        class_1297 class_12972 = EntityHelpers.getEntityFromUuid(server, this.id);
        class_1309 class_13092 = class_12972 instanceof class_1309 ? (class_1309)class_12972 : null;
        if (class_13092 == null) {
            throw new LuaException("Cannot find entity");
        }
        return class_13092;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        EntityIdentifier that = (EntityIdentifier)other;
        return Intrinsics.areEqual((Object)this.id, (Object)that.id) && Intrinsics.areEqual((Object)this.name, (Object)that.name);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.id, this.name};
        return Objects.hash(objectArray);
    }

    public /* synthetic */ EntityIdentifier(UUID id, String name, DefaultConstructorMarker $constructor_marker) {
        this(id, name);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/sc3/plethora/integration/EntityIdentifier$Player;", "Lio/sc3/plethora/integration/EntityIdentifier;", "Lio/sc3/plethora/api/IPlayerOwnable;", "Lcom/mojang/authlib/GameProfile;", "profile", "<init>", "(Lcom/mojang/authlib/GameProfile;)V", "getOwningProfile", "()Lcom/mojang/authlib/GameProfile;", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_3222;", "getPlayer", "(Lnet/minecraft/server/MinecraftServer;)Lnet/minecraft/class_3222;", "Lcom/mojang/authlib/GameProfile;", "GitHub2"})
    public static final class Player
    extends EntityIdentifier
    implements IPlayerOwnable {
        @NotNull
        private final GameProfile profile;

        public Player(@NotNull GameProfile profile) {
            Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
            UUID uUID = profile.getId();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getId(...)");
            super(uUID, profile.getName(), null);
            this.profile = profile;
        }

        @Override
        @NotNull
        public GameProfile getOwningProfile() {
            return this.profile;
        }

        @NotNull
        public final class_3222 getPlayer(@NotNull MinecraftServer server) {
            Intrinsics.checkNotNullParameter((Object)server, (String)"server");
            class_3222 class_32222 = server.method_3760().method_14602(this.profile.getId());
            if (class_32222 == null) {
                throw new LuaException("Player is not online");
            }
            return class_32222;
        }
    }
}

